"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsToPipesToStepfunctions = exports.PipesLogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const defaults = require("@aws-solutions-constructs/core");
var core_1 = require("@aws-solutions-constructs/core");
Object.defineProperty(exports, "PipesLogLevel", { enumerable: true, get: function () { return core_1.PipesLogLevel; } });
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class SqsToPipesToStepfunctions extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the SqsToPipesToStepfunctions class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {SqsToPipesToStepfunctionsProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckStateMachineProps(props);
        defaults.CheckSqsProps(props);
        defaults.CheckPipesProps(props);
        // Create the Queue
        // Setup the queue
        const buildQueueResponse = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount,
            enableEncryptionWithCustomerManagedKey: props.encryptQueueWithCmk,
            encryptionKey: props.existingQueueEncryptionKey,
            encryptionKeyProps: props.queueEncryptionKeyProps
        });
        this.sqsQueue = buildQueueResponse.queue;
        this.deadLetterQueue = buildQueueResponse.dlq;
        // Create the State Machine
        if (!props.existingStateMachineObj) {
            const buildStateMachineResponse = defaults.buildStateMachine(this, defaults.idPlaceholder, {
                stateMachineProps: props.stateMachineProps, // CheckStateMachineProps ensures this is defined if existingStateMachineObj is not
                logGroupProps: props.logGroupProps,
                createCloudWatchAlarms: props.createCloudWatchAlarms,
            });
            this.stateMachine = buildStateMachineResponse.stateMachine;
            this.stateMachineLogGroup = buildStateMachineResponse.logGroup;
            this.cloudwatchAlarms = buildStateMachineResponse.cloudWatchAlarms;
        }
        else {
            this.stateMachine = props.existingStateMachineObj;
        }
        // Create the pipe to connect the queue and state machine
        const buildPipeResponse = defaults.BuildPipe(this, id, {
            source: defaults.CreateSqsSource(this.sqsQueue, props.pipeProps?.sourceParameters),
            target: defaults.CreateStateMachineTarget(this.stateMachine, props.pipeProps?.targetParameters),
            enrichmentFunction: props.enrichmentFunction,
            enrichmentStateMachine: props.enrichmentStateMachine,
            clientProps: props.pipeProps,
            logLevel: props.logLevel,
            pipeLogProps: props.pipeLogProps
        });
        this.pipe = buildPipeResponse.pipe;
        this.pipeRole = buildPipeResponse.pipeRole;
        defaults.addCfnGuardSuppressRules(this.pipeRole, ["IAM_NO_INLINE_POLICY_CHECK"]);
    }
}
exports.SqsToPipesToStepfunctions = SqsToPipesToStepfunctions;
_a = JSII_RTTI_SYMBOL_1;
SqsToPipesToStepfunctions[_a] = { fqn: "@aws-solutions-constructs/aws-sqs-pipes-stepfunctions.SqsToPipesToStepfunctions", version: "2.85.6" };
//# sourceMappingURL=data:application/json;base64,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