"""
Generated by 'django-admin startproject' using Django 3.0.5.
"""

import os
from typing import List
from django.utils.crypto import get_random_string

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
SECRET_KEY = get_random_string(length=32)

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []  # type: List[str]

INSTALLED_APPS = [
    'tests.no_salesforce',
    # 'tests.test_default_db',
]
if os.environ.get('SF_WITH_EXAMPLE') == 'on':
    INSTALLED_APPS.append('salesforce.testrunner.example')

ROOT_URLCONF = None

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}


TIME_ZONE = 'UTC'
USE_TZ = True
STATIC_URL = '/static/'
DEFAULT_AUTO_FIELD = 'django.db.models.AutoField'
SALESFORCE_DB_ALIAS = 'default'
SF_EXAMPLE_EXTENDED_MODELS = True
SF_EXAMPLE_CUSTOM_INSTALLED = True
