from abc import (
    ABCMeta,
)
from pydantic.fields import (
    Field,
)
from typing import (
    TYPE_CHECKING,
)

from uploader_client.const import (
    DEFAULT_DATAMART_URL,
    DEFAULT_MAX_CONNECTIONS,
    DEFAULT_MAX_KEEPALIVE_CONNECTIONS,
    DEFAULT_POOL_TIMEOUT,
    DEFAULT_REQUEST_RETRIES,
    DEFAULT_REQUEST_TIMEOUT,
    DEFAULT_RETRY_FACTOR,
    NO_RETRY_STATUS_CODES,
)


if TYPE_CHECKING:
    from dataclasses import (
        dataclass,
    )
else:
    from pydantic.dataclasses import (
        dataclass,
    )


class AbstractConfig(metaclass=ABCMeta):
    """
    Абстрактный конфиг.
    """


@dataclass
class Config(AbstractConfig):
    """Объект конфигурации."""

    url: str = Field(
        title='Адрес (schema://host:post)',
        default=DEFAULT_DATAMART_URL,
        min_length=1,
    )

    datamart_name: str = Field(
        title='Мнемоника витрины',
        min_length=1,
    )

    request_retries: int = Field(
        title='Количество повторных попыток',
        default=DEFAULT_REQUEST_RETRIES,
    )

    retry_factor: int = Field(
        title='Шаг увеличения задержки м.д. запросами',
        default=DEFAULT_RETRY_FACTOR,
    )

    timeout: int = Field(
        title='Таймаут запроса, сек',
        default=DEFAULT_REQUEST_TIMEOUT,
    )

    max_connections: int = Field(
        title='Максимальное количество одновременных соединений',
        default=DEFAULT_MAX_CONNECTIONS,
    )

    max_keepalive_connections: int = Field(
        title='Максимальное количество keep-alive соединений в пуле',
        default=DEFAULT_MAX_KEEPALIVE_CONNECTIONS,
    )

    pool_timeout: float = Field(
        title='Таймаут ожидания свободного соединения из пула, сек',
        default=DEFAULT_POOL_TIMEOUT,
    )
    no_retry_status_codes: tuple[int, ...] = Field(
        title='Коды статусов, для которых не будут повторяться запросы',
        default=NO_RETRY_STATUS_CODES,
    )

    interface: str = 'uploader_client.interfaces.rest.OpenAPIInterface'

    logger: str = 'uploader_client.logging.db.Logger'
