# Generated by Django 4.2.16 on 2025-01-22 08:48

import django.db.models.deletion
from django.db import migrations, models

import datashow.models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Column",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Internal name of the column.",
                        max_length=255,
                        verbose_name="Name",
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        help_text="Displayed label of the column.",
                        max_length=255,
                        verbose_name="Label",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(
                        default=0,
                        help_text="Order of the column.",
                        verbose_name="Order",
                    ),
                ),
                (
                    "visible",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates whether the column is visible in table view.",
                        verbose_name="Visible",
                    ),
                ),
                (
                    "visible_detail",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates whether the column is visible in detail view.",
                        verbose_name="Visible in detail",
                    ),
                ),
                (
                    "sortable",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether the column is sortable.",
                        verbose_name="Sortable",
                    ),
                ),
                (
                    "searchable",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates whether the column is included in search queries.",
                        verbose_name="Searchable",
                    ),
                ),
                (
                    "prefix",
                    datashow.models.NonStrippingCharField(
                        blank=True,
                        help_text="Prefix when outputting the column value.",
                        max_length=255,
                        verbose_name="Prefix",
                    ),
                ),
                (
                    "postfix",
                    datashow.models.NonStrippingCharField(
                        blank=True,
                        help_text="Postfix when outputting the column value.",
                        max_length=255,
                        verbose_name="Postfix",
                    ),
                ),
                (
                    "formatter",
                    models.CharField(
                        choices=[
                            ("plaintext", "Plaintext"),
                            ("float", "Float"),
                            ("integer", "Integer"),
                            ("date", "Date"),
                            ("datetime", "Date and time"),
                            ("boolean", "Boolean"),
                            ("link", "Link"),
                            ("summary", "Summary"),
                            ("abbreviation", "Abbreviation"),
                        ],
                        default="plaintext",
                        help_text="Formatter for the column.",
                        max_length=255,
                        verbose_name="Formatter",
                    ),
                ),
                (
                    "formatter_arguments",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Arguments for the formatter.",
                        verbose_name="Formatter Arguments",
                    ),
                ),
                (
                    "filter",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ilike", "Substring"),
                            ("integer_range", "Integer Range"),
                        ],
                        default="",
                        help_text="Filter function for the column.",
                        max_length=255,
                        verbose_name="Filter",
                    ),
                ),
                (
                    "filter_arguments",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Arguments for the selected filter.",
                        verbose_name="Filter Arguments",
                    ),
                ),
            ],
            options={
                "verbose_name": "Column",
                "verbose_name_plural": "Columns",
                "ordering": ("order",),
            },
        ),
        migrations.CreateModel(
            name="Dataset",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="The name of the dataset.",
                        max_length=255,
                        verbose_name="Name",
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Unique slug for the dataset.",
                        max_length=255,
                        unique=True,
                        verbose_name="Slug",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="Description for the dataset, default rendered as Markdown/HTML!",
                        verbose_name="Description",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="The date and time when the dataset was created.",
                        verbose_name="Created At",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="The date and time when the dataset was last updated.",
                        verbose_name="Updated At",
                    ),
                ),
                (
                    "public",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates whether the dataset is publicly accessible.",
                        verbose_name="Is public",
                    ),
                ),
                (
                    "listed",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates whether the dataset is listed.",
                        verbose_name="Is listed",
                    ),
                ),
                (
                    "sqlite_file",
                    models.FileField(
                        help_text="Upload the SQLite file for the dataset.",
                        storage=datashow.models.select_storage,
                        upload_to=datashow.models.get_sqlite_file_storage_path,
                        verbose_name="SQLite File",
                    ),
                ),
                (
                    "version",
                    models.IntegerField(
                        default=1,
                        help_text="The version number of the dataset.",
                        verbose_name="Version",
                    ),
                ),
            ],
            options={
                "verbose_name": "Dataset",
                "verbose_name_plural": "Datasets",
                "ordering": ("updated_at",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Table",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Internal name of the table.",
                        max_length=255,
                        verbose_name="Name",
                    ),
                ),
                ("slug", models.SlugField(max_length=255, verbose_name="Slug")),
                (
                    "label",
                    models.CharField(
                        blank=True,
                        help_text="Displayed label for the table.",
                        max_length=255,
                        verbose_name="Label",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="Description for the dataset, default rendered as Markdown/HTML!",
                        verbose_name="Description",
                    ),
                ),
                (
                    "row_count",
                    models.IntegerField(
                        default=0,
                        help_text="The number of rows in the table.",
                        verbose_name="Row Count",
                    ),
                ),
                (
                    "visible",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates whether the table is visible.",
                        verbose_name="Visible",
                    ),
                ),
                (
                    "row_label_template",
                    models.CharField(
                        blank=True,
                        help_text="Python format template for labeling rows.",
                        max_length=512,
                        verbose_name="Row label template",
                    ),
                ),
                (
                    "pagination_size",
                    models.PositiveIntegerField(
                        default=10,
                        help_text="The number of rows per page.",
                        verbose_name="Pagination Size",
                    ),
                ),
                (
                    "sql",
                    models.TextField(
                        blank=True,
                        help_text="Makes this table 'virtual' by representing this table with this SQL query.",
                        verbose_name="SQL representation",
                    ),
                ),
                (
                    "dataset",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tables",
                        to="datashow.dataset",
                        verbose_name="Dataset",
                    ),
                ),
                (
                    "primary_key",
                    models.ForeignKey(
                        blank=True,
                        help_text="For use in identifying rows in URLs.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="datashow.column",
                        verbose_name="Primary Key Column",
                    ),
                ),
            ],
            options={
                "verbose_name": "Table",
                "verbose_name_plural": "Tables",
                "ordering": ("name",),
            },
        ),
        migrations.AddField(
            model_name="dataset",
            name="default_table",
            field=models.ForeignKey(
                blank=True,
                help_text="The default table is displayed instead of a list of all tables.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="datashow.table",
                verbose_name="Default Table",
            ),
        ),
        migrations.AddField(
            model_name="column",
            name="table",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="columns",
                to="datashow.table",
                verbose_name="Table",
            ),
        ),
        migrations.AddConstraint(
            model_name="table",
            constraint=models.UniqueConstraint(
                fields=("dataset", "slug"), name="unique_table_slug"
            ),
        ),
        migrations.AddConstraint(
            model_name="table",
            constraint=models.UniqueConstraint(
                fields=("dataset", "name"), name="unique_table_name"
            ),
        ),
        migrations.AddConstraint(
            model_name="column",
            constraint=models.UniqueConstraint(
                fields=("table", "name"), name="unique_table_column_name"
            ),
        ),
    ]
