import tg
import libacr.model.core as m_core
import libacr.model.content as m_cms
import libacr.model.user_permission as m_perm
from tg.i18n import get_lang
import tw.api
from tw.jquery import jquery_js

def user_can_create_children_of_ancestors(target_page):
    if not tg.request.identity:
        return False

    user = tg.request.identity['user']
    permissions = m_core.DBSession.query(m_perm.AcrUserPermission).filter_by(page='all').filter_by(user_id=user.user_id).first()
    if permissions and permissions.can_create_children:
        return True

    if not target_page:
        return False

    for page in target_page.ancestors:
        permissions = m_core.DBSession.query(m_perm.AcrUserPermission).filter_by(page=page.url).filter_by(user_id=user.user_id).first()
        if permissions:
            if not permissions.can_create_children:
                return False
            else:
                return True

    return False

def user_can_edit(target_page):
    if not tg.request.identity:
        return False

    user = tg.request.identity['user']
    permissions = m_core.DBSession.query(m_perm.AcrUserPermission).filter_by(page='all').filter_by(user_id=user.user_id).first()
    if permissions and permissions.can_edit:
        return True

    if not target_page:
        return False

    permissions = m_core.DBSession.query(m_perm.AcrUserPermission).filter_by(page=target_page.url).filter_by(user_id=user.user_id).first()
    if permissions and permissions.can_edit:
        return True

    return False

def user_can_create_children_in_page(target_page):
    if not tg.request.identity:
        return False

    if target_page:
      user = tg.request.identity['user']
      permissions = m_core.DBSession.query(m_perm.AcrUserPermission).filter_by(page=target_page.url).filter_by(user_id=user.user_id).first()
      if permissions and permissions.can_create_children:
          return True

    return user_can_create_children_of_ancestors(target_page)

def user_can_modify(page):
    permission = user_can_edit(page)
    if not permission:
        permission = user_can_create_children_of_ancestors(page)

    return permission

def current_user_id():
    return tg.request.identity and tg.request.identity['user'].user_id or None

def language():
    langs = []

    lang = get_lang()
    if lang:
        langs.append(lang)

    for lang in tg.request.languages:
        try:
            ltype, lsubtype = lang.split('-', 1)
        except:
            ltype, lsubtype = lang, lang

        if ltype != lsubtype:
            langs.append(lang)
        langs.append(ltype)

    langs.append(tg.config.get('default_language', 'en'))
    return langs

def url(path, *args, **kwargs):
    acr_root = tg.config.get('acr_root', '')
    if path[0] == '/':
        path = acr_root + path
    path = tg.url(path, *args, **kwargs)
    return path

def rdisk_url(path, *args, **kwargs):
    rdisk_root = tg.config.get('rdisk_root', '')
    if path[0] == '/':
        path = rdisk_root + path
    path = tg.url(path, *args, **kwargs)
    return path


def get_page_from_urllist(args):
    try:
        page = None
        for arg in args:
            tmp_page = m_core.DBSession.query(m_cms.Page).filter_by(uri=arg)
            if page:
                tmp_page = tmp_page.filter_by(parent=page)
            page = tmp_page.first()
            if not page:
                break
    except:
        page = None

    return page

acr_js = tw.api.JSLink(modname=__name__, filename='static/acr.js')
gmap_js = tw.api.JSLink(modname=__name__, filename='static/gmap.js')
gallery_js = tw.api.JSLink(modname=__name__, filename='static/jquery.lightbox-0.5.min.js')
full_acr_js = tw.api.Resource(javascript=[acr_js, gmap_js, jquery_js, gallery_js])

basic_acr_css = tw.api.CSSLink(modname=__name__, filename='static/style.css')
gallery_css = tw.api.CSSLink(modname=__name__, filename='static/jquery.lightbox-0.5.css')
acr_css = tw.api.Resource(css=[basic_acr_css, gallery_css])
admin_css = tw.api.CSSLink(modname=__name__, filename='static/acr_admin.css')

class IconLink(tw.api.Link):
    """
    A link to an icon.
    """
    template = """<img src="$link" alt="$alt"/>"""

    params = dict(alt="Alternative text when not displaying image")

    def __init__(self, *args, **kw):
        super(IconLink, self).__init__(*args, **kw)
        self.alt = kw.get('alt')

icons = {
    'parent':IconLink(modname=__name__, filename='static/icons/parent.png', alt='Up'),
    'twitter':IconLink(modname=__name__, filename='static/icons/twitter.png', alt='Tweet!'),
    'file':IconLink(modname=__name__, filename='static/icons/file.png', alt='File'),
    'dir':IconLink(modname=__name__, filename='static/icons/dir.png', alt='Directory'),
    'create_page':IconLink(modname=__name__,
                           filename='static/icons/create_page.png', alt='Directory'),
    'manage_pages':IconLink(modname=__name__,
                            filename='static/icons/manage_pages.png', alt='Directory'),
    'create_node':IconLink(modname=__name__,
                           filename='static/icons/create_node.png', alt='Directory'),
    'unbound':IconLink(modname=__name__,
                       filename='static/icons/unbound.png', alt='Directory'),
    'remote_disk':IconLink(modname=__name__,
                        filename='static/icons/remote_disk.png', alt='Directory'),
    'themes':IconLink(modname=__name__,
                        filename='static/icons/themes.png', alt='Directory'),
    'tags':IconLink(modname=__name__,
                        filename='static/icons/tag.png', alt='Directory'),
    'help':IconLink(modname=__name__,
                        filename='static/icons/help.png', alt='Directory'),
    'slice_group':IconLink(modname=__name__,
                        filename='static/icons/slicegroup.png', alt='Directory'),
    'loading':IconLink(modname=__name__,
                        filename='static/icons/loading.gif', alt='Loading...'),
    'prev':IconLink(modname=__name__,
                        filename='static/icons/prev.gif', alt='Previous'),
    'next':IconLink(modname=__name__,
                        filename='static/icons/next.gif', alt='Next'),
    'close':IconLink(modname=__name__,
                        filename='static/icons/close.gif', alt='Close'),
    'blank':IconLink(modname=__name__,
                        filename='static/icons/blank.gif', alt='Blank'),
    'pdf':IconLink(modname=__name__,
                        filename='static/icons/iconPdf.png', alt='Pdf'),
    'audio':IconLink(modname=__name__,
                        filename='static/icons/iconAudio.jpg', alt='Audio'),
    'document':IconLink(modname=__name__,
                        filename='static/icons/iconDocument.png', alt='Document')
}

