/**
 * jQuery Clock plugin
 * Copyright (c) 2010 John R D'Orazio (priest@johnromanodorazio.com)
 * Licensed under the Apache 2.0 license:
 * https://www.apache.org/licenses/LICENSE-2.0
 */
Date.prototype.hasOwnProperty("stdTimezoneOffset")||(Date.prototype.stdTimezoneOffset=function(){var b=this.getFullYear();if(!Date.prototype.stdTimezoneOffset.cache.hasOwnProperty(b)){for(var d=(new Date(b,0,1)).getTimezoneOffset(),h=[6,7,5,8,4,9,3,10,2,11,1],a=0;12>a;a++){var m=(new Date(b,h[a],1)).getTimezoneOffset();if(m!=d){d=Math.max(d,m);break}}Date.prototype.stdTimezoneOffset.cache[b]=d}return Date.prototype.stdTimezoneOffset.cache[b]},Date.prototype.stdTimezoneOffset.cache={});
Date.prototype.hasOwnProperty("isDST")||(Date.prototype.isDST=function(){return this.getTimezoneOffset()<this.stdTimezoneOffset()});Date.prototype.hasOwnProperty("isLeapYear")||(Date.prototype.isLeapYear=function(){var b=this.getFullYear();return 0!=(b&3)?!1:0!=b%100||0==b%400});Date.prototype.hasOwnProperty("getDOY")||(Date.prototype.getDOY=function(){var b=this.getMonth(),d=this.getDate(),d=[0,31,59,90,120,151,181,212,243,273,304,334][b]+d;1<b&&this.isLeapYear()&&d++;return d});
Date.prototype.hasOwnProperty("daysInMonth")||(Date.prototype.daysInMonth=function(){return[31,this.isLeapYear()?29:28,31,30,31,30,31,31,30,31,30,31][this.getMonth()]});Date.prototype.hasOwnProperty("getWOY")||(Date.prototype.getWOY=function(b){var d=new Date(+this);d.setHours(0,0,0,0);d.setDate(d.getDate()+4-(d.getDay()||7));return b?d.getFullYear():Math.ceil(((d-new Date(d.getFullYear(),0,1))/864E5+1)/7)});
Date.prototype.hasOwnProperty("swatchTime")||(Date.prototype.swatchTime=function(){return("00"+Math.floor((60*((this.getUTCHours()+1)%24*60+this.getUTCMinutes())+this.getUTCSeconds()+.001*this.getUTCMilliseconds())/86.4)).slice(-3)});String.prototype.padStart||(String.prototype.padStart=function(b,d){b>>=0;d=String(d||" ");if(this.length>b)return String(this);b-=this.length;b>d.length&&(d+=d.repeat(b/d.length));return d.slice(0,b)+String(this)});
(function(b,d){b.clock={version:"2.3.0",options:[{type:"string",value:"destroy",description:"Passing in 'destroy' to an already initialized clock will remove the setTimeout for that clock to stop it from ticking, and remove all html markup and data associated with the plugin instance on the dom elements"},{type:"string",value:"stop",description:"Passing in 'stop' to an already initialized clock will clear the setTimeout for that clock to stop it from ticking"},{type:"string",value:"start",description:"Passing in 'start' to an already initialized clock will restart the setTimeout for that clock to get it ticking again, as though it had never lost time"},
{type:"object",description:"option set {}",values:[{name:"timestamp",description:"Either a javascript timestamp as produces by [JAVASCRIPT new Date().getTime()] or a php timestamp as produced by [PHP time()] ",type:"unix timestamp",values:["javascript timestamp","php timestamp"]},{name:"langSet",description:"two letter locale to be used for the translation of Day names and Month names",type:"String",values:"am ar bn bg ca zh hr cs da nl en et fi fr de el gu hi hu id it ja kn ko lv lt ms ml mr mo ps fa pl pt ro ru sr sk sl es sw sv ta te th tr uk vi".split(" ")},
{name:"calendar",description:"Whether the date should be displayed together with the time",type:"Boolean",values:[!0,!1]},{name:"dateFormat",description:"PHP Style Format string for formatting a local date, see http://php.net/manual/en/function.date.php",type:"String",values:"dDjlNSwzWFmMntLoYy".split("")},{name:"timeFormat",description:"PHP Style Format string for formatting a local date, see http://php.net/manual/en/function.date.php",type:"String",values:"aABgGhHisveIOPZcrU".split("")},{name:"isDST",
description:"When a client side timestamp is used, whether DST is active will be automatically determined. However this cannot be determined for a server-side timestamp which must be passed in as UTC, in that can case it can be set with this option",type:"Boolean",values:[!0,!1]},{name:"rate",description:"Defines the rate at which the clock will update, in milliseconds",type:"Integer",values:"1 - 9007199254740991 (recommended 10-60000)"}]}],methods:{destroy:"Chaining clock().destroy() has the same effect as passing the 'destroy' option as in clock('destroy')",
stop:"Chaining clock().stop() has the same effect as passing the 'stop' option as in clock('stop')",start:"Chaining clock().start() has the same effect as passing the 'start' option as in clock('start')"}};Object.freeze(b.clock);var h=h||{};b.fn.clock=function(a){var m=this;this.initialize=function(){return this};this.destroy=function(){return m.each(function(a){a=b(this).attr("id");h.hasOwnProperty(a)&&(clearTimeout(h[a]),delete h[a]);b(this).html("");b(this).hasClass("jqclock")&&b(this).removeClass("jqclock");
b(this).removeData("clockoptions")})};this.stop=function(){return m.each(function(a){a=b(this).attr("id");h.hasOwnProperty(a)&&(clearTimeout(h[a]),delete h[a])})};this.start=function(){return m.each(function(a){a=b(this).attr("id");var c=b(this).data("clockoptions");if(c!==d&&!1===h.hasOwnProperty(a)){var g=this;h[a]=setTimeout(function(){x(b(g))},c.rate)}})};var B=function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=16*Math.random()|0;return("x"==a?b:b&3|8).toString(16)}).toUpperCase()},
x=function(a){var c=b(a).data("clockoptions"),d=(new Date).getTime()+c.sysdiff,k=new Date(d),g=k.getHours(),m=k.getMinutes(),C=k.getSeconds(),B=k.getMilliseconds(),e=k.getDay(),l=k.getDate(),D=k.getMonth(),y=k.getFullYear(),p=k.isLeapYear(),w=k.getDOY(),q=k.getWOY(),v=k.getWOY(!0),G=k.daysInMonth(),H=k.swatchTime(),n=parseInt(c.tzOffset/60),z=parseInt(60*c.tzOffset),E="AM",f="",r="";11<g&&(E="PM");r=g;12<r?r-=12:0===r&&(r=12);if(!0===c.calendar){for(var f="",t=0;t<=c.dateFormat.length;t++){var F=
c.dateFormat.charAt(t);switch(F){case "d":f+=(""+l).padStart(2,"0");break;case "D":f+=(new Intl.DateTimeFormat(c.langSet,{weekday:"short"})).format(k);break;case "j":f+=l;break;case "l":f+=(new Intl.DateTimeFormat(c.langSet,{weekday:"long"})).format(k);break;case "N":f+=0===e?7:e;break;case "S":f+=1===l||1===l%10&&11!=l?"st":2===l||2===l%10&&12!=l?"nd":3===l||3===l%10&&13!=l?"rd":"th";break;case "w":f+=e;break;case "z":f+=w-1;break;case "W":f+=q;break;case "F":f+=(new Intl.DateTimeFormat(c.langSet,
{month:"long"})).format(k);break;case "m":f+=(D+1+"").padStart(2,"0");break;case "M":f+=(new Intl.DateTimeFormat(c.langSet,{month:"short"})).format(k);break;case "n":f+=D+1;break;case "t":f+=G;break;case "L":f+=p?1:0;break;case "o":f+=v;break;case "Y":f+=y;break;case "y":f+=y.toString().substr(2,2);break;case String.fromCharCode(92):f+=c.dateFormat.charAt(++t);break;case "%":for(var u=t+1,A=c.dateFormat;u<A.length&&"%"!=A.charAt(u);)u++;u>t+1&&u!=A.length?(f+=A.substring(t+1,u),t+=u-t):f+=F;break;
default:f+=F}}f='<span class="clockdate">'+f+"</span>"}e="";for(p=0;p<=c.timeFormat.length;p++)switch(w=c.timeFormat.charAt(p),w){case "a":e+=E.toLowerCase();break;case "A":e+=E;break;case "B":e+=H;break;case "g":e+=r;break;case "G":e+=g;break;case "h":e+=(""+r).padStart(2,"0");break;case "H":e+=(""+g).padStart(2,"0");break;case "i":e+=(""+m).padStart(2,"0");break;case "s":e+=(""+C).padStart(2,"0");break;case "v":e+=(""+B).padStart(3,"0");break;case "e":e+=c.timezone;break;case "I":e+=c.isDST?"DST":
"";break;case "O":e+=(0>n?"+"+(""+Math.abs(n)).padStart(2,"0"):0<n?(""+-1*n).padStart(2,"0"):"+00")+"00";break;case "P":e+=(0>n?"+"+(""+Math.abs(n)).padStart(2,"0"):0<n?(""+-1*n).padStart(2,"0"):"+00")+":00";break;case "Z":e+=0>z?""+Math.abs(z):0<z?""+-1*z:"0";break;case "c":e+=y+"-"+(D+1+"").padStart(2,"0")+"-"+(""+l).padStart(2,"0")+"T"+(""+g).padStart(2,"0")+":"+(""+m).padStart(2,"0")+":"+(""+C).padStart(2,"0")+(0>n?"+"+(""+Math.abs(n)).padStart(2,"0"):0<tzh?(""+-1*tzh).padStart(2,"0"):"+00")+
":00";break;case "r":e+=(new Intl.DateTimeFormat(c.langSet,{weekday:"short"})).format(k)+", "+l+" "+(new Intl.DateTimeFormat(c.langSet,{month:"short"})).format(k)+" "+y+" "+(""+g).padStart(2,"0")+":"+(""+m).padStart(2,"0")+":"+(""+C).padStart(2,"0")+" "+(0>n?"+"+(""+Math.abs(n)).padStart(2,"0"):0<tzh?(""+-1*tzh).padStart(2,"0"):"+00")+"00";break;case "U":e+=Math.floor(d/1E3);break;case String.fromCharCode(92):e+=c.timeFormat.charAt(++p);break;case "%":q=p+1;for(v=c.timeFormat;q<v.length&&"%"!=v.charAt(q);)q++;
q>p+1&&q!=v.length?(e+=v.substring(p+1,q),p+=q-p):e+=w;break;default:e+=w}r='<span class="clocktime">'+e+"</span>";b(a).html(f+r);d=b(a).attr("id");h[d]=setTimeout(function(){x(b(a))},c.rate)};this.each(function(g){if("undefined"===typeof a||"object"===typeof a){g=new Date;a=a||{};a.timestamp=a.timestamp||"localsystime";a.langSet=a.langSet||"en";a.calendar=a.hasOwnProperty("calendar")?a.calendar:!0;a.dateFormat=a.dateFormat||("en"==a.langSet?"l, F j, Y":"l, j F Y");a.timeFormat=a.timeFormat||("en"==
a.langSet?"h:i:s A":"H:i:s");a.timezone=a.timezone||"localsystimezone";a.isDST=a.hasOwnProperty("isDST")?a.isDST:g.isDST();a.rate=a.rate||500;"string"!==typeof a.langSet&&(a.langSet=""+a.langSet);"string"===typeof a.calendar?a.calendar="false"==a.calendar?!1:!0:"boolean"!==typeof a.calendar&&(a.calendar=!!a.calendar);"string"!==typeof a.dateFormat&&(a.dateFormat=""+a.dateFormat);"string"!==typeof a.timeFormat&&(a.timeFormat=""+a.dateFormat);"string"!==typeof a.timezone&&(a.timezone=""+a.timezone);
"string"===typeof a.isDST?a.isDST="true"==a.isDST?!0:!1:"boolean"!==typeof a.isDST&&(a.isDST=!!a.isDST);"number"!==typeof a.rate&&(a.rate=parseInt(a.rate));a.tzOffset=g.getTimezoneOffset();var c=a.tzOffset/60;a.sysdiff=0;"localsystime"!=a.timestamp?2<(g.getTime()+"").length-(a.timestamp+"").length?(a.timestamp*=1E3,a.sysdiff=a.timestamp-g.getTime()+6E4*a.tzOffset):(a.sysdiff=a.timestamp-g.getTime(),"localsystimezone"==a.timezone&&(a.timezone="UTC",0>c?a.timezone+="+"+Math.abs(c):0<c&&(a.timezone+=
-1*c))):"localsystimezone"==a.timezone&&(a.timezone="UTC",0>c?a.timezone+="+"+Math.abs(c):0<c&&(a.timezone+=-1*c));b(this).hasClass("jqclock")||b(this).addClass("jqclock");b(this).is("[id]")||b(this).attr("id",B());b(this).data("clockoptions",a);!1===h.hasOwnProperty(b(this).attr("id"))&&x(b(this))}else if("string"===typeof a)switch(g=b(this).attr("id"),a){case "destroy":h.hasOwnProperty(g)&&(clearTimeout(h[g]),delete h[g]);b(this).html("");b(this).hasClass("jqclock")&&b(this).removeClass("jqclock");
b(this).removeData("clockoptions");break;case "stop":h.hasOwnProperty(g)&&(clearTimeout(h[g]),delete h[g]);break;case "start":var m=this,c=b(this).data("clockoptions");c!==d&&!1===h.hasOwnProperty(g)&&(h[g]=setTimeout(function(){x(b(m))},c.rate))}});return this.initialize()};return this})(jQuery);
