# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

"""Serialized DAG and BaseOperator"""
from typing import Union

from airflow.settings import json


def serialize_template_field(template_field):
    # type: (dict) -> Union[str, dict]
    """
    Return a serializable representation of the templated_field.
    If a templated_field contains a Class or Instance for recursive templating, store them
    as strings. If the templated_field is not recursive return the field

    :param template_field: Task's Templated Field
    """

    def is_jsonable(x):
        try:
            json.dumps(x)
            return True
        except (TypeError, OverflowError):
            return False

    if not is_jsonable(template_field):
        return str(template_field)
    else:
        return template_field
