"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-dynamodb';
const partitionKeyName = 'id';
const existingTableObj = new dynamodb.Table(stack, 'existing-table', {
    partitionKey: {
        name: partitionKeyName,
        type: dynamodb.AttributeType.STRING,
    },
    pointInTimeRecovery: true,
    encryption: dynamodb.TableEncryption.AWS_MANAGED,
    billingMode: dynamodb.BillingMode.PAY_PER_REQUEST
});
new lib_1.ApiGatewayToDynamoDB(stack, 'test-api-gateway-dynamodb-additional-request-templates', {
    existingTableObj,
    additionalReadRequestTemplates: {
        'text/plain': `{ \
      "TableName": "${existingTableObj.tableName}", \
      "KeyConditionExpression": "${partitionKeyName} = :v1", \
      "ExpressionAttributeValues": { \
        ":v1": { \
          "S": "$input.params('${partitionKeyName}')" \
        } \
      } \
    }`
    }
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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