"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-dynamodb';
const partitionKeyName = 'PK';
const sortKeyName = 'SK';
const resourceName = 'id';
const existingTableObj = new dynamodb.Table(stack, 'existing-table', {
    partitionKey: {
        name: partitionKeyName,
        type: dynamodb.AttributeType.STRING,
    },
    sortKey: {
        name: sortKeyName,
        type: dynamodb.AttributeType.STRING
    },
    pointInTimeRecovery: true,
    encryption: dynamodb.TableEncryption.AWS_MANAGED,
    billingMode: dynamodb.BillingMode.PAY_PER_REQUEST
});
new lib_1.ApiGatewayToDynamoDB(stack, 'test-api-gateway-dynamodb-additional-request-templates-custom-resource-name', {
    existingTableObj,
    resourceName,
    additionalReadRequestTemplates: {
        'text/plain': `{ \
      "TableName": "${existingTableObj.tableName}", \
      "KeyConditionExpression": "${partitionKeyName} = :v2 AND ${sortKeyName} = :v1", \
      "ExpressionAttributeValues": { \
        ":v1": { \
          "S": "$input.params('${resourceName}')" \
        }, \
        ":v2": { \
          "S": "MY_VALUE" \
        } \
      } \
    }`,
    }
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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