"""
split_in_for_each_range
=======================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class split_in_for_each_range(Operator):
    """Split a scoping into several pieces so you can iterate it with a
    for_each loop.

    Parameters
    ----------
    iterable : optional
        Iterable that can be combined with the one
        currently generated.
    operator_to_iterate : Operator
        Operator that must be reconnected with the
        range values.
    pin_index : int
    scoping : Scoping
    chunk_size : int


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.split_in_for_each_range()

    >>> # Make input connections
    >>> my_iterable = dpf.()
    >>> op.inputs.iterable.connect(my_iterable)
    >>> my_operator_to_iterate = dpf.Operator()
    >>> op.inputs.operator_to_iterate.connect(my_operator_to_iterate)
    >>> my_pin_index = int()
    >>> op.inputs.pin_index.connect(my_pin_index)
    >>> my_scoping = dpf.Scoping()
    >>> op.inputs.scoping.connect(my_scoping)
    >>> my_chunk_size = int()
    >>> op.inputs.chunk_size.connect(my_chunk_size)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.split_in_for_each_range(
    ...     iterable=my_iterable,
    ...     operator_to_iterate=my_operator_to_iterate,
    ...     pin_index=my_pin_index,
    ...     scoping=my_scoping,
    ...     chunk_size=my_chunk_size,
    ... )

    >>> # Get output data
    >>> result_output = op.outputs.output()
    """

    def __init__(
        self,
        iterable=None,
        operator_to_iterate=None,
        pin_index=None,
        scoping=None,
        chunk_size=None,
        config=None,
        server=None,
    ):
        super().__init__(name="chunk_in_for_each_range", config=config, server=server)
        self._inputs = InputsSplitInForEachRange(self)
        self._outputs = OutputsSplitInForEachRange(self)
        if iterable is not None:
            self.inputs.iterable.connect(iterable)
        if operator_to_iterate is not None:
            self.inputs.operator_to_iterate.connect(operator_to_iterate)
        if pin_index is not None:
            self.inputs.pin_index.connect(pin_index)
        if scoping is not None:
            self.inputs.scoping.connect(scoping)
        if chunk_size is not None:
            self.inputs.chunk_size.connect(chunk_size)

    @staticmethod
    def _spec():
        description = """Split a scoping into several pieces so you can iterate it with a
            for_each loop."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="iterable",
                    type_names=["any"],
                    optional=True,
                    document="""Iterable that can be combined with the one
        currently generated.""",
                ),
                1: PinSpecification(
                    name="operator_to_iterate",
                    type_names=["operator"],
                    optional=False,
                    document="""Operator that must be reconnected with the
        range values.""",
                ),
                2: PinSpecification(
                    name="pin_index",
                    type_names=["int32"],
                    optional=False,
                    document="""""",
                ),
                3: PinSpecification(
                    name="scoping",
                    type_names=["scoping"],
                    optional=False,
                    document="""""",
                ),
                4: PinSpecification(
                    name="chunk_size",
                    type_names=["int32"],
                    optional=False,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="output",
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="chunk_in_for_each_range", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsSplitInForEachRange
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsSplitInForEachRange
        """
        return super().outputs


class InputsSplitInForEachRange(_Inputs):
    """Intermediate class used to connect user inputs to
    split_in_for_each_range operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.split_in_for_each_range()
    >>> my_iterable = dpf.()
    >>> op.inputs.iterable.connect(my_iterable)
    >>> my_operator_to_iterate = dpf.Operator()
    >>> op.inputs.operator_to_iterate.connect(my_operator_to_iterate)
    >>> my_pin_index = int()
    >>> op.inputs.pin_index.connect(my_pin_index)
    >>> my_scoping = dpf.Scoping()
    >>> op.inputs.scoping.connect(my_scoping)
    >>> my_chunk_size = int()
    >>> op.inputs.chunk_size.connect(my_chunk_size)
    """

    def __init__(self, op: Operator):
        super().__init__(split_in_for_each_range._spec().inputs, op)
        self._iterable = Input(split_in_for_each_range._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._iterable)
        self._operator_to_iterate = Input(
            split_in_for_each_range._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._operator_to_iterate)
        self._pin_index = Input(split_in_for_each_range._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._pin_index)
        self._scoping = Input(split_in_for_each_range._spec().input_pin(3), 3, op, -1)
        self._inputs.append(self._scoping)
        self._chunk_size = Input(
            split_in_for_each_range._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._chunk_size)

    @property
    def iterable(self):
        """Allows to connect iterable input to the operator.

        Iterable that can be combined with the one
        currently generated.

        Parameters
        ----------
        my_iterable :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.split_in_for_each_range()
        >>> op.inputs.iterable.connect(my_iterable)
        >>> # or
        >>> op.inputs.iterable(my_iterable)
        """
        return self._iterable

    @property
    def operator_to_iterate(self):
        """Allows to connect operator_to_iterate input to the operator.

        Operator that must be reconnected with the
        range values.

        Parameters
        ----------
        my_operator_to_iterate : Operator

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.split_in_for_each_range()
        >>> op.inputs.operator_to_iterate.connect(my_operator_to_iterate)
        >>> # or
        >>> op.inputs.operator_to_iterate(my_operator_to_iterate)
        """
        return self._operator_to_iterate

    @property
    def pin_index(self):
        """Allows to connect pin_index input to the operator.

        Parameters
        ----------
        my_pin_index : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.split_in_for_each_range()
        >>> op.inputs.pin_index.connect(my_pin_index)
        >>> # or
        >>> op.inputs.pin_index(my_pin_index)
        """
        return self._pin_index

    @property
    def scoping(self):
        """Allows to connect scoping input to the operator.

        Parameters
        ----------
        my_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.split_in_for_each_range()
        >>> op.inputs.scoping.connect(my_scoping)
        >>> # or
        >>> op.inputs.scoping(my_scoping)
        """
        return self._scoping

    @property
    def chunk_size(self):
        """Allows to connect chunk_size input to the operator.

        Parameters
        ----------
        my_chunk_size : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.split_in_for_each_range()
        >>> op.inputs.chunk_size.connect(my_chunk_size)
        >>> # or
        >>> op.inputs.chunk_size(my_chunk_size)
        """
        return self._chunk_size


class OutputsSplitInForEachRange(_Outputs):
    """Intermediate class used to get outputs from
    split_in_for_each_range operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.split_in_for_each_range()
    >>> # Connect inputs : op.inputs. ...
    >>> result_output = op.outputs.output()
    """

    def __init__(self, op: Operator):
        super().__init__(split_in_for_each_range._spec().outputs, op)
        self._output = Output(split_in_for_each_range._spec().output_pin(0), 0, op)
        self._outputs.append(self._output)

    @property
    def output(self):
        """Allows to get output output of the operator

        Returns
        ----------
        my_output :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.split_in_for_each_range()
        >>> # Connect inputs : op.inputs. ...
        >>> result_output = op.outputs.output()
        """  # noqa: E501
        return self._output
