"""
remove_unnecessary_labels
=========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class remove_unnecessary_labels(Operator):
    """Removes the selected label from a fields container.

    Parameters
    ----------
    permissive : bool, optional
        If true, the operator does not throw an error
        if the label to be removed has more
        than one entry.
    fields_container : FieldsContainer
        Fields container with the label to be
        removed.
    label_to_remove : str
        Label to be removed from the fields
        container.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.remove_unnecessary_labels()

    >>> # Make input connections
    >>> my_permissive = bool()
    >>> op.inputs.permissive.connect(my_permissive)
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_label_to_remove = str()
    >>> op.inputs.label_to_remove.connect(my_label_to_remove)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.remove_unnecessary_labels(
    ...     permissive=my_permissive,
    ...     fields_container=my_fields_container,
    ...     label_to_remove=my_label_to_remove,
    ... )

    >>> # Get output data
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(
        self,
        permissive=None,
        fields_container=None,
        label_to_remove=None,
        config=None,
        server=None,
    ):
        super().__init__(name="remove_unnecessary_label", config=config, server=server)
        self._inputs = InputsRemoveUnnecessaryLabels(self)
        self._outputs = OutputsRemoveUnnecessaryLabels(self)
        if permissive is not None:
            self.inputs.permissive.connect(permissive)
        if fields_container is not None:
            self.inputs.fields_container.connect(fields_container)
        if label_to_remove is not None:
            self.inputs.label_to_remove.connect(label_to_remove)

    @staticmethod
    def _spec():
        description = """Removes the selected label from a fields container."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                -1: PinSpecification(
                    name="permissive",
                    type_names=["bool"],
                    optional=True,
                    document="""If true, the operator does not throw an error
        if the label to be removed has more
        than one entry.""",
                ),
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""Fields container with the label to be
        removed.""",
                ),
                1: PinSpecification(
                    name="label_to_remove",
                    type_names=["string"],
                    optional=False,
                    document="""Label to be removed from the fields
        container.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="remove_unnecessary_label", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsRemoveUnnecessaryLabels
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsRemoveUnnecessaryLabels
        """
        return super().outputs


class InputsRemoveUnnecessaryLabels(_Inputs):
    """Intermediate class used to connect user inputs to
    remove_unnecessary_labels operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.remove_unnecessary_labels()
    >>> my_permissive = bool()
    >>> op.inputs.permissive.connect(my_permissive)
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_label_to_remove = str()
    >>> op.inputs.label_to_remove.connect(my_label_to_remove)
    """

    def __init__(self, op: Operator):
        super().__init__(remove_unnecessary_labels._spec().inputs, op)
        self._permissive = Input(
            remove_unnecessary_labels._spec().input_pin(-1), -1, op, -1
        )
        self._inputs.append(self._permissive)
        self._fields_container = Input(
            remove_unnecessary_labels._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._fields_container)
        self._label_to_remove = Input(
            remove_unnecessary_labels._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._label_to_remove)

    @property
    def permissive(self):
        """Allows to connect permissive input to the operator.

        If true, the operator does not throw an error
        if the label to be removed has more
        than one entry.

        Parameters
        ----------
        my_permissive : bool

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.remove_unnecessary_labels()
        >>> op.inputs.permissive.connect(my_permissive)
        >>> # or
        >>> op.inputs.permissive(my_permissive)
        """
        return self._permissive

    @property
    def fields_container(self):
        """Allows to connect fields_container input to the operator.

        Fields container with the label to be
        removed.

        Parameters
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.remove_unnecessary_labels()
        >>> op.inputs.fields_container.connect(my_fields_container)
        >>> # or
        >>> op.inputs.fields_container(my_fields_container)
        """
        return self._fields_container

    @property
    def label_to_remove(self):
        """Allows to connect label_to_remove input to the operator.

        Label to be removed from the fields
        container.

        Parameters
        ----------
        my_label_to_remove : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.remove_unnecessary_labels()
        >>> op.inputs.label_to_remove.connect(my_label_to_remove)
        >>> # or
        >>> op.inputs.label_to_remove(my_label_to_remove)
        """
        return self._label_to_remove


class OutputsRemoveUnnecessaryLabels(_Outputs):
    """Intermediate class used to get outputs from
    remove_unnecessary_labels operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.remove_unnecessary_labels()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(self, op: Operator):
        super().__init__(remove_unnecessary_labels._spec().outputs, op)
        self._fields_container = Output(
            remove_unnecessary_labels._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._fields_container)

    @property
    def fields_container(self):
        """Allows to get fields_container output of the operator

        Returns
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.remove_unnecessary_labels()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields_container = op.outputs.fields_container()
        """  # noqa: E501
        return self._fields_container
