"""
merge_materials
===============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class merge_materials(Operator):
    """Assembles a set of materials into a unique one.

    Parameters
    ----------
    materials1 : Materials
        A vector of materials to merge or materials
        from pin 0 to ...
    materials2 : Materials
        A vector of materials to merge or materials
        from pin 0 to ...


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.merge_materials()

    >>> # Make input connections
    >>> my_materials1 = dpf.Materials()
    >>> op.inputs.materials1.connect(my_materials1)
    >>> my_materials2 = dpf.Materials()
    >>> op.inputs.materials2.connect(my_materials2)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.merge_materials(
    ...     materials1=my_materials1,
    ...     materials2=my_materials2,
    ... )

    >>> # Get output data
    >>> result_merged_materials = op.outputs.merged_materials()
    """

    def __init__(self, materials1=None, materials2=None, config=None, server=None):
        super().__init__(name="merge::materials", config=config, server=server)
        self._inputs = InputsMergeMaterials(self)
        self._outputs = OutputsMergeMaterials(self)
        if materials1 is not None:
            self.inputs.materials1.connect(materials1)
        if materials2 is not None:
            self.inputs.materials2.connect(materials2)

    @staticmethod
    def _spec():
        description = """Assembles a set of materials into a unique one."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="materials",
                    type_names=["materials"],
                    optional=False,
                    document="""A vector of materials to merge or materials
        from pin 0 to ...""",
                ),
                1: PinSpecification(
                    name="materials",
                    type_names=["materials"],
                    optional=False,
                    document="""A vector of materials to merge or materials
        from pin 0 to ...""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="merged_materials",
                    type_names=["materials"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="merge::materials", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsMergeMaterials
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsMergeMaterials
        """
        return super().outputs


class InputsMergeMaterials(_Inputs):
    """Intermediate class used to connect user inputs to
    merge_materials operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.merge_materials()
    >>> my_materials1 = dpf.Materials()
    >>> op.inputs.materials1.connect(my_materials1)
    >>> my_materials2 = dpf.Materials()
    >>> op.inputs.materials2.connect(my_materials2)
    """

    def __init__(self, op: Operator):
        super().__init__(merge_materials._spec().inputs, op)
        self._materials1 = Input(merge_materials._spec().input_pin(0), 0, op, 0)
        self._inputs.append(self._materials1)
        self._materials2 = Input(merge_materials._spec().input_pin(1), 1, op, 1)
        self._inputs.append(self._materials2)

    @property
    def materials1(self):
        """Allows to connect materials1 input to the operator.

        A vector of materials to merge or materials
        from pin 0 to ...

        Parameters
        ----------
        my_materials1 : Materials

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.merge_materials()
        >>> op.inputs.materials1.connect(my_materials1)
        >>> # or
        >>> op.inputs.materials1(my_materials1)
        """
        return self._materials1

    @property
    def materials2(self):
        """Allows to connect materials2 input to the operator.

        A vector of materials to merge or materials
        from pin 0 to ...

        Parameters
        ----------
        my_materials2 : Materials

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.merge_materials()
        >>> op.inputs.materials2.connect(my_materials2)
        >>> # or
        >>> op.inputs.materials2(my_materials2)
        """
        return self._materials2


class OutputsMergeMaterials(_Outputs):
    """Intermediate class used to get outputs from
    merge_materials operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.merge_materials()
    >>> # Connect inputs : op.inputs. ...
    >>> result_merged_materials = op.outputs.merged_materials()
    """

    def __init__(self, op: Operator):
        super().__init__(merge_materials._spec().outputs, op)
        self._merged_materials = Output(merge_materials._spec().output_pin(0), 0, op)
        self._outputs.append(self._merged_materials)

    @property
    def merged_materials(self):
        """Allows to get merged_materials output of the operator

        Returns
        ----------
        my_merged_materials : Materials

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.merge_materials()
        >>> # Connect inputs : op.inputs. ...
        >>> result_merged_materials = op.outputs.merged_materials()
        """  # noqa: E501
        return self._merged_materials
