"""
make_for_each_range
===================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class make_for_each_range(Operator):
    """Generate a range that can be consumed by the for_each operator

    Parameters
    ----------
    iterable : optional
        Iterable object, generated by
        make_for_each_range oeprator, that
        can be combined with the one
        currently generated.
    operator_to_iterate : Operator
        Operator that must be reconnected with the
        range values.
    pin_index : int
    valueA :
    valueB :
    valueC1 :
    valueC2 :


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.make_for_each_range()

    >>> # Make input connections
    >>> my_iterable = dpf.()
    >>> op.inputs.iterable.connect(my_iterable)
    >>> my_operator_to_iterate = dpf.Operator()
    >>> op.inputs.operator_to_iterate.connect(my_operator_to_iterate)
    >>> my_pin_index = int()
    >>> op.inputs.pin_index.connect(my_pin_index)
    >>> my_valueA = dpf.()
    >>> op.inputs.valueA.connect(my_valueA)
    >>> my_valueB = dpf.()
    >>> op.inputs.valueB.connect(my_valueB)
    >>> my_valueC1 = dpf.()
    >>> op.inputs.valueC1.connect(my_valueC1)
    >>> my_valueC2 = dpf.()
    >>> op.inputs.valueC2.connect(my_valueC2)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.make_for_each_range(
    ...     iterable=my_iterable,
    ...     operator_to_iterate=my_operator_to_iterate,
    ...     pin_index=my_pin_index,
    ...     valueA=my_valueA,
    ...     valueB=my_valueB,
    ...     valueC1=my_valueC1,
    ...     valueC2=my_valueC2,
    ... )

    >>> # Get output data
    >>> result_output = op.outputs.output()
    """

    def __init__(
        self,
        iterable=None,
        operator_to_iterate=None,
        pin_index=None,
        valueA=None,
        valueB=None,
        valueC1=None,
        valueC2=None,
        config=None,
        server=None,
    ):
        super().__init__(name="make_for_each_range", config=config, server=server)
        self._inputs = InputsMakeForEachRange(self)
        self._outputs = OutputsMakeForEachRange(self)
        if iterable is not None:
            self.inputs.iterable.connect(iterable)
        if operator_to_iterate is not None:
            self.inputs.operator_to_iterate.connect(operator_to_iterate)
        if pin_index is not None:
            self.inputs.pin_index.connect(pin_index)
        if valueA is not None:
            self.inputs.valueA.connect(valueA)
        if valueB is not None:
            self.inputs.valueB.connect(valueB)
        if valueC1 is not None:
            self.inputs.valueC1.connect(valueC1)
        if valueC2 is not None:
            self.inputs.valueC2.connect(valueC2)

    @staticmethod
    def _spec():
        description = (
            """Generate a range that can be consumed by the for_each operator"""
        )
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="iterable",
                    type_names=["any"],
                    optional=True,
                    document="""Iterable object, generated by
        make_for_each_range oeprator, that
        can be combined with the one
        currently generated.""",
                ),
                1: PinSpecification(
                    name="operator_to_iterate",
                    type_names=["operator"],
                    optional=False,
                    document="""Operator that must be reconnected with the
        range values.""",
                ),
                2: PinSpecification(
                    name="pin_index",
                    type_names=["int32"],
                    optional=False,
                    document="""""",
                ),
                3: PinSpecification(
                    name="valueA",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
                4: PinSpecification(
                    name="valueB",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
                5: PinSpecification(
                    name="valueC",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
                6: PinSpecification(
                    name="valueC",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="output",
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="make_for_each_range", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsMakeForEachRange
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsMakeForEachRange
        """
        return super().outputs


class InputsMakeForEachRange(_Inputs):
    """Intermediate class used to connect user inputs to
    make_for_each_range operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.make_for_each_range()
    >>> my_iterable = dpf.()
    >>> op.inputs.iterable.connect(my_iterable)
    >>> my_operator_to_iterate = dpf.Operator()
    >>> op.inputs.operator_to_iterate.connect(my_operator_to_iterate)
    >>> my_pin_index = int()
    >>> op.inputs.pin_index.connect(my_pin_index)
    >>> my_valueA = dpf.()
    >>> op.inputs.valueA.connect(my_valueA)
    >>> my_valueB = dpf.()
    >>> op.inputs.valueB.connect(my_valueB)
    >>> my_valueC1 = dpf.()
    >>> op.inputs.valueC1.connect(my_valueC1)
    >>> my_valueC2 = dpf.()
    >>> op.inputs.valueC2.connect(my_valueC2)
    """

    def __init__(self, op: Operator):
        super().__init__(make_for_each_range._spec().inputs, op)
        self._iterable = Input(make_for_each_range._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._iterable)
        self._operator_to_iterate = Input(
            make_for_each_range._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._operator_to_iterate)
        self._pin_index = Input(make_for_each_range._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._pin_index)
        self._valueA = Input(make_for_each_range._spec().input_pin(3), 3, op, -1)
        self._inputs.append(self._valueA)
        self._valueB = Input(make_for_each_range._spec().input_pin(4), 4, op, -1)
        self._inputs.append(self._valueB)
        self._valueC1 = Input(make_for_each_range._spec().input_pin(5), 5, op, 0)
        self._inputs.append(self._valueC1)
        self._valueC2 = Input(make_for_each_range._spec().input_pin(6), 6, op, 1)
        self._inputs.append(self._valueC2)

    @property
    def iterable(self):
        """Allows to connect iterable input to the operator.

        Iterable object, generated by
        make_for_each_range oeprator, that
        can be combined with the one
        currently generated.

        Parameters
        ----------
        my_iterable :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.iterable.connect(my_iterable)
        >>> # or
        >>> op.inputs.iterable(my_iterable)
        """
        return self._iterable

    @property
    def operator_to_iterate(self):
        """Allows to connect operator_to_iterate input to the operator.

        Operator that must be reconnected with the
        range values.

        Parameters
        ----------
        my_operator_to_iterate : Operator

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.operator_to_iterate.connect(my_operator_to_iterate)
        >>> # or
        >>> op.inputs.operator_to_iterate(my_operator_to_iterate)
        """
        return self._operator_to_iterate

    @property
    def pin_index(self):
        """Allows to connect pin_index input to the operator.

        Parameters
        ----------
        my_pin_index : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.pin_index.connect(my_pin_index)
        >>> # or
        >>> op.inputs.pin_index(my_pin_index)
        """
        return self._pin_index

    @property
    def valueA(self):
        """Allows to connect valueA input to the operator.

        Parameters
        ----------
        my_valueA :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.valueA.connect(my_valueA)
        >>> # or
        >>> op.inputs.valueA(my_valueA)
        """
        return self._valueA

    @property
    def valueB(self):
        """Allows to connect valueB input to the operator.

        Parameters
        ----------
        my_valueB :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.valueB.connect(my_valueB)
        >>> # or
        >>> op.inputs.valueB(my_valueB)
        """
        return self._valueB

    @property
    def valueC1(self):
        """Allows to connect valueC1 input to the operator.

        Parameters
        ----------
        my_valueC1 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.valueC1.connect(my_valueC1)
        >>> # or
        >>> op.inputs.valueC1(my_valueC1)
        """
        return self._valueC1

    @property
    def valueC2(self):
        """Allows to connect valueC2 input to the operator.

        Parameters
        ----------
        my_valueC2 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> op.inputs.valueC2.connect(my_valueC2)
        >>> # or
        >>> op.inputs.valueC2(my_valueC2)
        """
        return self._valueC2


class OutputsMakeForEachRange(_Outputs):
    """Intermediate class used to get outputs from
    make_for_each_range operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.make_for_each_range()
    >>> # Connect inputs : op.inputs. ...
    >>> result_output = op.outputs.output()
    """

    def __init__(self, op: Operator):
        super().__init__(make_for_each_range._spec().outputs, op)
        self._output = Output(make_for_each_range._spec().output_pin(0), 0, op)
        self._outputs.append(self._output)

    @property
    def output(self):
        """Allows to get output output of the operator

        Returns
        ----------
        my_output :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.make_for_each_range()
        >>> # Connect inputs : op.inputs. ...
        >>> result_output = op.outputs.output()
        """  # noqa: E501
        return self._output
