"""
ints_to_scoping
===============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class ints_to_scoping(Operator):
    """take a int or a vector of int and transform it in a one entity field
    of location 'numeric'.

    Parameters
    ----------
    int_or_vector_int : int
        Int or vector of int
    location : str, optional


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.ints_to_scoping()

    >>> # Make input connections
    >>> my_int_or_vector_int = int()
    >>> op.inputs.int_or_vector_int.connect(my_int_or_vector_int)
    >>> my_location = str()
    >>> op.inputs.location.connect(my_location)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.ints_to_scoping(
    ...     int_or_vector_int=my_int_or_vector_int,
    ...     location=my_location,
    ... )

    >>> # Get output data
    >>> result_scoping = op.outputs.scoping()
    """

    def __init__(self, int_or_vector_int=None, location=None, config=None, server=None):
        super().__init__(name="scopingify", config=config, server=server)
        self._inputs = InputsIntsToScoping(self)
        self._outputs = OutputsIntsToScoping(self)
        if int_or_vector_int is not None:
            self.inputs.int_or_vector_int.connect(int_or_vector_int)
        if location is not None:
            self.inputs.location.connect(location)

    @staticmethod
    def _spec():
        description = """take a int or a vector of int and transform it in a one entity field
            of location &quot;numeric&quot;."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="int_or_vector_int",
                    type_names=["int32", "vector<int32>"],
                    optional=False,
                    document="""Int or vector of int""",
                ),
                1: PinSpecification(
                    name="location",
                    type_names=["string"],
                    optional=True,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="scoping",
                    type_names=["scoping"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="scopingify", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsIntsToScoping
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsIntsToScoping
        """
        return super().outputs


class InputsIntsToScoping(_Inputs):
    """Intermediate class used to connect user inputs to
    ints_to_scoping operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.ints_to_scoping()
    >>> my_int_or_vector_int = int()
    >>> op.inputs.int_or_vector_int.connect(my_int_or_vector_int)
    >>> my_location = str()
    >>> op.inputs.location.connect(my_location)
    """

    def __init__(self, op: Operator):
        super().__init__(ints_to_scoping._spec().inputs, op)
        self._int_or_vector_int = Input(ints_to_scoping._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._int_or_vector_int)
        self._location = Input(ints_to_scoping._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._location)

    @property
    def int_or_vector_int(self):
        """Allows to connect int_or_vector_int input to the operator.

        Int or vector of int

        Parameters
        ----------
        my_int_or_vector_int : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.ints_to_scoping()
        >>> op.inputs.int_or_vector_int.connect(my_int_or_vector_int)
        >>> # or
        >>> op.inputs.int_or_vector_int(my_int_or_vector_int)
        """
        return self._int_or_vector_int

    @property
    def location(self):
        """Allows to connect location input to the operator.

        Parameters
        ----------
        my_location : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.ints_to_scoping()
        >>> op.inputs.location.connect(my_location)
        >>> # or
        >>> op.inputs.location(my_location)
        """
        return self._location


class OutputsIntsToScoping(_Outputs):
    """Intermediate class used to get outputs from
    ints_to_scoping operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.ints_to_scoping()
    >>> # Connect inputs : op.inputs. ...
    >>> result_scoping = op.outputs.scoping()
    """

    def __init__(self, op: Operator):
        super().__init__(ints_to_scoping._spec().outputs, op)
        self._scoping = Output(ints_to_scoping._spec().output_pin(0), 0, op)
        self._outputs.append(self._scoping)

    @property
    def scoping(self):
        """Allows to get scoping output of the operator

        Returns
        ----------
        my_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.ints_to_scoping()
        >>> # Connect inputs : op.inputs. ...
        >>> result_scoping = op.outputs.scoping()
        """  # noqa: E501
        return self._scoping
