"""
incremental_concatenate_as_fc
=============================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class incremental_concatenate_as_fc(Operator):
    """Assemble fields in a fields container.

    Parameters
    ----------
    field : Field
    label : LabelSpace, optional
        Label space value that must be applied to the
        added field.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.incremental_concatenate_as_fc()

    >>> # Make input connections
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_label = dpf.LabelSpace()
    >>> op.inputs.label.connect(my_label)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.incremental_concatenate_as_fc(
    ...     field=my_field,
    ...     label=my_label,
    ... )

    >>> # Get output data
    >>> result_output = op.outputs.output()
    """

    def __init__(self, field=None, label=None, config=None, server=None):
        super().__init__(
            name="incremental::concatenate_as_fc", config=config, server=server
        )
        self._inputs = InputsIncrementalConcatenateAsFc(self)
        self._outputs = OutputsIncrementalConcatenateAsFc(self)
        if field is not None:
            self.inputs.field.connect(field)
        if label is not None:
            self.inputs.label.connect(label)

    @staticmethod
    def _spec():
        description = """Assemble fields in a fields container."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="label",
                    type_names=["label_space"],
                    optional=True,
                    document="""Label space value that must be applied to the
        added field.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="output",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="incremental::concatenate_as_fc", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsIncrementalConcatenateAsFc
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsIncrementalConcatenateAsFc
        """
        return super().outputs


class InputsIncrementalConcatenateAsFc(_Inputs):
    """Intermediate class used to connect user inputs to
    incremental_concatenate_as_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.incremental_concatenate_as_fc()
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_label = dpf.LabelSpace()
    >>> op.inputs.label.connect(my_label)
    """

    def __init__(self, op: Operator):
        super().__init__(incremental_concatenate_as_fc._spec().inputs, op)
        self._field = Input(
            incremental_concatenate_as_fc._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._field)
        self._label = Input(
            incremental_concatenate_as_fc._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._label)

    @property
    def field(self):
        """Allows to connect field input to the operator.

        Parameters
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.incremental_concatenate_as_fc()
        >>> op.inputs.field.connect(my_field)
        >>> # or
        >>> op.inputs.field(my_field)
        """
        return self._field

    @property
    def label(self):
        """Allows to connect label input to the operator.

        Label space value that must be applied to the
        added field.

        Parameters
        ----------
        my_label : LabelSpace

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.incremental_concatenate_as_fc()
        >>> op.inputs.label.connect(my_label)
        >>> # or
        >>> op.inputs.label(my_label)
        """
        return self._label


class OutputsIncrementalConcatenateAsFc(_Outputs):
    """Intermediate class used to get outputs from
    incremental_concatenate_as_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.incremental_concatenate_as_fc()
    >>> # Connect inputs : op.inputs. ...
    >>> result_output = op.outputs.output()
    """

    def __init__(self, op: Operator):
        super().__init__(incremental_concatenate_as_fc._spec().outputs, op)
        self._output = Output(
            incremental_concatenate_as_fc._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._output)

    @property
    def output(self):
        """Allows to get output output of the operator

        Returns
        ----------
        my_output : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.incremental_concatenate_as_fc()
        >>> # Connect inputs : op.inputs. ...
        >>> result_output = op.outputs.output()
        """  # noqa: E501
        return self._output
