"""
for_each
========
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class for_each(Operator):
    """Allows to write a loop over a chunk of operators.

    Parameters
    ----------
    iterable :
        Either the result of the make_iterable_info
        operator, or the operator that must
        be incremented.
    iterable_values : optional
    pin_index : int, optional
    forward1 :
    forward2 :


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.for_each()

    >>> # Make input connections
    >>> my_iterable = dpf.()
    >>> op.inputs.iterable.connect(my_iterable)
    >>> my_iterable_values = dpf.()
    >>> op.inputs.iterable_values.connect(my_iterable_values)
    >>> my_pin_index = int()
    >>> op.inputs.pin_index.connect(my_pin_index)
    >>> my_forward1 = dpf.()
    >>> op.inputs.forward1.connect(my_forward1)
    >>> my_forward2 = dpf.()
    >>> op.inputs.forward2.connect(my_forward2)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.for_each(
    ...     iterable=my_iterable,
    ...     iterable_values=my_iterable_values,
    ...     pin_index=my_pin_index,
    ...     forward1=my_forward1,
    ...     forward2=my_forward2,
    ... )

    >>> # Get output data
    >>> result_empty = op.outputs.empty()
    >>> result_output1 = op.outputs.output1()
    >>> result_output2 = op.outputs.output2()
    """

    def __init__(
        self,
        iterable=None,
        iterable_values=None,
        pin_index=None,
        forward1=None,
        forward2=None,
        config=None,
        server=None,
    ):
        super().__init__(name="for_each", config=config, server=server)
        self._inputs = InputsForEach(self)
        self._outputs = OutputsForEach(self)
        if iterable is not None:
            self.inputs.iterable.connect(iterable)
        if iterable_values is not None:
            self.inputs.iterable_values.connect(iterable_values)
        if pin_index is not None:
            self.inputs.pin_index.connect(pin_index)
        if forward1 is not None:
            self.inputs.forward1.connect(forward1)
        if forward2 is not None:
            self.inputs.forward2.connect(forward2)

    @staticmethod
    def _spec():
        description = """Allows to write a loop over a chunk of operators."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="iterable",
                    type_names=["any"],
                    optional=False,
                    document="""Either the result of the make_iterable_info
        operator, or the operator that must
        be incremented.""",
                ),
                1: PinSpecification(
                    name="iterable_values",
                    type_names=["any"],
                    optional=True,
                    document="""""",
                ),
                2: PinSpecification(
                    name="pin_index",
                    type_names=["int32"],
                    optional=True,
                    document="""""",
                ),
                3: PinSpecification(
                    name="forward",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
                4: PinSpecification(
                    name="forward",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="empty",
                    optional=False,
                    document="""""",
                ),
                3: PinSpecification(
                    name="output1",
                    optional=False,
                    document="""""",
                ),
                4: PinSpecification(
                    name="output2",
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="for_each", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsForEach
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsForEach
        """
        return super().outputs


class InputsForEach(_Inputs):
    """Intermediate class used to connect user inputs to
    for_each operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.for_each()
    >>> my_iterable = dpf.()
    >>> op.inputs.iterable.connect(my_iterable)
    >>> my_iterable_values = dpf.()
    >>> op.inputs.iterable_values.connect(my_iterable_values)
    >>> my_pin_index = int()
    >>> op.inputs.pin_index.connect(my_pin_index)
    >>> my_forward1 = dpf.()
    >>> op.inputs.forward1.connect(my_forward1)
    >>> my_forward2 = dpf.()
    >>> op.inputs.forward2.connect(my_forward2)
    """

    def __init__(self, op: Operator):
        super().__init__(for_each._spec().inputs, op)
        self._iterable = Input(for_each._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._iterable)
        self._iterable_values = Input(for_each._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._iterable_values)
        self._pin_index = Input(for_each._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._pin_index)
        self._forward1 = Input(for_each._spec().input_pin(3), 3, op, 0)
        self._inputs.append(self._forward1)
        self._forward2 = Input(for_each._spec().input_pin(4), 4, op, 1)
        self._inputs.append(self._forward2)

    @property
    def iterable(self):
        """Allows to connect iterable input to the operator.

        Either the result of the make_iterable_info
        operator, or the operator that must
        be incremented.

        Parameters
        ----------
        my_iterable :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> op.inputs.iterable.connect(my_iterable)
        >>> # or
        >>> op.inputs.iterable(my_iterable)
        """
        return self._iterable

    @property
    def iterable_values(self):
        """Allows to connect iterable_values input to the operator.

        Parameters
        ----------
        my_iterable_values :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> op.inputs.iterable_values.connect(my_iterable_values)
        >>> # or
        >>> op.inputs.iterable_values(my_iterable_values)
        """
        return self._iterable_values

    @property
    def pin_index(self):
        """Allows to connect pin_index input to the operator.

        Parameters
        ----------
        my_pin_index : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> op.inputs.pin_index.connect(my_pin_index)
        >>> # or
        >>> op.inputs.pin_index(my_pin_index)
        """
        return self._pin_index

    @property
    def forward1(self):
        """Allows to connect forward1 input to the operator.

        Parameters
        ----------
        my_forward1 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> op.inputs.forward1.connect(my_forward1)
        >>> # or
        >>> op.inputs.forward1(my_forward1)
        """
        return self._forward1

    @property
    def forward2(self):
        """Allows to connect forward2 input to the operator.

        Parameters
        ----------
        my_forward2 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> op.inputs.forward2.connect(my_forward2)
        >>> # or
        >>> op.inputs.forward2(my_forward2)
        """
        return self._forward2


class OutputsForEach(_Outputs):
    """Intermediate class used to get outputs from
    for_each operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.for_each()
    >>> # Connect inputs : op.inputs. ...
    >>> result_empty = op.outputs.empty()
    >>> result_output1 = op.outputs.output1()
    >>> result_output2 = op.outputs.output2()
    """

    def __init__(self, op: Operator):
        super().__init__(for_each._spec().outputs, op)
        self._empty = Output(for_each._spec().output_pin(0), 0, op)
        self._outputs.append(self._empty)
        self._output1 = Output(for_each._spec().output_pin(3), 3, op)
        self._outputs.append(self._output1)
        self._output2 = Output(for_each._spec().output_pin(4), 4, op)
        self._outputs.append(self._output2)

    @property
    def empty(self):
        """Allows to get empty output of the operator

        Returns
        ----------
        my_empty :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> # Connect inputs : op.inputs. ...
        >>> result_empty = op.outputs.empty()
        """  # noqa: E501
        return self._empty

    @property
    def output1(self):
        """Allows to get output1 output of the operator

        Returns
        ----------
        my_output1 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> # Connect inputs : op.inputs. ...
        >>> result_output1 = op.outputs.output1()
        """  # noqa: E501
        return self._output1

    @property
    def output2(self):
        """Allows to get output2 output of the operator

        Returns
        ----------
        my_output2 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.for_each()
        >>> # Connect inputs : op.inputs. ...
        >>> result_output2 = op.outputs.output2()
        """  # noqa: E501
        return self._output2
