"""
extract_time_freq
=================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.outputs import _modify_output_spec_with_one_type
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class extract_time_freq(Operator):
    """Extract timefreqs with sets scoping from a time freq support

    Parameters
    ----------
    time_freq_support : TimeFreqSupport
    time_scoping : Scoping, optional
    real_or_complex : bool, optional
        False for real only (default). true for
        complex output.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.extract_time_freq()

    >>> # Make input connections
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_real_or_complex = bool()
    >>> op.inputs.real_or_complex.connect(my_real_or_complex)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.extract_time_freq(
    ...     time_freq_support=my_time_freq_support,
    ...     time_scoping=my_time_scoping,
    ...     real_or_complex=my_real_or_complex,
    ... )

    >>> # Get output data
    >>> result_field = op.outputs.field()
    """

    def __init__(
        self,
        time_freq_support=None,
        time_scoping=None,
        real_or_complex=None,
        config=None,
        server=None,
    ):
        super().__init__(name="extract_time_freq", config=config, server=server)
        self._inputs = InputsExtractTimeFreq(self)
        self._outputs = OutputsExtractTimeFreq(self)
        if time_freq_support is not None:
            self.inputs.time_freq_support.connect(time_freq_support)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)
        if real_or_complex is not None:
            self.inputs.real_or_complex.connect(real_or_complex)

    @staticmethod
    def _spec():
        description = """Extract timefreqs with sets scoping from a time freq support"""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_freq_support",
                    type_names=["time_freq_support"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""""",
                ),
                2: PinSpecification(
                    name="real_or_complex",
                    type_names=["bool"],
                    optional=True,
                    document="""False for real only (default). true for
        complex output.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field", "fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="extract_time_freq", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsExtractTimeFreq
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsExtractTimeFreq
        """
        return super().outputs


class InputsExtractTimeFreq(_Inputs):
    """Intermediate class used to connect user inputs to
    extract_time_freq operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.extract_time_freq()
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_real_or_complex = bool()
    >>> op.inputs.real_or_complex.connect(my_real_or_complex)
    """

    def __init__(self, op: Operator):
        super().__init__(extract_time_freq._spec().inputs, op)
        self._time_freq_support = Input(
            extract_time_freq._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._time_freq_support)
        self._time_scoping = Input(extract_time_freq._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._time_scoping)
        self._real_or_complex = Input(extract_time_freq._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._real_or_complex)

    @property
    def time_freq_support(self):
        """Allows to connect time_freq_support input to the operator.

        Parameters
        ----------
        my_time_freq_support : TimeFreqSupport

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.extract_time_freq()
        >>> op.inputs.time_freq_support.connect(my_time_freq_support)
        >>> # or
        >>> op.inputs.time_freq_support(my_time_freq_support)
        """
        return self._time_freq_support

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Parameters
        ----------
        my_time_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.extract_time_freq()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping

    @property
    def real_or_complex(self):
        """Allows to connect real_or_complex input to the operator.

        False for real only (default). true for
        complex output.

        Parameters
        ----------
        my_real_or_complex : bool

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.extract_time_freq()
        >>> op.inputs.real_or_complex.connect(my_real_or_complex)
        >>> # or
        >>> op.inputs.real_or_complex(my_real_or_complex)
        """
        return self._real_or_complex


class OutputsExtractTimeFreq(_Outputs):
    """Intermediate class used to get outputs from
    extract_time_freq operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.extract_time_freq()
    >>> # Connect inputs : op.inputs. ...
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(extract_time_freq._spec().outputs, op)
        self.field_as_field = Output(
            _modify_output_spec_with_one_type(
                extract_time_freq._spec().output_pin(0), "field"
            ),
            0,
            op,
        )
        self._outputs.append(self.field_as_field)
        self.field_as_fields_container = Output(
            _modify_output_spec_with_one_type(
                extract_time_freq._spec().output_pin(0), "fields_container"
            ),
            0,
            op,
        )
        self._outputs.append(self.field_as_fields_container)
