"""
compute_time_scoping
====================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class compute_time_scoping(Operator):
    """Computes the time frequency scoping (made of set IDs) necessary to
    interpolate on a list of time or frequencies.

    Parameters
    ----------
    time_freq_values : float or Field
        List of frequencies or times needed. to
        specify load steps, put a field (and
        not a list) in input with a scoping
        located on "timefreq_steps".
    step : int, optional
    time_freq_support : TimeFreqSupport


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.compute_time_scoping()

    >>> # Make input connections
    >>> my_time_freq_values = float()
    >>> op.inputs.time_freq_values.connect(my_time_freq_values)
    >>> my_step = int()
    >>> op.inputs.step.connect(my_step)
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.compute_time_scoping(
    ...     time_freq_values=my_time_freq_values,
    ...     step=my_step,
    ...     time_freq_support=my_time_freq_support,
    ... )

    >>> # Get output data
    >>> result_scoping = op.outputs.scoping()
    >>> result_field = op.outputs.field()
    """

    def __init__(
        self,
        time_freq_values=None,
        step=None,
        time_freq_support=None,
        config=None,
        server=None,
    ):
        super().__init__(name="compute_time_scoping", config=config, server=server)
        self._inputs = InputsComputeTimeScoping(self)
        self._outputs = OutputsComputeTimeScoping(self)
        if time_freq_values is not None:
            self.inputs.time_freq_values.connect(time_freq_values)
        if step is not None:
            self.inputs.step.connect(step)
        if time_freq_support is not None:
            self.inputs.time_freq_support.connect(time_freq_support)

    @staticmethod
    def _spec():
        description = """Computes the time frequency scoping (made of set IDs) necessary to
            interpolate on a list of time or frequencies."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_freq_values",
                    type_names=["double", "vector<double>", "field"],
                    optional=False,
                    document="""List of frequencies or times needed. to
        specify load steps, put a field (and
        not a list) in input with a scoping
        located on "timefreq_steps".""",
                ),
                2: PinSpecification(
                    name="step",
                    type_names=["int32"],
                    optional=True,
                    document="""""",
                ),
                8: PinSpecification(
                    name="time_freq_support",
                    type_names=["time_freq_support"],
                    optional=False,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="scoping",
                    type_names=["scoping"],
                    optional=False,
                    document="""Time_scoping""",
                ),
                1: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""Time_freq_values""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="compute_time_scoping", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsComputeTimeScoping
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsComputeTimeScoping
        """
        return super().outputs


class InputsComputeTimeScoping(_Inputs):
    """Intermediate class used to connect user inputs to
    compute_time_scoping operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.compute_time_scoping()
    >>> my_time_freq_values = float()
    >>> op.inputs.time_freq_values.connect(my_time_freq_values)
    >>> my_step = int()
    >>> op.inputs.step.connect(my_step)
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    """

    def __init__(self, op: Operator):
        super().__init__(compute_time_scoping._spec().inputs, op)
        self._time_freq_values = Input(
            compute_time_scoping._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._time_freq_values)
        self._step = Input(compute_time_scoping._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._step)
        self._time_freq_support = Input(
            compute_time_scoping._spec().input_pin(8), 8, op, -1
        )
        self._inputs.append(self._time_freq_support)

    @property
    def time_freq_values(self):
        """Allows to connect time_freq_values input to the operator.

        List of frequencies or times needed. to
        specify load steps, put a field (and
        not a list) in input with a scoping
        located on "timefreq_steps".

        Parameters
        ----------
        my_time_freq_values : float or Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.compute_time_scoping()
        >>> op.inputs.time_freq_values.connect(my_time_freq_values)
        >>> # or
        >>> op.inputs.time_freq_values(my_time_freq_values)
        """
        return self._time_freq_values

    @property
    def step(self):
        """Allows to connect step input to the operator.

        Parameters
        ----------
        my_step : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.compute_time_scoping()
        >>> op.inputs.step.connect(my_step)
        >>> # or
        >>> op.inputs.step(my_step)
        """
        return self._step

    @property
    def time_freq_support(self):
        """Allows to connect time_freq_support input to the operator.

        Parameters
        ----------
        my_time_freq_support : TimeFreqSupport

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.compute_time_scoping()
        >>> op.inputs.time_freq_support.connect(my_time_freq_support)
        >>> # or
        >>> op.inputs.time_freq_support(my_time_freq_support)
        """
        return self._time_freq_support


class OutputsComputeTimeScoping(_Outputs):
    """Intermediate class used to get outputs from
    compute_time_scoping operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.compute_time_scoping()
    >>> # Connect inputs : op.inputs. ...
    >>> result_scoping = op.outputs.scoping()
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(compute_time_scoping._spec().outputs, op)
        self._scoping = Output(compute_time_scoping._spec().output_pin(0), 0, op)
        self._outputs.append(self._scoping)
        self._field = Output(compute_time_scoping._spec().output_pin(1), 1, op)
        self._outputs.append(self._field)

    @property
    def scoping(self):
        """Allows to get scoping output of the operator

        Returns
        ----------
        my_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.compute_time_scoping()
        >>> # Connect inputs : op.inputs. ...
        >>> result_scoping = op.outputs.scoping()
        """  # noqa: E501
        return self._scoping

    @property
    def field(self):
        """Allows to get field output of the operator

        Returns
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.compute_time_scoping()
        >>> # Connect inputs : op.inputs. ...
        >>> result_field = op.outputs.field()
        """  # noqa: E501
        return self._field
