"""
assemble_scalars_to_vectors_fc
==============================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class assemble_scalars_to_vectors_fc(Operator):
    """Takes three scalar fields and assembles them as a 3D vector field.

    Parameters
    ----------
    fields_container : FieldsContainer, optional
    y : Field, optional
    z : Field, optional


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()

    >>> # Make input connections
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_y = dpf.Field()
    >>> op.inputs.y.connect(my_y)
    >>> my_z = dpf.Field()
    >>> op.inputs.z.connect(my_z)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc(
    ...     fields_container=my_fields_container,
    ...     y=my_y,
    ...     z=my_z,
    ... )

    >>> # Get output data
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(self, fields_container=None, y=None, z=None, config=None, server=None):
        super().__init__(
            name="assemble_scalars_to_vectors_fc", config=config, server=server
        )
        self._inputs = InputsAssembleScalarsToVectorsFc(self)
        self._outputs = OutputsAssembleScalarsToVectorsFc(self)
        if fields_container is not None:
            self.inputs.fields_container.connect(fields_container)
        if y is not None:
            self.inputs.y.connect(y)
        if z is not None:
            self.inputs.z.connect(z)

    @staticmethod
    def _spec():
        description = (
            """Takes three scalar fields and assembles them as a 3D vector field."""
        )
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=True,
                    document="""""",
                ),
                1: PinSpecification(
                    name="y",
                    type_names=["field"],
                    optional=True,
                    document="""""",
                ),
                2: PinSpecification(
                    name="z",
                    type_names=["field"],
                    optional=True,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="assemble_scalars_to_vectors_fc", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsAssembleScalarsToVectorsFc
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsAssembleScalarsToVectorsFc
        """
        return super().outputs


class InputsAssembleScalarsToVectorsFc(_Inputs):
    """Intermediate class used to connect user inputs to
    assemble_scalars_to_vectors_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_y = dpf.Field()
    >>> op.inputs.y.connect(my_y)
    >>> my_z = dpf.Field()
    >>> op.inputs.z.connect(my_z)
    """

    def __init__(self, op: Operator):
        super().__init__(assemble_scalars_to_vectors_fc._spec().inputs, op)
        self._fields_container = Input(
            assemble_scalars_to_vectors_fc._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._fields_container)
        self._y = Input(assemble_scalars_to_vectors_fc._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._y)
        self._z = Input(assemble_scalars_to_vectors_fc._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._z)

    @property
    def fields_container(self):
        """Allows to connect fields_container input to the operator.

        Parameters
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()
        >>> op.inputs.fields_container.connect(my_fields_container)
        >>> # or
        >>> op.inputs.fields_container(my_fields_container)
        """
        return self._fields_container

    @property
    def y(self):
        """Allows to connect y input to the operator.

        Parameters
        ----------
        my_y : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()
        >>> op.inputs.y.connect(my_y)
        >>> # or
        >>> op.inputs.y(my_y)
        """
        return self._y

    @property
    def z(self):
        """Allows to connect z input to the operator.

        Parameters
        ----------
        my_z : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()
        >>> op.inputs.z.connect(my_z)
        >>> # or
        >>> op.inputs.z(my_z)
        """
        return self._z


class OutputsAssembleScalarsToVectorsFc(_Outputs):
    """Intermediate class used to get outputs from
    assemble_scalars_to_vectors_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(self, op: Operator):
        super().__init__(assemble_scalars_to_vectors_fc._spec().outputs, op)
        self._fields_container = Output(
            assemble_scalars_to_vectors_fc._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._fields_container)

    @property
    def fields_container(self):
        """Allows to get fields_container output of the operator

        Returns
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors_fc()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields_container = op.outputs.fields_container()
        """  # noqa: E501
        return self._fields_container
