"""
zone_pressure_spectrum
======================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class zone_pressure_spectrum(Operator):
    """Read/compute names result from result streams.

    Parameters
    ----------
    time_scoping : Scoping, optional
        Time/freq (use doubles or field), time/freq
        set ids (use ints or scoping) or
        time/freq step ids (use scoping with
        timefreq_steps location) required in
        output
    mesh_scoping : Scoping or ScopingsContainer, optional
        Nodes or elements scoping required in output.
        the scoping's location indicates
        whether nodes or elements are asked.
        using scopings container enables to
        split the result fields container in
        domains
    streams_container : StreamsContainer, optional
        Result file container allowed to be kept open
        to cache data
    data_sources : DataSources
        Result file path container, used if no
        streams are set
    result_name : str, optional
        Name of the result to read. by default the
        name of the operator is taken.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.zone_pressure_spectrum()

    >>> # Make input connections
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_result_name = str()
    >>> op.inputs.result_name.connect(my_result_name)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.zone_pressure_spectrum(
    ...     time_scoping=my_time_scoping,
    ...     mesh_scoping=my_mesh_scoping,
    ...     streams_container=my_streams_container,
    ...     data_sources=my_data_sources,
    ...     result_name=my_result_name,
    ... )

    >>> # Get output data
    >>> result_fields = op.outputs.fields()
    """

    def __init__(
        self,
        time_scoping=None,
        mesh_scoping=None,
        streams_container=None,
        data_sources=None,
        result_name=None,
        config=None,
        server=None,
    ):
        super().__init__(
            name="cgns::cgns::zone_pressure_spectrum", config=config, server=server
        )
        self._inputs = InputsZonePressureSpectrum(self)
        self._outputs = OutputsZonePressureSpectrum(self)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)
        if mesh_scoping is not None:
            self.inputs.mesh_scoping.connect(mesh_scoping)
        if streams_container is not None:
            self.inputs.streams_container.connect(streams_container)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)
        if result_name is not None:
            self.inputs.result_name.connect(result_name)

    @staticmethod
    def _spec():
        description = """Read/compute names result from result streams."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping", "vector<int32>"],
                    optional=True,
                    document="""Time/freq (use doubles or field), time/freq
        set ids (use ints or scoping) or
        time/freq step ids (use scoping with
        timefreq_steps location) required in
        output""",
                ),
                1: PinSpecification(
                    name="mesh_scoping",
                    type_names=["scoping", "scopings_container"],
                    optional=True,
                    document="""Nodes or elements scoping required in output.
        the scoping's location indicates
        whether nodes or elements are asked.
        using scopings container enables to
        split the result fields container in
        domains""",
                ),
                3: PinSpecification(
                    name="streams_container",
                    type_names=["streams_container"],
                    optional=True,
                    document="""Result file container allowed to be kept open
        to cache data""",
                ),
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""Result file path container, used if no
        streams are set""",
                ),
                17: PinSpecification(
                    name="result_name",
                    type_names=["string"],
                    optional=True,
                    document="""Name of the result to read. by default the
        name of the operator is taken.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields",
                    type_names=["fields_container"],
                    optional=False,
                    document="""Results""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="cgns::cgns::zone_pressure_spectrum", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsZonePressureSpectrum
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsZonePressureSpectrum
        """
        return super().outputs


class InputsZonePressureSpectrum(_Inputs):
    """Intermediate class used to connect user inputs to
    zone_pressure_spectrum operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.zone_pressure_spectrum()
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_result_name = str()
    >>> op.inputs.result_name.connect(my_result_name)
    """

    def __init__(self, op: Operator):
        super().__init__(zone_pressure_spectrum._spec().inputs, op)
        self._time_scoping = Input(
            zone_pressure_spectrum._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._time_scoping)
        self._mesh_scoping = Input(
            zone_pressure_spectrum._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._mesh_scoping)
        self._streams_container = Input(
            zone_pressure_spectrum._spec().input_pin(3), 3, op, -1
        )
        self._inputs.append(self._streams_container)
        self._data_sources = Input(
            zone_pressure_spectrum._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._data_sources)
        self._result_name = Input(
            zone_pressure_spectrum._spec().input_pin(17), 17, op, -1
        )
        self._inputs.append(self._result_name)

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Time/freq (use doubles or field), time/freq
        set ids (use ints or scoping) or
        time/freq step ids (use scoping with
        timefreq_steps location) required in
        output

        Parameters
        ----------
        my_time_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.zone_pressure_spectrum()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping

    @property
    def mesh_scoping(self):
        """Allows to connect mesh_scoping input to the operator.

        Nodes or elements scoping required in output.
        the scoping's location indicates
        whether nodes or elements are asked.
        using scopings container enables to
        split the result fields container in
        domains

        Parameters
        ----------
        my_mesh_scoping : Scoping or ScopingsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.zone_pressure_spectrum()
        >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
        >>> # or
        >>> op.inputs.mesh_scoping(my_mesh_scoping)
        """
        return self._mesh_scoping

    @property
    def streams_container(self):
        """Allows to connect streams_container input to the operator.

        Result file container allowed to be kept open
        to cache data

        Parameters
        ----------
        my_streams_container : StreamsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.zone_pressure_spectrum()
        >>> op.inputs.streams_container.connect(my_streams_container)
        >>> # or
        >>> op.inputs.streams_container(my_streams_container)
        """
        return self._streams_container

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        Result file path container, used if no
        streams are set

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.zone_pressure_spectrum()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources

    @property
    def result_name(self):
        """Allows to connect result_name input to the operator.

        Name of the result to read. by default the
        name of the operator is taken.

        Parameters
        ----------
        my_result_name : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.zone_pressure_spectrum()
        >>> op.inputs.result_name.connect(my_result_name)
        >>> # or
        >>> op.inputs.result_name(my_result_name)
        """
        return self._result_name


class OutputsZonePressureSpectrum(_Outputs):
    """Intermediate class used to get outputs from
    zone_pressure_spectrum operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.zone_pressure_spectrum()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields = op.outputs.fields()
    """

    def __init__(self, op: Operator):
        super().__init__(zone_pressure_spectrum._spec().outputs, op)
        self._fields = Output(zone_pressure_spectrum._spec().output_pin(0), 0, op)
        self._outputs.append(self._fields)

    @property
    def fields(self):
        """Allows to get fields output of the operator

        Returns
        ----------
        my_fields : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.zone_pressure_spectrum()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields = op.outputs.fields()
        """  # noqa: E501
        return self._fields
