"""
write_motion_dfmf_file
======================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class write_motion_dfmf_file(Operator):
    """Write the invariant terms and the model data in a motion dfmf file

    Parameters
    ----------
    model_data : PropertyField
        Data describing the finite element model
    lumped_mass : FieldsContainer
        Fieldscontainers containing the lumped mass
    field_coordinates : Field
        Coordinates of all nodes
    nod :
    used_node_index :
    eigenvalue :
    translational_mode_shape :
    rotational_mode_shape :
    invrt_1 : float
    invrt_2 :
    invrt_3 :
    invrt_4 :
    invrt_5 :
    invrt_6 :
    invrt_7 :
    invrt_8 :
    file_path : str
        Path with motion dfmf extension where the
        export occurs


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.write_motion_dfmf_file()

    >>> # Make input connections
    >>> my_model_data = dpf.PropertyField()
    >>> op.inputs.model_data.connect(my_model_data)
    >>> my_lumped_mass = dpf.FieldsContainer()
    >>> op.inputs.lumped_mass.connect(my_lumped_mass)
    >>> my_field_coordinates = dpf.Field()
    >>> op.inputs.field_coordinates.connect(my_field_coordinates)
    >>> my_nod = dpf.()
    >>> op.inputs.nod.connect(my_nod)
    >>> my_used_node_index = dpf.()
    >>> op.inputs.used_node_index.connect(my_used_node_index)
    >>> my_eigenvalue = dpf.()
    >>> op.inputs.eigenvalue.connect(my_eigenvalue)
    >>> my_translational_mode_shape = dpf.()
    >>> op.inputs.translational_mode_shape.connect(my_translational_mode_shape)
    >>> my_rotational_mode_shape = dpf.()
    >>> op.inputs.rotational_mode_shape.connect(my_rotational_mode_shape)
    >>> my_invrt_1 = float()
    >>> op.inputs.invrt_1.connect(my_invrt_1)
    >>> my_invrt_2 = dpf.()
    >>> op.inputs.invrt_2.connect(my_invrt_2)
    >>> my_invrt_3 = dpf.()
    >>> op.inputs.invrt_3.connect(my_invrt_3)
    >>> my_invrt_4 = dpf.()
    >>> op.inputs.invrt_4.connect(my_invrt_4)
    >>> my_invrt_5 = dpf.()
    >>> op.inputs.invrt_5.connect(my_invrt_5)
    >>> my_invrt_6 = dpf.()
    >>> op.inputs.invrt_6.connect(my_invrt_6)
    >>> my_invrt_7 = dpf.()
    >>> op.inputs.invrt_7.connect(my_invrt_7)
    >>> my_invrt_8 = dpf.()
    >>> op.inputs.invrt_8.connect(my_invrt_8)
    >>> my_file_path = str()
    >>> op.inputs.file_path.connect(my_file_path)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.write_motion_dfmf_file(
    ...     model_data=my_model_data,
    ...     lumped_mass=my_lumped_mass,
    ...     field_coordinates=my_field_coordinates,
    ...     nod=my_nod,
    ...     used_node_index=my_used_node_index,
    ...     eigenvalue=my_eigenvalue,
    ...     translational_mode_shape=my_translational_mode_shape,
    ...     rotational_mode_shape=my_rotational_mode_shape,
    ...     invrt_1=my_invrt_1,
    ...     invrt_2=my_invrt_2,
    ...     invrt_3=my_invrt_3,
    ...     invrt_4=my_invrt_4,
    ...     invrt_5=my_invrt_5,
    ...     invrt_6=my_invrt_6,
    ...     invrt_7=my_invrt_7,
    ...     invrt_8=my_invrt_8,
    ...     file_path=my_file_path,
    ... )

    """

    def __init__(
        self,
        model_data=None,
        lumped_mass=None,
        field_coordinates=None,
        nod=None,
        used_node_index=None,
        eigenvalue=None,
        translational_mode_shape=None,
        rotational_mode_shape=None,
        invrt_1=None,
        invrt_2=None,
        invrt_3=None,
        invrt_4=None,
        invrt_5=None,
        invrt_6=None,
        invrt_7=None,
        invrt_8=None,
        file_path=None,
        config=None,
        server=None,
    ):
        super().__init__(name="write_motion_dfmf_file", config=config, server=server)
        self._inputs = InputsWriteMotionDfmfFile(self)
        self._outputs = OutputsWriteMotionDfmfFile(self)
        if model_data is not None:
            self.inputs.model_data.connect(model_data)
        if lumped_mass is not None:
            self.inputs.lumped_mass.connect(lumped_mass)
        if field_coordinates is not None:
            self.inputs.field_coordinates.connect(field_coordinates)
        if nod is not None:
            self.inputs.nod.connect(nod)
        if used_node_index is not None:
            self.inputs.used_node_index.connect(used_node_index)
        if eigenvalue is not None:
            self.inputs.eigenvalue.connect(eigenvalue)
        if translational_mode_shape is not None:
            self.inputs.translational_mode_shape.connect(translational_mode_shape)
        if rotational_mode_shape is not None:
            self.inputs.rotational_mode_shape.connect(rotational_mode_shape)
        if invrt_1 is not None:
            self.inputs.invrt_1.connect(invrt_1)
        if invrt_2 is not None:
            self.inputs.invrt_2.connect(invrt_2)
        if invrt_3 is not None:
            self.inputs.invrt_3.connect(invrt_3)
        if invrt_4 is not None:
            self.inputs.invrt_4.connect(invrt_4)
        if invrt_5 is not None:
            self.inputs.invrt_5.connect(invrt_5)
        if invrt_6 is not None:
            self.inputs.invrt_6.connect(invrt_6)
        if invrt_7 is not None:
            self.inputs.invrt_7.connect(invrt_7)
        if invrt_8 is not None:
            self.inputs.invrt_8.connect(invrt_8)
        if file_path is not None:
            self.inputs.file_path.connect(file_path)

    @staticmethod
    def _spec():
        description = (
            """Write the invariant terms and the model data in a motion dfmf file"""
        )
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="model_data",
                    type_names=["property_field"],
                    optional=False,
                    document="""Data describing the finite element model""",
                ),
                1: PinSpecification(
                    name="lumped_mass",
                    type_names=["fields_container"],
                    optional=False,
                    document="""Fieldscontainers containing the lumped mass""",
                ),
                2: PinSpecification(
                    name="field_coordinates",
                    type_names=["field"],
                    optional=False,
                    document="""Coordinates of all nodes""",
                ),
                3: PinSpecification(
                    name="nod",
                    type_names=["vector<int32>"],
                    optional=False,
                    document="""""",
                ),
                4: PinSpecification(
                    name="used_node_index",
                    type_names=["vector<int32>"],
                    optional=False,
                    document="""""",
                ),
                5: PinSpecification(
                    name="eigenvalue",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                6: PinSpecification(
                    name="translational_mode_shape",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                7: PinSpecification(
                    name="rotational_mode_shape",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                8: PinSpecification(
                    name="invrt_1",
                    type_names=["double"],
                    optional=False,
                    document="""""",
                ),
                9: PinSpecification(
                    name="invrt_2",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                10: PinSpecification(
                    name="invrt_3",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                11: PinSpecification(
                    name="invrt_4",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                12: PinSpecification(
                    name="invrt_5",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                13: PinSpecification(
                    name="invrt_6",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                14: PinSpecification(
                    name="invrt_7",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                15: PinSpecification(
                    name="invrt_8",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                16: PinSpecification(
                    name="file_path",
                    type_names=["string"],
                    optional=False,
                    document="""Path with motion dfmf extension where the
        export occurs""",
                ),
            },
            map_output_pin_spec={},
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="write_motion_dfmf_file", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsWriteMotionDfmfFile
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsWriteMotionDfmfFile
        """
        return super().outputs


class InputsWriteMotionDfmfFile(_Inputs):
    """Intermediate class used to connect user inputs to
    write_motion_dfmf_file operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.write_motion_dfmf_file()
    >>> my_model_data = dpf.PropertyField()
    >>> op.inputs.model_data.connect(my_model_data)
    >>> my_lumped_mass = dpf.FieldsContainer()
    >>> op.inputs.lumped_mass.connect(my_lumped_mass)
    >>> my_field_coordinates = dpf.Field()
    >>> op.inputs.field_coordinates.connect(my_field_coordinates)
    >>> my_nod = dpf.()
    >>> op.inputs.nod.connect(my_nod)
    >>> my_used_node_index = dpf.()
    >>> op.inputs.used_node_index.connect(my_used_node_index)
    >>> my_eigenvalue = dpf.()
    >>> op.inputs.eigenvalue.connect(my_eigenvalue)
    >>> my_translational_mode_shape = dpf.()
    >>> op.inputs.translational_mode_shape.connect(my_translational_mode_shape)
    >>> my_rotational_mode_shape = dpf.()
    >>> op.inputs.rotational_mode_shape.connect(my_rotational_mode_shape)
    >>> my_invrt_1 = float()
    >>> op.inputs.invrt_1.connect(my_invrt_1)
    >>> my_invrt_2 = dpf.()
    >>> op.inputs.invrt_2.connect(my_invrt_2)
    >>> my_invrt_3 = dpf.()
    >>> op.inputs.invrt_3.connect(my_invrt_3)
    >>> my_invrt_4 = dpf.()
    >>> op.inputs.invrt_4.connect(my_invrt_4)
    >>> my_invrt_5 = dpf.()
    >>> op.inputs.invrt_5.connect(my_invrt_5)
    >>> my_invrt_6 = dpf.()
    >>> op.inputs.invrt_6.connect(my_invrt_6)
    >>> my_invrt_7 = dpf.()
    >>> op.inputs.invrt_7.connect(my_invrt_7)
    >>> my_invrt_8 = dpf.()
    >>> op.inputs.invrt_8.connect(my_invrt_8)
    >>> my_file_path = str()
    >>> op.inputs.file_path.connect(my_file_path)
    """

    def __init__(self, op: Operator):
        super().__init__(write_motion_dfmf_file._spec().inputs, op)
        self._model_data = Input(write_motion_dfmf_file._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._model_data)
        self._lumped_mass = Input(
            write_motion_dfmf_file._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._lumped_mass)
        self._field_coordinates = Input(
            write_motion_dfmf_file._spec().input_pin(2), 2, op, -1
        )
        self._inputs.append(self._field_coordinates)
        self._nod = Input(write_motion_dfmf_file._spec().input_pin(3), 3, op, -1)
        self._inputs.append(self._nod)
        self._used_node_index = Input(
            write_motion_dfmf_file._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._used_node_index)
        self._eigenvalue = Input(write_motion_dfmf_file._spec().input_pin(5), 5, op, -1)
        self._inputs.append(self._eigenvalue)
        self._translational_mode_shape = Input(
            write_motion_dfmf_file._spec().input_pin(6), 6, op, -1
        )
        self._inputs.append(self._translational_mode_shape)
        self._rotational_mode_shape = Input(
            write_motion_dfmf_file._spec().input_pin(7), 7, op, -1
        )
        self._inputs.append(self._rotational_mode_shape)
        self._invrt_1 = Input(write_motion_dfmf_file._spec().input_pin(8), 8, op, -1)
        self._inputs.append(self._invrt_1)
        self._invrt_2 = Input(write_motion_dfmf_file._spec().input_pin(9), 9, op, -1)
        self._inputs.append(self._invrt_2)
        self._invrt_3 = Input(write_motion_dfmf_file._spec().input_pin(10), 10, op, -1)
        self._inputs.append(self._invrt_3)
        self._invrt_4 = Input(write_motion_dfmf_file._spec().input_pin(11), 11, op, -1)
        self._inputs.append(self._invrt_4)
        self._invrt_5 = Input(write_motion_dfmf_file._spec().input_pin(12), 12, op, -1)
        self._inputs.append(self._invrt_5)
        self._invrt_6 = Input(write_motion_dfmf_file._spec().input_pin(13), 13, op, -1)
        self._inputs.append(self._invrt_6)
        self._invrt_7 = Input(write_motion_dfmf_file._spec().input_pin(14), 14, op, -1)
        self._inputs.append(self._invrt_7)
        self._invrt_8 = Input(write_motion_dfmf_file._spec().input_pin(15), 15, op, -1)
        self._inputs.append(self._invrt_8)
        self._file_path = Input(
            write_motion_dfmf_file._spec().input_pin(16), 16, op, -1
        )
        self._inputs.append(self._file_path)

    @property
    def model_data(self):
        """Allows to connect model_data input to the operator.

        Data describing the finite element model

        Parameters
        ----------
        my_model_data : PropertyField

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.model_data.connect(my_model_data)
        >>> # or
        >>> op.inputs.model_data(my_model_data)
        """
        return self._model_data

    @property
    def lumped_mass(self):
        """Allows to connect lumped_mass input to the operator.

        Fieldscontainers containing the lumped mass

        Parameters
        ----------
        my_lumped_mass : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.lumped_mass.connect(my_lumped_mass)
        >>> # or
        >>> op.inputs.lumped_mass(my_lumped_mass)
        """
        return self._lumped_mass

    @property
    def field_coordinates(self):
        """Allows to connect field_coordinates input to the operator.

        Coordinates of all nodes

        Parameters
        ----------
        my_field_coordinates : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.field_coordinates.connect(my_field_coordinates)
        >>> # or
        >>> op.inputs.field_coordinates(my_field_coordinates)
        """
        return self._field_coordinates

    @property
    def nod(self):
        """Allows to connect nod input to the operator.

        Parameters
        ----------
        my_nod :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.nod.connect(my_nod)
        >>> # or
        >>> op.inputs.nod(my_nod)
        """
        return self._nod

    @property
    def used_node_index(self):
        """Allows to connect used_node_index input to the operator.

        Parameters
        ----------
        my_used_node_index :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.used_node_index.connect(my_used_node_index)
        >>> # or
        >>> op.inputs.used_node_index(my_used_node_index)
        """
        return self._used_node_index

    @property
    def eigenvalue(self):
        """Allows to connect eigenvalue input to the operator.

        Parameters
        ----------
        my_eigenvalue :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.eigenvalue.connect(my_eigenvalue)
        >>> # or
        >>> op.inputs.eigenvalue(my_eigenvalue)
        """
        return self._eigenvalue

    @property
    def translational_mode_shape(self):
        """Allows to connect translational_mode_shape input to the operator.

        Parameters
        ----------
        my_translational_mode_shape :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.translational_mode_shape.connect(my_translational_mode_shape)
        >>> # or
        >>> op.inputs.translational_mode_shape(my_translational_mode_shape)
        """
        return self._translational_mode_shape

    @property
    def rotational_mode_shape(self):
        """Allows to connect rotational_mode_shape input to the operator.

        Parameters
        ----------
        my_rotational_mode_shape :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.rotational_mode_shape.connect(my_rotational_mode_shape)
        >>> # or
        >>> op.inputs.rotational_mode_shape(my_rotational_mode_shape)
        """
        return self._rotational_mode_shape

    @property
    def invrt_1(self):
        """Allows to connect invrt_1 input to the operator.

        Parameters
        ----------
        my_invrt_1 : float

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_1.connect(my_invrt_1)
        >>> # or
        >>> op.inputs.invrt_1(my_invrt_1)
        """
        return self._invrt_1

    @property
    def invrt_2(self):
        """Allows to connect invrt_2 input to the operator.

        Parameters
        ----------
        my_invrt_2 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_2.connect(my_invrt_2)
        >>> # or
        >>> op.inputs.invrt_2(my_invrt_2)
        """
        return self._invrt_2

    @property
    def invrt_3(self):
        """Allows to connect invrt_3 input to the operator.

        Parameters
        ----------
        my_invrt_3 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_3.connect(my_invrt_3)
        >>> # or
        >>> op.inputs.invrt_3(my_invrt_3)
        """
        return self._invrt_3

    @property
    def invrt_4(self):
        """Allows to connect invrt_4 input to the operator.

        Parameters
        ----------
        my_invrt_4 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_4.connect(my_invrt_4)
        >>> # or
        >>> op.inputs.invrt_4(my_invrt_4)
        """
        return self._invrt_4

    @property
    def invrt_5(self):
        """Allows to connect invrt_5 input to the operator.

        Parameters
        ----------
        my_invrt_5 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_5.connect(my_invrt_5)
        >>> # or
        >>> op.inputs.invrt_5(my_invrt_5)
        """
        return self._invrt_5

    @property
    def invrt_6(self):
        """Allows to connect invrt_6 input to the operator.

        Parameters
        ----------
        my_invrt_6 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_6.connect(my_invrt_6)
        >>> # or
        >>> op.inputs.invrt_6(my_invrt_6)
        """
        return self._invrt_6

    @property
    def invrt_7(self):
        """Allows to connect invrt_7 input to the operator.

        Parameters
        ----------
        my_invrt_7 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_7.connect(my_invrt_7)
        >>> # or
        >>> op.inputs.invrt_7(my_invrt_7)
        """
        return self._invrt_7

    @property
    def invrt_8(self):
        """Allows to connect invrt_8 input to the operator.

        Parameters
        ----------
        my_invrt_8 :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.invrt_8.connect(my_invrt_8)
        >>> # or
        >>> op.inputs.invrt_8(my_invrt_8)
        """
        return self._invrt_8

    @property
    def file_path(self):
        """Allows to connect file_path input to the operator.

        Path with motion dfmf extension where the
        export occurs

        Parameters
        ----------
        my_file_path : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_motion_dfmf_file()
        >>> op.inputs.file_path.connect(my_file_path)
        >>> # or
        >>> op.inputs.file_path(my_file_path)
        """
        return self._file_path


class OutputsWriteMotionDfmfFile(_Outputs):
    """Intermediate class used to get outputs from
    write_motion_dfmf_file operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.write_motion_dfmf_file()
    >>> # Connect inputs : op.inputs. ...
    """

    def __init__(self, op: Operator):
        super().__init__(write_motion_dfmf_file._spec().outputs, op)
