"""
write_cms_rbd_file
==================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class write_cms_rbd_file(Operator):
    """Write the invariant terms and the model data in a cms_rbd file

    Parameters
    ----------
    model_data : PropertyField
        Data describing the finite element model
    center_of_mass : Field
        Center of mass of the body
    inertia_relief : Field
        Inertia matrix
    model_size : PropertyField
        Size of the diagonal box containing the body
    master_node_coordinates :
    v_trsf :
        Translational and rotational shape functions
    k_mat : Field
    mass_mat : Field
    c_mat : Field
    rhs : Field
    dn :
    dr_cross_n :
    drn :
    dn_cross_n :
    dnx_y :
    dny_y :
    dnz_y :
    dyx_n :
    dyy_n :
    dyz_n :
    dnxn :
    dnyn :
    dnzn :
    file_path : str
        Path with cms_rbd extension where the export
        occurs


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.write_cms_rbd_file()

    >>> # Make input connections
    >>> my_model_data = dpf.PropertyField()
    >>> op.inputs.model_data.connect(my_model_data)
    >>> my_center_of_mass = dpf.Field()
    >>> op.inputs.center_of_mass.connect(my_center_of_mass)
    >>> my_inertia_relief = dpf.Field()
    >>> op.inputs.inertia_relief.connect(my_inertia_relief)
    >>> my_model_size = dpf.PropertyField()
    >>> op.inputs.model_size.connect(my_model_size)
    >>> my_master_node_coordinates = dpf.()
    >>> op.inputs.master_node_coordinates.connect(my_master_node_coordinates)
    >>> my_v_trsf = dpf.()
    >>> op.inputs.v_trsf.connect(my_v_trsf)
    >>> my_k_mat = dpf.Field()
    >>> op.inputs.k_mat.connect(my_k_mat)
    >>> my_mass_mat = dpf.Field()
    >>> op.inputs.mass_mat.connect(my_mass_mat)
    >>> my_c_mat = dpf.Field()
    >>> op.inputs.c_mat.connect(my_c_mat)
    >>> my_rhs = dpf.Field()
    >>> op.inputs.rhs.connect(my_rhs)
    >>> my_dn = dpf.()
    >>> op.inputs.dn.connect(my_dn)
    >>> my_dr_cross_n = dpf.()
    >>> op.inputs.dr_cross_n.connect(my_dr_cross_n)
    >>> my_drn = dpf.()
    >>> op.inputs.drn.connect(my_drn)
    >>> my_dn_cross_n = dpf.()
    >>> op.inputs.dn_cross_n.connect(my_dn_cross_n)
    >>> my_dnx_y = dpf.()
    >>> op.inputs.dnx_y.connect(my_dnx_y)
    >>> my_dny_y = dpf.()
    >>> op.inputs.dny_y.connect(my_dny_y)
    >>> my_dnz_y = dpf.()
    >>> op.inputs.dnz_y.connect(my_dnz_y)
    >>> my_dyx_n = dpf.()
    >>> op.inputs.dyx_n.connect(my_dyx_n)
    >>> my_dyy_n = dpf.()
    >>> op.inputs.dyy_n.connect(my_dyy_n)
    >>> my_dyz_n = dpf.()
    >>> op.inputs.dyz_n.connect(my_dyz_n)
    >>> my_dnxn = dpf.()
    >>> op.inputs.dnxn.connect(my_dnxn)
    >>> my_dnyn = dpf.()
    >>> op.inputs.dnyn.connect(my_dnyn)
    >>> my_dnzn = dpf.()
    >>> op.inputs.dnzn.connect(my_dnzn)
    >>> my_file_path = str()
    >>> op.inputs.file_path.connect(my_file_path)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.write_cms_rbd_file(
    ...     model_data=my_model_data,
    ...     center_of_mass=my_center_of_mass,
    ...     inertia_relief=my_inertia_relief,
    ...     model_size=my_model_size,
    ...     master_node_coordinates=my_master_node_coordinates,
    ...     v_trsf=my_v_trsf,
    ...     k_mat=my_k_mat,
    ...     mass_mat=my_mass_mat,
    ...     c_mat=my_c_mat,
    ...     rhs=my_rhs,
    ...     dn=my_dn,
    ...     dr_cross_n=my_dr_cross_n,
    ...     drn=my_drn,
    ...     dn_cross_n=my_dn_cross_n,
    ...     dnx_y=my_dnx_y,
    ...     dny_y=my_dny_y,
    ...     dnz_y=my_dnz_y,
    ...     dyx_n=my_dyx_n,
    ...     dyy_n=my_dyy_n,
    ...     dyz_n=my_dyz_n,
    ...     dnxn=my_dnxn,
    ...     dnyn=my_dnyn,
    ...     dnzn=my_dnzn,
    ...     file_path=my_file_path,
    ... )

    """

    def __init__(
        self,
        model_data=None,
        center_of_mass=None,
        inertia_relief=None,
        model_size=None,
        master_node_coordinates=None,
        v_trsf=None,
        k_mat=None,
        mass_mat=None,
        c_mat=None,
        rhs=None,
        dn=None,
        dr_cross_n=None,
        drn=None,
        dn_cross_n=None,
        dnx_y=None,
        dny_y=None,
        dnz_y=None,
        dyx_n=None,
        dyy_n=None,
        dyz_n=None,
        dnxn=None,
        dnyn=None,
        dnzn=None,
        file_path=None,
        config=None,
        server=None,
    ):
        super().__init__(name="write_cms_rbd_file", config=config, server=server)
        self._inputs = InputsWriteCmsRbdFile(self)
        self._outputs = OutputsWriteCmsRbdFile(self)
        if model_data is not None:
            self.inputs.model_data.connect(model_data)
        if center_of_mass is not None:
            self.inputs.center_of_mass.connect(center_of_mass)
        if inertia_relief is not None:
            self.inputs.inertia_relief.connect(inertia_relief)
        if model_size is not None:
            self.inputs.model_size.connect(model_size)
        if master_node_coordinates is not None:
            self.inputs.master_node_coordinates.connect(master_node_coordinates)
        if v_trsf is not None:
            self.inputs.v_trsf.connect(v_trsf)
        if k_mat is not None:
            self.inputs.k_mat.connect(k_mat)
        if mass_mat is not None:
            self.inputs.mass_mat.connect(mass_mat)
        if c_mat is not None:
            self.inputs.c_mat.connect(c_mat)
        if rhs is not None:
            self.inputs.rhs.connect(rhs)
        if dn is not None:
            self.inputs.dn.connect(dn)
        if dr_cross_n is not None:
            self.inputs.dr_cross_n.connect(dr_cross_n)
        if drn is not None:
            self.inputs.drn.connect(drn)
        if dn_cross_n is not None:
            self.inputs.dn_cross_n.connect(dn_cross_n)
        if dnx_y is not None:
            self.inputs.dnx_y.connect(dnx_y)
        if dny_y is not None:
            self.inputs.dny_y.connect(dny_y)
        if dnz_y is not None:
            self.inputs.dnz_y.connect(dnz_y)
        if dyx_n is not None:
            self.inputs.dyx_n.connect(dyx_n)
        if dyy_n is not None:
            self.inputs.dyy_n.connect(dyy_n)
        if dyz_n is not None:
            self.inputs.dyz_n.connect(dyz_n)
        if dnxn is not None:
            self.inputs.dnxn.connect(dnxn)
        if dnyn is not None:
            self.inputs.dnyn.connect(dnyn)
        if dnzn is not None:
            self.inputs.dnzn.connect(dnzn)
        if file_path is not None:
            self.inputs.file_path.connect(file_path)

    @staticmethod
    def _spec():
        description = (
            """Write the invariant terms and the model data in a cms_rbd file"""
        )
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="model_data",
                    type_names=["property_field"],
                    optional=False,
                    document="""Data describing the finite element model""",
                ),
                1: PinSpecification(
                    name="center_of_mass",
                    type_names=["field"],
                    optional=False,
                    document="""Center of mass of the body""",
                ),
                2: PinSpecification(
                    name="inertia_relief",
                    type_names=["field"],
                    optional=False,
                    document="""Inertia matrix""",
                ),
                3: PinSpecification(
                    name="model_size",
                    type_names=["property_field"],
                    optional=False,
                    document="""Size of the diagonal box containing the body""",
                ),
                4: PinSpecification(
                    name="master_node_coordinates",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                5: PinSpecification(
                    name="v_trsf",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""Translational and rotational shape functions""",
                ),
                6: PinSpecification(
                    name="k_mat",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
                7: PinSpecification(
                    name="mass_mat",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
                8: PinSpecification(
                    name="c_mat",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
                9: PinSpecification(
                    name="rhs",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
                10: PinSpecification(
                    name="dn",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                11: PinSpecification(
                    name="dr_cross_n",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                12: PinSpecification(
                    name="drn",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                13: PinSpecification(
                    name="dn_cross_n",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                14: PinSpecification(
                    name="dnx_y",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                15: PinSpecification(
                    name="dny_y",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                16: PinSpecification(
                    name="dnz_y",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                17: PinSpecification(
                    name="dyx_n",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                18: PinSpecification(
                    name="dyy_n",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                19: PinSpecification(
                    name="dyz_n",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                20: PinSpecification(
                    name="dnxn",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                21: PinSpecification(
                    name="dnyn",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                22: PinSpecification(
                    name="dnzn",
                    type_names=["vector<double>"],
                    optional=False,
                    document="""""",
                ),
                23: PinSpecification(
                    name="file_path",
                    type_names=["string"],
                    optional=False,
                    document="""Path with cms_rbd extension where the export
        occurs""",
                ),
            },
            map_output_pin_spec={},
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="write_cms_rbd_file", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsWriteCmsRbdFile
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsWriteCmsRbdFile
        """
        return super().outputs


class InputsWriteCmsRbdFile(_Inputs):
    """Intermediate class used to connect user inputs to
    write_cms_rbd_file operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.write_cms_rbd_file()
    >>> my_model_data = dpf.PropertyField()
    >>> op.inputs.model_data.connect(my_model_data)
    >>> my_center_of_mass = dpf.Field()
    >>> op.inputs.center_of_mass.connect(my_center_of_mass)
    >>> my_inertia_relief = dpf.Field()
    >>> op.inputs.inertia_relief.connect(my_inertia_relief)
    >>> my_model_size = dpf.PropertyField()
    >>> op.inputs.model_size.connect(my_model_size)
    >>> my_master_node_coordinates = dpf.()
    >>> op.inputs.master_node_coordinates.connect(my_master_node_coordinates)
    >>> my_v_trsf = dpf.()
    >>> op.inputs.v_trsf.connect(my_v_trsf)
    >>> my_k_mat = dpf.Field()
    >>> op.inputs.k_mat.connect(my_k_mat)
    >>> my_mass_mat = dpf.Field()
    >>> op.inputs.mass_mat.connect(my_mass_mat)
    >>> my_c_mat = dpf.Field()
    >>> op.inputs.c_mat.connect(my_c_mat)
    >>> my_rhs = dpf.Field()
    >>> op.inputs.rhs.connect(my_rhs)
    >>> my_dn = dpf.()
    >>> op.inputs.dn.connect(my_dn)
    >>> my_dr_cross_n = dpf.()
    >>> op.inputs.dr_cross_n.connect(my_dr_cross_n)
    >>> my_drn = dpf.()
    >>> op.inputs.drn.connect(my_drn)
    >>> my_dn_cross_n = dpf.()
    >>> op.inputs.dn_cross_n.connect(my_dn_cross_n)
    >>> my_dnx_y = dpf.()
    >>> op.inputs.dnx_y.connect(my_dnx_y)
    >>> my_dny_y = dpf.()
    >>> op.inputs.dny_y.connect(my_dny_y)
    >>> my_dnz_y = dpf.()
    >>> op.inputs.dnz_y.connect(my_dnz_y)
    >>> my_dyx_n = dpf.()
    >>> op.inputs.dyx_n.connect(my_dyx_n)
    >>> my_dyy_n = dpf.()
    >>> op.inputs.dyy_n.connect(my_dyy_n)
    >>> my_dyz_n = dpf.()
    >>> op.inputs.dyz_n.connect(my_dyz_n)
    >>> my_dnxn = dpf.()
    >>> op.inputs.dnxn.connect(my_dnxn)
    >>> my_dnyn = dpf.()
    >>> op.inputs.dnyn.connect(my_dnyn)
    >>> my_dnzn = dpf.()
    >>> op.inputs.dnzn.connect(my_dnzn)
    >>> my_file_path = str()
    >>> op.inputs.file_path.connect(my_file_path)
    """

    def __init__(self, op: Operator):
        super().__init__(write_cms_rbd_file._spec().inputs, op)
        self._model_data = Input(write_cms_rbd_file._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._model_data)
        self._center_of_mass = Input(write_cms_rbd_file._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._center_of_mass)
        self._inertia_relief = Input(write_cms_rbd_file._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._inertia_relief)
        self._model_size = Input(write_cms_rbd_file._spec().input_pin(3), 3, op, -1)
        self._inputs.append(self._model_size)
        self._master_node_coordinates = Input(
            write_cms_rbd_file._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._master_node_coordinates)
        self._v_trsf = Input(write_cms_rbd_file._spec().input_pin(5), 5, op, -1)
        self._inputs.append(self._v_trsf)
        self._k_mat = Input(write_cms_rbd_file._spec().input_pin(6), 6, op, -1)
        self._inputs.append(self._k_mat)
        self._mass_mat = Input(write_cms_rbd_file._spec().input_pin(7), 7, op, -1)
        self._inputs.append(self._mass_mat)
        self._c_mat = Input(write_cms_rbd_file._spec().input_pin(8), 8, op, -1)
        self._inputs.append(self._c_mat)
        self._rhs = Input(write_cms_rbd_file._spec().input_pin(9), 9, op, -1)
        self._inputs.append(self._rhs)
        self._dn = Input(write_cms_rbd_file._spec().input_pin(10), 10, op, -1)
        self._inputs.append(self._dn)
        self._dr_cross_n = Input(write_cms_rbd_file._spec().input_pin(11), 11, op, -1)
        self._inputs.append(self._dr_cross_n)
        self._drn = Input(write_cms_rbd_file._spec().input_pin(12), 12, op, -1)
        self._inputs.append(self._drn)
        self._dn_cross_n = Input(write_cms_rbd_file._spec().input_pin(13), 13, op, -1)
        self._inputs.append(self._dn_cross_n)
        self._dnx_y = Input(write_cms_rbd_file._spec().input_pin(14), 14, op, -1)
        self._inputs.append(self._dnx_y)
        self._dny_y = Input(write_cms_rbd_file._spec().input_pin(15), 15, op, -1)
        self._inputs.append(self._dny_y)
        self._dnz_y = Input(write_cms_rbd_file._spec().input_pin(16), 16, op, -1)
        self._inputs.append(self._dnz_y)
        self._dyx_n = Input(write_cms_rbd_file._spec().input_pin(17), 17, op, -1)
        self._inputs.append(self._dyx_n)
        self._dyy_n = Input(write_cms_rbd_file._spec().input_pin(18), 18, op, -1)
        self._inputs.append(self._dyy_n)
        self._dyz_n = Input(write_cms_rbd_file._spec().input_pin(19), 19, op, -1)
        self._inputs.append(self._dyz_n)
        self._dnxn = Input(write_cms_rbd_file._spec().input_pin(20), 20, op, -1)
        self._inputs.append(self._dnxn)
        self._dnyn = Input(write_cms_rbd_file._spec().input_pin(21), 21, op, -1)
        self._inputs.append(self._dnyn)
        self._dnzn = Input(write_cms_rbd_file._spec().input_pin(22), 22, op, -1)
        self._inputs.append(self._dnzn)
        self._file_path = Input(write_cms_rbd_file._spec().input_pin(23), 23, op, -1)
        self._inputs.append(self._file_path)

    @property
    def model_data(self):
        """Allows to connect model_data input to the operator.

        Data describing the finite element model

        Parameters
        ----------
        my_model_data : PropertyField

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.model_data.connect(my_model_data)
        >>> # or
        >>> op.inputs.model_data(my_model_data)
        """
        return self._model_data

    @property
    def center_of_mass(self):
        """Allows to connect center_of_mass input to the operator.

        Center of mass of the body

        Parameters
        ----------
        my_center_of_mass : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.center_of_mass.connect(my_center_of_mass)
        >>> # or
        >>> op.inputs.center_of_mass(my_center_of_mass)
        """
        return self._center_of_mass

    @property
    def inertia_relief(self):
        """Allows to connect inertia_relief input to the operator.

        Inertia matrix

        Parameters
        ----------
        my_inertia_relief : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.inertia_relief.connect(my_inertia_relief)
        >>> # or
        >>> op.inputs.inertia_relief(my_inertia_relief)
        """
        return self._inertia_relief

    @property
    def model_size(self):
        """Allows to connect model_size input to the operator.

        Size of the diagonal box containing the body

        Parameters
        ----------
        my_model_size : PropertyField

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.model_size.connect(my_model_size)
        >>> # or
        >>> op.inputs.model_size(my_model_size)
        """
        return self._model_size

    @property
    def master_node_coordinates(self):
        """Allows to connect master_node_coordinates input to the operator.

        Parameters
        ----------
        my_master_node_coordinates :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.master_node_coordinates.connect(my_master_node_coordinates)
        >>> # or
        >>> op.inputs.master_node_coordinates(my_master_node_coordinates)
        """
        return self._master_node_coordinates

    @property
    def v_trsf(self):
        """Allows to connect v_trsf input to the operator.

        Translational and rotational shape functions

        Parameters
        ----------
        my_v_trsf :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.v_trsf.connect(my_v_trsf)
        >>> # or
        >>> op.inputs.v_trsf(my_v_trsf)
        """
        return self._v_trsf

    @property
    def k_mat(self):
        """Allows to connect k_mat input to the operator.

        Parameters
        ----------
        my_k_mat : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.k_mat.connect(my_k_mat)
        >>> # or
        >>> op.inputs.k_mat(my_k_mat)
        """
        return self._k_mat

    @property
    def mass_mat(self):
        """Allows to connect mass_mat input to the operator.

        Parameters
        ----------
        my_mass_mat : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.mass_mat.connect(my_mass_mat)
        >>> # or
        >>> op.inputs.mass_mat(my_mass_mat)
        """
        return self._mass_mat

    @property
    def c_mat(self):
        """Allows to connect c_mat input to the operator.

        Parameters
        ----------
        my_c_mat : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.c_mat.connect(my_c_mat)
        >>> # or
        >>> op.inputs.c_mat(my_c_mat)
        """
        return self._c_mat

    @property
    def rhs(self):
        """Allows to connect rhs input to the operator.

        Parameters
        ----------
        my_rhs : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.rhs.connect(my_rhs)
        >>> # or
        >>> op.inputs.rhs(my_rhs)
        """
        return self._rhs

    @property
    def dn(self):
        """Allows to connect dn input to the operator.

        Parameters
        ----------
        my_dn :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dn.connect(my_dn)
        >>> # or
        >>> op.inputs.dn(my_dn)
        """
        return self._dn

    @property
    def dr_cross_n(self):
        """Allows to connect dr_cross_n input to the operator.

        Parameters
        ----------
        my_dr_cross_n :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dr_cross_n.connect(my_dr_cross_n)
        >>> # or
        >>> op.inputs.dr_cross_n(my_dr_cross_n)
        """
        return self._dr_cross_n

    @property
    def drn(self):
        """Allows to connect drn input to the operator.

        Parameters
        ----------
        my_drn :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.drn.connect(my_drn)
        >>> # or
        >>> op.inputs.drn(my_drn)
        """
        return self._drn

    @property
    def dn_cross_n(self):
        """Allows to connect dn_cross_n input to the operator.

        Parameters
        ----------
        my_dn_cross_n :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dn_cross_n.connect(my_dn_cross_n)
        >>> # or
        >>> op.inputs.dn_cross_n(my_dn_cross_n)
        """
        return self._dn_cross_n

    @property
    def dnx_y(self):
        """Allows to connect dnx_y input to the operator.

        Parameters
        ----------
        my_dnx_y :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dnx_y.connect(my_dnx_y)
        >>> # or
        >>> op.inputs.dnx_y(my_dnx_y)
        """
        return self._dnx_y

    @property
    def dny_y(self):
        """Allows to connect dny_y input to the operator.

        Parameters
        ----------
        my_dny_y :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dny_y.connect(my_dny_y)
        >>> # or
        >>> op.inputs.dny_y(my_dny_y)
        """
        return self._dny_y

    @property
    def dnz_y(self):
        """Allows to connect dnz_y input to the operator.

        Parameters
        ----------
        my_dnz_y :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dnz_y.connect(my_dnz_y)
        >>> # or
        >>> op.inputs.dnz_y(my_dnz_y)
        """
        return self._dnz_y

    @property
    def dyx_n(self):
        """Allows to connect dyx_n input to the operator.

        Parameters
        ----------
        my_dyx_n :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dyx_n.connect(my_dyx_n)
        >>> # or
        >>> op.inputs.dyx_n(my_dyx_n)
        """
        return self._dyx_n

    @property
    def dyy_n(self):
        """Allows to connect dyy_n input to the operator.

        Parameters
        ----------
        my_dyy_n :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dyy_n.connect(my_dyy_n)
        >>> # or
        >>> op.inputs.dyy_n(my_dyy_n)
        """
        return self._dyy_n

    @property
    def dyz_n(self):
        """Allows to connect dyz_n input to the operator.

        Parameters
        ----------
        my_dyz_n :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dyz_n.connect(my_dyz_n)
        >>> # or
        >>> op.inputs.dyz_n(my_dyz_n)
        """
        return self._dyz_n

    @property
    def dnxn(self):
        """Allows to connect dnxn input to the operator.

        Parameters
        ----------
        my_dnxn :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dnxn.connect(my_dnxn)
        >>> # or
        >>> op.inputs.dnxn(my_dnxn)
        """
        return self._dnxn

    @property
    def dnyn(self):
        """Allows to connect dnyn input to the operator.

        Parameters
        ----------
        my_dnyn :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dnyn.connect(my_dnyn)
        >>> # or
        >>> op.inputs.dnyn(my_dnyn)
        """
        return self._dnyn

    @property
    def dnzn(self):
        """Allows to connect dnzn input to the operator.

        Parameters
        ----------
        my_dnzn :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.dnzn.connect(my_dnzn)
        >>> # or
        >>> op.inputs.dnzn(my_dnzn)
        """
        return self._dnzn

    @property
    def file_path(self):
        """Allows to connect file_path input to the operator.

        Path with cms_rbd extension where the export
        occurs

        Parameters
        ----------
        my_file_path : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.write_cms_rbd_file()
        >>> op.inputs.file_path.connect(my_file_path)
        >>> # or
        >>> op.inputs.file_path(my_file_path)
        """
        return self._file_path


class OutputsWriteCmsRbdFile(_Outputs):
    """Intermediate class used to get outputs from
    write_cms_rbd_file operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.write_cms_rbd_file()
    >>> # Connect inputs : op.inputs. ...
    """

    def __init__(self, op: Operator):
        super().__init__(write_cms_rbd_file._spec().outputs, op)
