"""
workflow_energy_per_harmonic
============================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class workflow_energy_per_harmonic(Operator):
    """Calculates the cumulated energy per harmonic in a multistage
    multiharmonic model.

    Parameters
    ----------
    time_scoping : Scoping, optional
    mesh_scoping : Scoping, optional
        Master scoping. all harmonics will be
        intersected with this scoping.
    energy_type : int, optional
        Type of energy to be processed: (0: strain +
        kinetic energy (default), 1: strain
        energy, 2: kinetic energy)
    data_sources : DataSources


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.workflow_energy_per_harmonic()

    >>> # Make input connections
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_energy_type = int()
    >>> op.inputs.energy_type.connect(my_energy_type)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.workflow_energy_per_harmonic(
    ...     time_scoping=my_time_scoping,
    ...     mesh_scoping=my_mesh_scoping,
    ...     energy_type=my_energy_type,
    ...     data_sources=my_data_sources,
    ... )

    >>> # Get output data
    >>> result_harmonic_energy = op.outputs.harmonic_energy()
    >>> result_harmonic_energy_percentage = op.outputs.harmonic_energy_percentage()
    """

    def __init__(
        self,
        time_scoping=None,
        mesh_scoping=None,
        energy_type=None,
        data_sources=None,
        config=None,
        server=None,
    ):
        super().__init__(
            name="workflow_energy_per_harmonic", config=config, server=server
        )
        self._inputs = InputsWorkflowEnergyPerHarmonic(self)
        self._outputs = OutputsWorkflowEnergyPerHarmonic(self)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)
        if mesh_scoping is not None:
            self.inputs.mesh_scoping.connect(mesh_scoping)
        if energy_type is not None:
            self.inputs.energy_type.connect(energy_type)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)

    @staticmethod
    def _spec():
        description = """Calculates the cumulated energy per harmonic in a multistage
            multiharmonic model."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""""",
                ),
                1: PinSpecification(
                    name="mesh_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""Master scoping. all harmonics will be
        intersected with this scoping.""",
                ),
                2: PinSpecification(
                    name="energy_type",
                    type_names=["int32"],
                    optional=True,
                    document="""Type of energy to be processed: (0: strain +
        kinetic energy (default), 1: strain
        energy, 2: kinetic energy)""",
                ),
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="harmonic_energy",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="harmonic_energy_percentage",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="workflow_energy_per_harmonic", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsWorkflowEnergyPerHarmonic
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsWorkflowEnergyPerHarmonic
        """
        return super().outputs


class InputsWorkflowEnergyPerHarmonic(_Inputs):
    """Intermediate class used to connect user inputs to
    workflow_energy_per_harmonic operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.workflow_energy_per_harmonic()
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_energy_type = int()
    >>> op.inputs.energy_type.connect(my_energy_type)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    """

    def __init__(self, op: Operator):
        super().__init__(workflow_energy_per_harmonic._spec().inputs, op)
        self._time_scoping = Input(
            workflow_energy_per_harmonic._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._time_scoping)
        self._mesh_scoping = Input(
            workflow_energy_per_harmonic._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._mesh_scoping)
        self._energy_type = Input(
            workflow_energy_per_harmonic._spec().input_pin(2), 2, op, -1
        )
        self._inputs.append(self._energy_type)
        self._data_sources = Input(
            workflow_energy_per_harmonic._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._data_sources)

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Parameters
        ----------
        my_time_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_harmonic()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping

    @property
    def mesh_scoping(self):
        """Allows to connect mesh_scoping input to the operator.

        Master scoping. all harmonics will be
        intersected with this scoping.

        Parameters
        ----------
        my_mesh_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_harmonic()
        >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
        >>> # or
        >>> op.inputs.mesh_scoping(my_mesh_scoping)
        """
        return self._mesh_scoping

    @property
    def energy_type(self):
        """Allows to connect energy_type input to the operator.

        Type of energy to be processed: (0: strain +
        kinetic energy (default), 1: strain
        energy, 2: kinetic energy)

        Parameters
        ----------
        my_energy_type : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_harmonic()
        >>> op.inputs.energy_type.connect(my_energy_type)
        >>> # or
        >>> op.inputs.energy_type(my_energy_type)
        """
        return self._energy_type

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_harmonic()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources


class OutputsWorkflowEnergyPerHarmonic(_Outputs):
    """Intermediate class used to get outputs from
    workflow_energy_per_harmonic operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.workflow_energy_per_harmonic()
    >>> # Connect inputs : op.inputs. ...
    >>> result_harmonic_energy = op.outputs.harmonic_energy()
    >>> result_harmonic_energy_percentage = op.outputs.harmonic_energy_percentage()
    """

    def __init__(self, op: Operator):
        super().__init__(workflow_energy_per_harmonic._spec().outputs, op)
        self._harmonic_energy = Output(
            workflow_energy_per_harmonic._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._harmonic_energy)
        self._harmonic_energy_percentage = Output(
            workflow_energy_per_harmonic._spec().output_pin(1), 1, op
        )
        self._outputs.append(self._harmonic_energy_percentage)

    @property
    def harmonic_energy(self):
        """Allows to get harmonic_energy output of the operator

        Returns
        ----------
        my_harmonic_energy : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_harmonic()
        >>> # Connect inputs : op.inputs. ...
        >>> result_harmonic_energy = op.outputs.harmonic_energy()
        """  # noqa: E501
        return self._harmonic_energy

    @property
    def harmonic_energy_percentage(self):
        """Allows to get harmonic_energy_percentage output of the operator

        Returns
        ----------
        my_harmonic_energy_percentage : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_harmonic()
        >>> # Connect inputs : op.inputs. ...
        >>> result_harmonic_energy_percentage = op.outputs.harmonic_energy_percentage()
        """  # noqa: E501
        return self._harmonic_energy_percentage
