"""
workflow_energy_per_component
=============================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class workflow_energy_per_component(Operator):
    """Calculates the cumulated energy per component (Named Selection). For
    cyclic and multistage models, the expansion will be automatically
    done.

    Parameters
    ----------
    time_scoping : Scoping, optional
    mesh_scoping : Scoping, optional
        Master scoping. all named selections will be
        intersected with this scoping.
    energy_type : int, optional
        Type of energy to be processed: (0: strain +
        kinetic energy (default), 1: strain
        energy, 2: kinetic energy)
    data_sources : DataSources
    named_selection1 : str, optional
        Named selections. intersection of all  named
        selections with the master scoping
        will be done.
    named_selection2 : str, optional
        Named selections. intersection of all  named
        selections with the master scoping
        will be done.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.workflow_energy_per_component()

    >>> # Make input connections
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_energy_type = int()
    >>> op.inputs.energy_type.connect(my_energy_type)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_named_selection1 = str()
    >>> op.inputs.named_selection1.connect(my_named_selection1)
    >>> my_named_selection2 = str()
    >>> op.inputs.named_selection2.connect(my_named_selection2)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.workflow_energy_per_component(
    ...     time_scoping=my_time_scoping,
    ...     mesh_scoping=my_mesh_scoping,
    ...     energy_type=my_energy_type,
    ...     data_sources=my_data_sources,
    ...     named_selection1=my_named_selection1,
    ...     named_selection2=my_named_selection2,
    ... )

    >>> # Get output data
    >>> result_component_energy = op.outputs.component_energy()
    >>> result_component_energy_percentage = op.outputs.component_energy_percentage()
    """

    def __init__(
        self,
        time_scoping=None,
        mesh_scoping=None,
        energy_type=None,
        data_sources=None,
        named_selection1=None,
        named_selection2=None,
        config=None,
        server=None,
    ):
        super().__init__(
            name="workflow_energy_per_component", config=config, server=server
        )
        self._inputs = InputsWorkflowEnergyPerComponent(self)
        self._outputs = OutputsWorkflowEnergyPerComponent(self)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)
        if mesh_scoping is not None:
            self.inputs.mesh_scoping.connect(mesh_scoping)
        if energy_type is not None:
            self.inputs.energy_type.connect(energy_type)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)
        if named_selection1 is not None:
            self.inputs.named_selection1.connect(named_selection1)
        if named_selection2 is not None:
            self.inputs.named_selection2.connect(named_selection2)

    @staticmethod
    def _spec():
        description = """Calculates the cumulated energy per component (Named Selection). For
            cyclic and multistage models, the expansion will be
            automatically done."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""""",
                ),
                1: PinSpecification(
                    name="mesh_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""Master scoping. all named selections will be
        intersected with this scoping.""",
                ),
                2: PinSpecification(
                    name="energy_type",
                    type_names=["int32"],
                    optional=True,
                    document="""Type of energy to be processed: (0: strain +
        kinetic energy (default), 1: strain
        energy, 2: kinetic energy)""",
                ),
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""""",
                ),
                5: PinSpecification(
                    name="named_selection",
                    type_names=["string"],
                    optional=True,
                    document="""Named selections. intersection of all  named
        selections with the master scoping
        will be done.""",
                ),
                6: PinSpecification(
                    name="named_selection",
                    type_names=["string"],
                    optional=True,
                    document="""Named selections. intersection of all  named
        selections with the master scoping
        will be done.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="component_energy",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="component_energy_percentage",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="workflow_energy_per_component", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsWorkflowEnergyPerComponent
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsWorkflowEnergyPerComponent
        """
        return super().outputs


class InputsWorkflowEnergyPerComponent(_Inputs):
    """Intermediate class used to connect user inputs to
    workflow_energy_per_component operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.workflow_energy_per_component()
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_energy_type = int()
    >>> op.inputs.energy_type.connect(my_energy_type)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_named_selection1 = str()
    >>> op.inputs.named_selection1.connect(my_named_selection1)
    >>> my_named_selection2 = str()
    >>> op.inputs.named_selection2.connect(my_named_selection2)
    """

    def __init__(self, op: Operator):
        super().__init__(workflow_energy_per_component._spec().inputs, op)
        self._time_scoping = Input(
            workflow_energy_per_component._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._time_scoping)
        self._mesh_scoping = Input(
            workflow_energy_per_component._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._mesh_scoping)
        self._energy_type = Input(
            workflow_energy_per_component._spec().input_pin(2), 2, op, -1
        )
        self._inputs.append(self._energy_type)
        self._data_sources = Input(
            workflow_energy_per_component._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._data_sources)
        self._named_selection1 = Input(
            workflow_energy_per_component._spec().input_pin(5), 5, op, 0
        )
        self._inputs.append(self._named_selection1)
        self._named_selection2 = Input(
            workflow_energy_per_component._spec().input_pin(6), 6, op, 1
        )
        self._inputs.append(self._named_selection2)

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Parameters
        ----------
        my_time_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping

    @property
    def mesh_scoping(self):
        """Allows to connect mesh_scoping input to the operator.

        Master scoping. all named selections will be
        intersected with this scoping.

        Parameters
        ----------
        my_mesh_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
        >>> # or
        >>> op.inputs.mesh_scoping(my_mesh_scoping)
        """
        return self._mesh_scoping

    @property
    def energy_type(self):
        """Allows to connect energy_type input to the operator.

        Type of energy to be processed: (0: strain +
        kinetic energy (default), 1: strain
        energy, 2: kinetic energy)

        Parameters
        ----------
        my_energy_type : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> op.inputs.energy_type.connect(my_energy_type)
        >>> # or
        >>> op.inputs.energy_type(my_energy_type)
        """
        return self._energy_type

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources

    @property
    def named_selection1(self):
        """Allows to connect named_selection1 input to the operator.

        Named selections. intersection of all  named
        selections with the master scoping
        will be done.

        Parameters
        ----------
        my_named_selection1 : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> op.inputs.named_selection1.connect(my_named_selection1)
        >>> # or
        >>> op.inputs.named_selection1(my_named_selection1)
        """
        return self._named_selection1

    @property
    def named_selection2(self):
        """Allows to connect named_selection2 input to the operator.

        Named selections. intersection of all  named
        selections with the master scoping
        will be done.

        Parameters
        ----------
        my_named_selection2 : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> op.inputs.named_selection2.connect(my_named_selection2)
        >>> # or
        >>> op.inputs.named_selection2(my_named_selection2)
        """
        return self._named_selection2


class OutputsWorkflowEnergyPerComponent(_Outputs):
    """Intermediate class used to get outputs from
    workflow_energy_per_component operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.workflow_energy_per_component()
    >>> # Connect inputs : op.inputs. ...
    >>> result_component_energy = op.outputs.component_energy()
    >>> result_component_energy_percentage = op.outputs.component_energy_percentage()
    """

    def __init__(self, op: Operator):
        super().__init__(workflow_energy_per_component._spec().outputs, op)
        self._component_energy = Output(
            workflow_energy_per_component._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._component_energy)
        self._component_energy_percentage = Output(
            workflow_energy_per_component._spec().output_pin(1), 1, op
        )
        self._outputs.append(self._component_energy_percentage)

    @property
    def component_energy(self):
        """Allows to get component_energy output of the operator

        Returns
        ----------
        my_component_energy : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> # Connect inputs : op.inputs. ...
        >>> result_component_energy = op.outputs.component_energy()
        """  # noqa: E501
        return self._component_energy

    @property
    def component_energy_percentage(self):
        """Allows to get component_energy_percentage output of the operator

        Returns
        ----------
        my_component_energy_percentage : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.workflow_energy_per_component()
        >>> # Connect inputs : op.inputs. ...
        >>> result_component_energy_percentage = op.outputs.component_energy_percentage()
        """  # noqa: E501
        return self._component_energy_percentage
