"""
strain_eqv_as_mechanical
========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class strain_eqv_as_mechanical(Operator):
    """Computes the equivalent (Von Mises) elastic strains and averages it to
    the nodes (by default). For multibody simulations, averaging
    across bodies can either be activated or deactivated.

    Parameters
    ----------
    time_scoping : Scoping, optional
        Time/freq (use doubles or field), time/freq
        set ids (use ints or scoping) or
        time/freq step ids use scoping with
        timefreq_steps location) required in
        output.
    mesh_scoping : Scoping or ScopingsContainer, optional
        Nodes or elements scoping required in output.
    streams_container : StreamsContainer, optional
        Result file container allowed to be kept open
        to cache data.
    data_sources : DataSources
        Result file path container.
    mesh : MeshedRegion or MeshesContainer, optional
        Prevents from reading the mesh in the results
        file.
    requested_location : str, optional
        Average the elemental nodal result to the
        requested location (default is
        nodal).
    poisson_ratio : int or float, optional
        Poisson ratio to be used in equivalent strain
        calculation.
    read_cyclic : bool, optional
        If true, cyclic expansion is done. if false,
        it's ignored.
    average_across_bodies : bool, optional
        For multibody simulations, the stresses are
        averaged across bodies if true or not
        if false (default).


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.strain_eqv_as_mechanical()

    >>> # Make input connections
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_mesh = dpf.MeshedRegion()
    >>> op.inputs.mesh.connect(my_mesh)
    >>> my_requested_location = str()
    >>> op.inputs.requested_location.connect(my_requested_location)
    >>> my_poisson_ratio = int()
    >>> op.inputs.poisson_ratio.connect(my_poisson_ratio)
    >>> my_read_cyclic = bool()
    >>> op.inputs.read_cyclic.connect(my_read_cyclic)
    >>> my_average_across_bodies = bool()
    >>> op.inputs.average_across_bodies.connect(my_average_across_bodies)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.strain_eqv_as_mechanical(
    ...     time_scoping=my_time_scoping,
    ...     mesh_scoping=my_mesh_scoping,
    ...     streams_container=my_streams_container,
    ...     data_sources=my_data_sources,
    ...     mesh=my_mesh,
    ...     requested_location=my_requested_location,
    ...     poisson_ratio=my_poisson_ratio,
    ...     read_cyclic=my_read_cyclic,
    ...     average_across_bodies=my_average_across_bodies,
    ... )

    >>> # Get output data
    >>> result_fields_container = op.outputs.fields_container()
    >>> result_meshes_container = op.outputs.meshes_container()
    """

    def __init__(
        self,
        time_scoping=None,
        mesh_scoping=None,
        streams_container=None,
        data_sources=None,
        mesh=None,
        requested_location=None,
        poisson_ratio=None,
        read_cyclic=None,
        average_across_bodies=None,
        config=None,
        server=None,
    ):
        super().__init__(name="strain_eqv_as_mechanical", config=config, server=server)
        self._inputs = InputsStrainEqvAsMechanical(self)
        self._outputs = OutputsStrainEqvAsMechanical(self)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)
        if mesh_scoping is not None:
            self.inputs.mesh_scoping.connect(mesh_scoping)
        if streams_container is not None:
            self.inputs.streams_container.connect(streams_container)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)
        if mesh is not None:
            self.inputs.mesh.connect(mesh)
        if requested_location is not None:
            self.inputs.requested_location.connect(requested_location)
        if poisson_ratio is not None:
            self.inputs.poisson_ratio.connect(poisson_ratio)
        if read_cyclic is not None:
            self.inputs.read_cyclic.connect(read_cyclic)
        if average_across_bodies is not None:
            self.inputs.average_across_bodies.connect(average_across_bodies)

    @staticmethod
    def _spec():
        description = """Computes the equivalent (Von Mises) elastic strains and averages it to
            the nodes (by default). For multibody simulations,
            averaging across bodies can either be activated or
            deactivated."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping", "vector<int32>"],
                    optional=True,
                    document="""Time/freq (use doubles or field), time/freq
        set ids (use ints or scoping) or
        time/freq step ids use scoping with
        timefreq_steps location) required in
        output.""",
                ),
                1: PinSpecification(
                    name="mesh_scoping",
                    type_names=["scoping", "scopings_container"],
                    optional=True,
                    document="""Nodes or elements scoping required in output.""",
                ),
                3: PinSpecification(
                    name="streams_container",
                    type_names=["streams_container"],
                    optional=True,
                    document="""Result file container allowed to be kept open
        to cache data.""",
                ),
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""Result file path container.""",
                ),
                7: PinSpecification(
                    name="mesh",
                    type_names=["abstract_meshed_region", "meshes_container"],
                    optional=True,
                    document="""Prevents from reading the mesh in the results
        file.""",
                ),
                9: PinSpecification(
                    name="requested_location",
                    type_names=["string"],
                    optional=True,
                    document="""Average the elemental nodal result to the
        requested location (default is
        nodal).""",
                ),
                13: PinSpecification(
                    name="poisson_ratio",
                    type_names=["int32", "double"],
                    optional=True,
                    document="""Poisson ratio to be used in equivalent strain
        calculation.""",
                ),
                14: PinSpecification(
                    name="read_cyclic",
                    type_names=["bool"],
                    optional=True,
                    document="""If true, cyclic expansion is done. if false,
        it's ignored.""",
                ),
                200: PinSpecification(
                    name="average_across_bodies",
                    type_names=["bool"],
                    optional=True,
                    document="""For multibody simulations, the stresses are
        averaged across bodies if true or not
        if false (default).""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="meshes_container",
                    type_names=["meshes_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="strain_eqv_as_mechanical", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsStrainEqvAsMechanical
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsStrainEqvAsMechanical
        """
        return super().outputs


class InputsStrainEqvAsMechanical(_Inputs):
    """Intermediate class used to connect user inputs to
    strain_eqv_as_mechanical operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.strain_eqv_as_mechanical()
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_mesh = dpf.MeshedRegion()
    >>> op.inputs.mesh.connect(my_mesh)
    >>> my_requested_location = str()
    >>> op.inputs.requested_location.connect(my_requested_location)
    >>> my_poisson_ratio = int()
    >>> op.inputs.poisson_ratio.connect(my_poisson_ratio)
    >>> my_read_cyclic = bool()
    >>> op.inputs.read_cyclic.connect(my_read_cyclic)
    >>> my_average_across_bodies = bool()
    >>> op.inputs.average_across_bodies.connect(my_average_across_bodies)
    """

    def __init__(self, op: Operator):
        super().__init__(strain_eqv_as_mechanical._spec().inputs, op)
        self._time_scoping = Input(
            strain_eqv_as_mechanical._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._time_scoping)
        self._mesh_scoping = Input(
            strain_eqv_as_mechanical._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._mesh_scoping)
        self._streams_container = Input(
            strain_eqv_as_mechanical._spec().input_pin(3), 3, op, -1
        )
        self._inputs.append(self._streams_container)
        self._data_sources = Input(
            strain_eqv_as_mechanical._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._data_sources)
        self._mesh = Input(strain_eqv_as_mechanical._spec().input_pin(7), 7, op, -1)
        self._inputs.append(self._mesh)
        self._requested_location = Input(
            strain_eqv_as_mechanical._spec().input_pin(9), 9, op, -1
        )
        self._inputs.append(self._requested_location)
        self._poisson_ratio = Input(
            strain_eqv_as_mechanical._spec().input_pin(13), 13, op, -1
        )
        self._inputs.append(self._poisson_ratio)
        self._read_cyclic = Input(
            strain_eqv_as_mechanical._spec().input_pin(14), 14, op, -1
        )
        self._inputs.append(self._read_cyclic)
        self._average_across_bodies = Input(
            strain_eqv_as_mechanical._spec().input_pin(200), 200, op, -1
        )
        self._inputs.append(self._average_across_bodies)

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Time/freq (use doubles or field), time/freq
        set ids (use ints or scoping) or
        time/freq step ids use scoping with
        timefreq_steps location) required in
        output.

        Parameters
        ----------
        my_time_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping

    @property
    def mesh_scoping(self):
        """Allows to connect mesh_scoping input to the operator.

        Nodes or elements scoping required in output.

        Parameters
        ----------
        my_mesh_scoping : Scoping or ScopingsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
        >>> # or
        >>> op.inputs.mesh_scoping(my_mesh_scoping)
        """
        return self._mesh_scoping

    @property
    def streams_container(self):
        """Allows to connect streams_container input to the operator.

        Result file container allowed to be kept open
        to cache data.

        Parameters
        ----------
        my_streams_container : StreamsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.streams_container.connect(my_streams_container)
        >>> # or
        >>> op.inputs.streams_container(my_streams_container)
        """
        return self._streams_container

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        Result file path container.

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources

    @property
    def mesh(self):
        """Allows to connect mesh input to the operator.

        Prevents from reading the mesh in the results
        file.

        Parameters
        ----------
        my_mesh : MeshedRegion or MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.mesh.connect(my_mesh)
        >>> # or
        >>> op.inputs.mesh(my_mesh)
        """
        return self._mesh

    @property
    def requested_location(self):
        """Allows to connect requested_location input to the operator.

        Average the elemental nodal result to the
        requested location (default is
        nodal).

        Parameters
        ----------
        my_requested_location : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.requested_location.connect(my_requested_location)
        >>> # or
        >>> op.inputs.requested_location(my_requested_location)
        """
        return self._requested_location

    @property
    def poisson_ratio(self):
        """Allows to connect poisson_ratio input to the operator.

        Poisson ratio to be used in equivalent strain
        calculation.

        Parameters
        ----------
        my_poisson_ratio : int or float

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.poisson_ratio.connect(my_poisson_ratio)
        >>> # or
        >>> op.inputs.poisson_ratio(my_poisson_ratio)
        """
        return self._poisson_ratio

    @property
    def read_cyclic(self):
        """Allows to connect read_cyclic input to the operator.

        If true, cyclic expansion is done. if false,
        it's ignored.

        Parameters
        ----------
        my_read_cyclic : bool

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.read_cyclic.connect(my_read_cyclic)
        >>> # or
        >>> op.inputs.read_cyclic(my_read_cyclic)
        """
        return self._read_cyclic

    @property
    def average_across_bodies(self):
        """Allows to connect average_across_bodies input to the operator.

        For multibody simulations, the stresses are
        averaged across bodies if true or not
        if false (default).

        Parameters
        ----------
        my_average_across_bodies : bool

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> op.inputs.average_across_bodies.connect(my_average_across_bodies)
        >>> # or
        >>> op.inputs.average_across_bodies(my_average_across_bodies)
        """
        return self._average_across_bodies


class OutputsStrainEqvAsMechanical(_Outputs):
    """Intermediate class used to get outputs from
    strain_eqv_as_mechanical operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.strain_eqv_as_mechanical()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields_container = op.outputs.fields_container()
    >>> result_meshes_container = op.outputs.meshes_container()
    """

    def __init__(self, op: Operator):
        super().__init__(strain_eqv_as_mechanical._spec().outputs, op)
        self._fields_container = Output(
            strain_eqv_as_mechanical._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._fields_container)
        self._meshes_container = Output(
            strain_eqv_as_mechanical._spec().output_pin(1), 1, op
        )
        self._outputs.append(self._meshes_container)

    @property
    def fields_container(self):
        """Allows to get fields_container output of the operator

        Returns
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields_container = op.outputs.fields_container()
        """  # noqa: E501
        return self._fields_container

    @property
    def meshes_container(self):
        """Allows to get meshes_container output of the operator

        Returns
        ----------
        my_meshes_container : MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.strain_eqv_as_mechanical()
        >>> # Connect inputs : op.inputs. ...
        >>> result_meshes_container = op.outputs.meshes_container()
        """  # noqa: E501
        return self._meshes_container
