"""
mesh_property_provider
======================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.outputs import _modify_output_spec_with_one_type
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class mesh_property_provider(Operator):
    """Reads a property related to the mesh, defined by its name, by calling
    the readers defined by the data sources. These properties can be
    used to fill in the mesh.

    Parameters
    ----------
    mesh_scoping : Scoping, optional
        Retrieves a property field on a subset of
        elements or nodes.
    streams_container : StreamsContainer, optional
        Streams (result file container) (optional)
    data_sources : DataSources
        If the stream is null, retrieves the file
        path from the data sources.
    property_name : str
        Supported property names are: "mat",
        "named_selection",
        "named_selection_names",
        "apdl_element_type", "section",
        "elprops", "keyopt_1" to "keyopt_18".
    property_identifier : int or str, optional
        Retrieves a property at a given index or by
        name. for example, a named
        selection's number or a named
        selection's name.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.metadata.mesh_property_provider()

    >>> # Make input connections
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_property_name = str()
    >>> op.inputs.property_name.connect(my_property_name)
    >>> my_property_identifier = int()
    >>> op.inputs.property_identifier.connect(my_property_identifier)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.metadata.mesh_property_provider(
    ...     mesh_scoping=my_mesh_scoping,
    ...     streams_container=my_streams_container,
    ...     data_sources=my_data_sources,
    ...     property_name=my_property_name,
    ...     property_identifier=my_property_identifier,
    ... )

    >>> # Get output data
    >>> result_property = op.outputs.property()
    """

    def __init__(
        self,
        mesh_scoping=None,
        streams_container=None,
        data_sources=None,
        property_name=None,
        property_identifier=None,
        config=None,
        server=None,
    ):
        super().__init__(name="mesh_property_provider", config=config, server=server)
        self._inputs = InputsMeshPropertyProvider(self)
        self._outputs = OutputsMeshPropertyProvider(self)
        if mesh_scoping is not None:
            self.inputs.mesh_scoping.connect(mesh_scoping)
        if streams_container is not None:
            self.inputs.streams_container.connect(streams_container)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)
        if property_name is not None:
            self.inputs.property_name.connect(property_name)
        if property_identifier is not None:
            self.inputs.property_identifier.connect(property_identifier)

    @staticmethod
    def _spec():
        description = """Reads a property related to the mesh, defined by its name, by calling
            the readers defined by the data sources. These properties
            can be used to fill in the mesh."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                1: PinSpecification(
                    name="mesh_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""Retrieves a property field on a subset of
        elements or nodes.""",
                ),
                3: PinSpecification(
                    name="streams_container",
                    type_names=["streams_container"],
                    optional=True,
                    document="""Streams (result file container) (optional)""",
                ),
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""If the stream is null, retrieves the file
        path from the data sources.""",
                ),
                13: PinSpecification(
                    name="property_name",
                    type_names=["string"],
                    optional=False,
                    document="""Supported property names are: "mat",
        "named_selection",
        "named_selection_names",
        "apdl_element_type", "section",
        "elprops", "keyopt_1" to "keyopt_18".""",
                ),
                17: PinSpecification(
                    name="property_identifier",
                    type_names=["int32", "string"],
                    optional=True,
                    document="""Retrieves a property at a given index or by
        name. for example, a named
        selection's number or a named
        selection's name.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="property",
                    type_names=["scoping", "property_field", "string_field"],
                    optional=False,
                    document="""Returns a property field for properties:
        "mat", "apdl_element_type",
        "section", "elprops", "keyopt_1" to
        "keyopt_18" (or any mesh's property
        field), a scoping for
        properties:"named_selection, a string
        field for properties:
        "named_selection_names".""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="mesh_property_provider", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsMeshPropertyProvider
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsMeshPropertyProvider
        """
        return super().outputs


class InputsMeshPropertyProvider(_Inputs):
    """Intermediate class used to connect user inputs to
    mesh_property_provider operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.metadata.mesh_property_provider()
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_property_name = str()
    >>> op.inputs.property_name.connect(my_property_name)
    >>> my_property_identifier = int()
    >>> op.inputs.property_identifier.connect(my_property_identifier)
    """

    def __init__(self, op: Operator):
        super().__init__(mesh_property_provider._spec().inputs, op)
        self._mesh_scoping = Input(
            mesh_property_provider._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._mesh_scoping)
        self._streams_container = Input(
            mesh_property_provider._spec().input_pin(3), 3, op, -1
        )
        self._inputs.append(self._streams_container)
        self._data_sources = Input(
            mesh_property_provider._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._data_sources)
        self._property_name = Input(
            mesh_property_provider._spec().input_pin(13), 13, op, -1
        )
        self._inputs.append(self._property_name)
        self._property_identifier = Input(
            mesh_property_provider._spec().input_pin(17), 17, op, -1
        )
        self._inputs.append(self._property_identifier)

    @property
    def mesh_scoping(self):
        """Allows to connect mesh_scoping input to the operator.

        Retrieves a property field on a subset of
        elements or nodes.

        Parameters
        ----------
        my_mesh_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.mesh_property_provider()
        >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
        >>> # or
        >>> op.inputs.mesh_scoping(my_mesh_scoping)
        """
        return self._mesh_scoping

    @property
    def streams_container(self):
        """Allows to connect streams_container input to the operator.

        Streams (result file container) (optional)

        Parameters
        ----------
        my_streams_container : StreamsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.mesh_property_provider()
        >>> op.inputs.streams_container.connect(my_streams_container)
        >>> # or
        >>> op.inputs.streams_container(my_streams_container)
        """
        return self._streams_container

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        If the stream is null, retrieves the file
        path from the data sources.

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.mesh_property_provider()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources

    @property
    def property_name(self):
        """Allows to connect property_name input to the operator.

        Supported property names are: "mat",
        "named_selection",
        "named_selection_names",
        "apdl_element_type", "section",
        "elprops", "keyopt_1" to "keyopt_18".

        Parameters
        ----------
        my_property_name : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.mesh_property_provider()
        >>> op.inputs.property_name.connect(my_property_name)
        >>> # or
        >>> op.inputs.property_name(my_property_name)
        """
        return self._property_name

    @property
    def property_identifier(self):
        """Allows to connect property_identifier input to the operator.

        Retrieves a property at a given index or by
        name. for example, a named
        selection's number or a named
        selection's name.

        Parameters
        ----------
        my_property_identifier : int or str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.mesh_property_provider()
        >>> op.inputs.property_identifier.connect(my_property_identifier)
        >>> # or
        >>> op.inputs.property_identifier(my_property_identifier)
        """
        return self._property_identifier


class OutputsMeshPropertyProvider(_Outputs):
    """Intermediate class used to get outputs from
    mesh_property_provider operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.metadata.mesh_property_provider()
    >>> # Connect inputs : op.inputs. ...
    >>> result_property = op.outputs.property()
    """

    def __init__(self, op: Operator):
        super().__init__(mesh_property_provider._spec().outputs, op)
        self.property_as_scoping = Output(
            _modify_output_spec_with_one_type(
                mesh_property_provider._spec().output_pin(0), "scoping"
            ),
            0,
            op,
        )
        self._outputs.append(self.property_as_scoping)
        self.property_as_property_field = Output(
            _modify_output_spec_with_one_type(
                mesh_property_provider._spec().output_pin(0), "property_field"
            ),
            0,
            op,
        )
        self._outputs.append(self.property_as_property_field)
        self.property_as_string_field = Output(
            _modify_output_spec_with_one_type(
                mesh_property_provider._spec().output_pin(0), "string_field"
            ),
            0,
            op,
        )
        self._outputs.append(self.property_as_string_field)
