"""
integrate_over_time_freq
========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class integrate_over_time_freq(Operator):
    """Integration of an input field over timefreq.

    Parameters
    ----------
    field : Field
    scoping : Scoping, optional
        Integrate the input field over a specific
        scoping.
    time_freq_support : TimeFreqSupport, optional
        Time freq to integrate on, otherwise time
        freq support from the input field is
        taken.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.metadata.integrate_over_time_freq()

    >>> # Make input connections
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_scoping = dpf.Scoping()
    >>> op.inputs.scoping.connect(my_scoping)
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.metadata.integrate_over_time_freq(
    ...     field=my_field,
    ...     scoping=my_scoping,
    ...     time_freq_support=my_time_freq_support,
    ... )

    >>> # Get output data
    >>> result_field = op.outputs.field()
    """

    def __init__(
        self, field=None, scoping=None, time_freq_support=None, config=None, server=None
    ):
        super().__init__(name="timefreq::integrate", config=config, server=server)
        self._inputs = InputsIntegrateOverTimeFreq(self)
        self._outputs = OutputsIntegrateOverTimeFreq(self)
        if field is not None:
            self.inputs.field.connect(field)
        if scoping is not None:
            self.inputs.scoping.connect(scoping)
        if time_freq_support is not None:
            self.inputs.time_freq_support.connect(time_freq_support)

    @staticmethod
    def _spec():
        description = """Integration of an input field over timefreq."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""Integrate the input field over a specific
        scoping.""",
                ),
                2: PinSpecification(
                    name="time_freq_support",
                    type_names=["time_freq_support"],
                    optional=True,
                    document="""Time freq to integrate on, otherwise time
        freq support from the input field is
        taken.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="timefreq::integrate", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsIntegrateOverTimeFreq
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsIntegrateOverTimeFreq
        """
        return super().outputs


class InputsIntegrateOverTimeFreq(_Inputs):
    """Intermediate class used to connect user inputs to
    integrate_over_time_freq operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.metadata.integrate_over_time_freq()
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_scoping = dpf.Scoping()
    >>> op.inputs.scoping.connect(my_scoping)
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    """

    def __init__(self, op: Operator):
        super().__init__(integrate_over_time_freq._spec().inputs, op)
        self._field = Input(integrate_over_time_freq._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._field)
        self._scoping = Input(integrate_over_time_freq._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._scoping)
        self._time_freq_support = Input(
            integrate_over_time_freq._spec().input_pin(2), 2, op, -1
        )
        self._inputs.append(self._time_freq_support)

    @property
    def field(self):
        """Allows to connect field input to the operator.

        Parameters
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.integrate_over_time_freq()
        >>> op.inputs.field.connect(my_field)
        >>> # or
        >>> op.inputs.field(my_field)
        """
        return self._field

    @property
    def scoping(self):
        """Allows to connect scoping input to the operator.

        Integrate the input field over a specific
        scoping.

        Parameters
        ----------
        my_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.integrate_over_time_freq()
        >>> op.inputs.scoping.connect(my_scoping)
        >>> # or
        >>> op.inputs.scoping(my_scoping)
        """
        return self._scoping

    @property
    def time_freq_support(self):
        """Allows to connect time_freq_support input to the operator.

        Time freq to integrate on, otherwise time
        freq support from the input field is
        taken.

        Parameters
        ----------
        my_time_freq_support : TimeFreqSupport

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.integrate_over_time_freq()
        >>> op.inputs.time_freq_support.connect(my_time_freq_support)
        >>> # or
        >>> op.inputs.time_freq_support(my_time_freq_support)
        """
        return self._time_freq_support


class OutputsIntegrateOverTimeFreq(_Outputs):
    """Intermediate class used to get outputs from
    integrate_over_time_freq operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.metadata.integrate_over_time_freq()
    >>> # Connect inputs : op.inputs. ...
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(integrate_over_time_freq._spec().outputs, op)
        self._field = Output(integrate_over_time_freq._spec().output_pin(0), 0, op)
        self._outputs.append(self._field)

    @property
    def field(self):
        """Allows to get field output of the operator

        Returns
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.integrate_over_time_freq()
        >>> # Connect inputs : op.inputs. ...
        >>> result_field = op.outputs.field()
        """  # noqa: E501
        return self._field
