"""
get_attribute
=============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.outputs import _modify_output_spec_with_one_type
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class get_attribute(Operator):
    """Uses the TimeFreqSupport APIs to return a given attribute of the
    scoping in input.

    Parameters
    ----------
    time_freq_support : TimeFreqSupport
    property_name : str
        Supported property names are: "time_freqs",
        "imaginary_freqs",
        "frequency_tolerance", "set_id",
        "cummulative_index", "sets_freqs".
    property_identifier : int, optional
        Additional pin for properties "set_id" and
        "cummulative_index": the step id, for
        "sets_freqs": the sets scoping.
    property_identifier_2 : int, optional
        Additional pin for properties "set_id" and
        "cummulative_index": the substep id
        (if none, last substep is
        considered).


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.metadata.get_attribute()

    >>> # Make input connections
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    >>> my_property_name = str()
    >>> op.inputs.property_name.connect(my_property_name)
    >>> my_property_identifier = int()
    >>> op.inputs.property_identifier.connect(my_property_identifier)
    >>> my_property_identifier_2 = int()
    >>> op.inputs.property_identifier_2.connect(my_property_identifier_2)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.metadata.get_attribute(
    ...     time_freq_support=my_time_freq_support,
    ...     property_name=my_property_name,
    ...     property_identifier=my_property_identifier,
    ...     property_identifier_2=my_property_identifier_2,
    ... )

    >>> # Get output data
    >>> result_property = op.outputs.property()
    """

    def __init__(
        self,
        time_freq_support=None,
        property_name=None,
        property_identifier=None,
        property_identifier_2=None,
        config=None,
        server=None,
    ):
        super().__init__(
            name="timefreqsupport::get_attribute", config=config, server=server
        )
        self._inputs = InputsGetAttribute(self)
        self._outputs = OutputsGetAttribute(self)
        if time_freq_support is not None:
            self.inputs.time_freq_support.connect(time_freq_support)
        if property_name is not None:
            self.inputs.property_name.connect(property_name)
        if property_identifier is not None:
            self.inputs.property_identifier.connect(property_identifier)
        if property_identifier_2 is not None:
            self.inputs.property_identifier_2.connect(property_identifier_2)

    @staticmethod
    def _spec():
        description = """Uses the TimeFreqSupport APIs to return a given attribute of the
            scoping in input."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_freq_support",
                    type_names=["time_freq_support"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="property_name",
                    type_names=["string"],
                    optional=False,
                    document="""Supported property names are: "time_freqs",
        "imaginary_freqs",
        "frequency_tolerance", "set_id",
        "cummulative_index", "sets_freqs".""",
                ),
                2: PinSpecification(
                    name="property_identifier",
                    type_names=["int32"],
                    optional=True,
                    document="""Additional pin for properties "set_id" and
        "cummulative_index": the step id, for
        "sets_freqs": the sets scoping.""",
                ),
                3: PinSpecification(
                    name="property_identifier_2",
                    type_names=["int32"],
                    optional=True,
                    document="""Additional pin for properties "set_id" and
        "cummulative_index": the substep id
        (if none, last substep is
        considered).""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="property",
                    type_names=["double", "field", "scoping"],
                    optional=False,
                    document="""Returns a double for property:
        "frequency_tolerance", a single-value
        scoping for properties for "set_id"
        and "cummulative_index", and a field
        otherwise.""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="timefreqsupport::get_attribute", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsGetAttribute
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsGetAttribute
        """
        return super().outputs


class InputsGetAttribute(_Inputs):
    """Intermediate class used to connect user inputs to
    get_attribute operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.metadata.get_attribute()
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    >>> my_property_name = str()
    >>> op.inputs.property_name.connect(my_property_name)
    >>> my_property_identifier = int()
    >>> op.inputs.property_identifier.connect(my_property_identifier)
    >>> my_property_identifier_2 = int()
    >>> op.inputs.property_identifier_2.connect(my_property_identifier_2)
    """

    def __init__(self, op: Operator):
        super().__init__(get_attribute._spec().inputs, op)
        self._time_freq_support = Input(get_attribute._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._time_freq_support)
        self._property_name = Input(get_attribute._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._property_name)
        self._property_identifier = Input(get_attribute._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._property_identifier)
        self._property_identifier_2 = Input(
            get_attribute._spec().input_pin(3), 3, op, -1
        )
        self._inputs.append(self._property_identifier_2)

    @property
    def time_freq_support(self):
        """Allows to connect time_freq_support input to the operator.

        Parameters
        ----------
        my_time_freq_support : TimeFreqSupport

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.get_attribute()
        >>> op.inputs.time_freq_support.connect(my_time_freq_support)
        >>> # or
        >>> op.inputs.time_freq_support(my_time_freq_support)
        """
        return self._time_freq_support

    @property
    def property_name(self):
        """Allows to connect property_name input to the operator.

        Supported property names are: "time_freqs",
        "imaginary_freqs",
        "frequency_tolerance", "set_id",
        "cummulative_index", "sets_freqs".

        Parameters
        ----------
        my_property_name : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.get_attribute()
        >>> op.inputs.property_name.connect(my_property_name)
        >>> # or
        >>> op.inputs.property_name(my_property_name)
        """
        return self._property_name

    @property
    def property_identifier(self):
        """Allows to connect property_identifier input to the operator.

        Additional pin for properties "set_id" and
        "cummulative_index": the step id, for
        "sets_freqs": the sets scoping.

        Parameters
        ----------
        my_property_identifier : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.get_attribute()
        >>> op.inputs.property_identifier.connect(my_property_identifier)
        >>> # or
        >>> op.inputs.property_identifier(my_property_identifier)
        """
        return self._property_identifier

    @property
    def property_identifier_2(self):
        """Allows to connect property_identifier_2 input to the operator.

        Additional pin for properties "set_id" and
        "cummulative_index": the substep id
        (if none, last substep is
        considered).

        Parameters
        ----------
        my_property_identifier_2 : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.metadata.get_attribute()
        >>> op.inputs.property_identifier_2.connect(my_property_identifier_2)
        >>> # or
        >>> op.inputs.property_identifier_2(my_property_identifier_2)
        """
        return self._property_identifier_2


class OutputsGetAttribute(_Outputs):
    """Intermediate class used to get outputs from
    get_attribute operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.metadata.get_attribute()
    >>> # Connect inputs : op.inputs. ...
    >>> result_property = op.outputs.property()
    """

    def __init__(self, op: Operator):
        super().__init__(get_attribute._spec().outputs, op)
        self.property_as_double = Output(
            _modify_output_spec_with_one_type(
                get_attribute._spec().output_pin(0), "double"
            ),
            0,
            op,
        )
        self._outputs.append(self.property_as_double)
        self.property_as_field = Output(
            _modify_output_spec_with_one_type(
                get_attribute._spec().output_pin(0), "field"
            ),
            0,
            op,
        )
        self._outputs.append(self.property_as_field)
        self.property_as_scoping = Output(
            _modify_output_spec_with_one_type(
                get_attribute._spec().output_pin(0), "scoping"
            ),
            0,
            op,
        )
        self._outputs.append(self.property_as_scoping)
