"""
mesh_extraction
===============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class mesh_extraction(Operator):
    """Take a mesh and a scoping (elemental or nodal) and create a new mesh
    that contains this selection only.

    Parameters
    ----------
    mesh : MeshedRegion
    mesh_scoping : Scoping
    extension : int, optional
        Number of extension layer


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.mesh.mesh_extraction()

    >>> # Make input connections
    >>> my_mesh = dpf.MeshedRegion()
    >>> op.inputs.mesh.connect(my_mesh)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_extension = int()
    >>> op.inputs.extension.connect(my_extension)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.mesh.mesh_extraction(
    ...     mesh=my_mesh,
    ...     mesh_scoping=my_mesh_scoping,
    ...     extension=my_extension,
    ... )

    >>> # Get output data
    >>> result_abstract_meshed_region = op.outputs.abstract_meshed_region()
    """

    def __init__(
        self, mesh=None, mesh_scoping=None, extension=None, config=None, server=None
    ):
        super().__init__(name="mesh_extraction", config=config, server=server)
        self._inputs = InputsMeshExtraction(self)
        self._outputs = OutputsMeshExtraction(self)
        if mesh is not None:
            self.inputs.mesh.connect(mesh)
        if mesh_scoping is not None:
            self.inputs.mesh_scoping.connect(mesh_scoping)
        if extension is not None:
            self.inputs.extension.connect(extension)

    @staticmethod
    def _spec():
        description = """Take a mesh and a scoping (elemental or nodal) and create a new mesh
            that contains this selection only."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="mesh",
                    type_names=["abstract_meshed_region"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="mesh_scoping",
                    type_names=["scoping"],
                    optional=False,
                    document="""""",
                ),
                2: PinSpecification(
                    name="extension",
                    type_names=["int32"],
                    optional=True,
                    document="""Number of extension layer""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="abstract_meshed_region",
                    type_names=["abstract_meshed_region"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="mesh_extraction", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsMeshExtraction
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsMeshExtraction
        """
        return super().outputs


class InputsMeshExtraction(_Inputs):
    """Intermediate class used to connect user inputs to
    mesh_extraction operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.mesh.mesh_extraction()
    >>> my_mesh = dpf.MeshedRegion()
    >>> op.inputs.mesh.connect(my_mesh)
    >>> my_mesh_scoping = dpf.Scoping()
    >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
    >>> my_extension = int()
    >>> op.inputs.extension.connect(my_extension)
    """

    def __init__(self, op: Operator):
        super().__init__(mesh_extraction._spec().inputs, op)
        self._mesh = Input(mesh_extraction._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._mesh)
        self._mesh_scoping = Input(mesh_extraction._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._mesh_scoping)
        self._extension = Input(mesh_extraction._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._extension)

    @property
    def mesh(self):
        """Allows to connect mesh input to the operator.

        Parameters
        ----------
        my_mesh : MeshedRegion

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.mesh_extraction()
        >>> op.inputs.mesh.connect(my_mesh)
        >>> # or
        >>> op.inputs.mesh(my_mesh)
        """
        return self._mesh

    @property
    def mesh_scoping(self):
        """Allows to connect mesh_scoping input to the operator.

        Parameters
        ----------
        my_mesh_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.mesh_extraction()
        >>> op.inputs.mesh_scoping.connect(my_mesh_scoping)
        >>> # or
        >>> op.inputs.mesh_scoping(my_mesh_scoping)
        """
        return self._mesh_scoping

    @property
    def extension(self):
        """Allows to connect extension input to the operator.

        Number of extension layer

        Parameters
        ----------
        my_extension : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.mesh_extraction()
        >>> op.inputs.extension.connect(my_extension)
        >>> # or
        >>> op.inputs.extension(my_extension)
        """
        return self._extension


class OutputsMeshExtraction(_Outputs):
    """Intermediate class used to get outputs from
    mesh_extraction operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.mesh.mesh_extraction()
    >>> # Connect inputs : op.inputs. ...
    >>> result_abstract_meshed_region = op.outputs.abstract_meshed_region()
    """

    def __init__(self, op: Operator):
        super().__init__(mesh_extraction._spec().outputs, op)
        self._abstract_meshed_region = Output(
            mesh_extraction._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._abstract_meshed_region)

    @property
    def abstract_meshed_region(self):
        """Allows to get abstract_meshed_region output of the operator

        Returns
        ----------
        my_abstract_meshed_region : MeshedRegion

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.mesh_extraction()
        >>> # Connect inputs : op.inputs. ...
        >>> result_abstract_meshed_region = op.outputs.abstract_meshed_region()
        """  # noqa: E501
        return self._abstract_meshed_region
