"""
change_cs
=========
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.outputs import _modify_output_spec_with_one_type
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class change_cs(Operator):
    """Applies a transformation (rotation and displacement) matrix on a mesh
    or meshes container.

    Parameters
    ----------
    meshes : MeshedRegion or MeshesContainer
    coordinate_system : Field
        3-3 rotation matrix + 3 translations (x, y,
        z)


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.mesh.change_cs()

    >>> # Make input connections
    >>> my_meshes = dpf.MeshedRegion()
    >>> op.inputs.meshes.connect(my_meshes)
    >>> my_coordinate_system = dpf.Field()
    >>> op.inputs.coordinate_system.connect(my_coordinate_system)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.mesh.change_cs(
    ...     meshes=my_meshes,
    ...     coordinate_system=my_coordinate_system,
    ... )

    >>> # Get output data
    >>> result_meshed_region = op.outputs.meshed_region()
    """

    def __init__(self, meshes=None, coordinate_system=None, config=None, server=None):
        super().__init__(name="mesh::change_cs", config=config, server=server)
        self._inputs = InputsChangeCs(self)
        self._outputs = OutputsChangeCs(self)
        if meshes is not None:
            self.inputs.meshes.connect(meshes)
        if coordinate_system is not None:
            self.inputs.coordinate_system.connect(coordinate_system)

    @staticmethod
    def _spec():
        description = """Applies a transformation (rotation and displacement) matrix on a mesh
            or meshes container."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="meshes",
                    type_names=["meshed_region", "meshes_container"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="coordinate_system",
                    type_names=["field"],
                    optional=False,
                    document="""3-3 rotation matrix + 3 translations (x, y,
        z)""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="meshed_region",
                    type_names=["meshed_region", "meshes_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="mesh::change_cs", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsChangeCs
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsChangeCs
        """
        return super().outputs


class InputsChangeCs(_Inputs):
    """Intermediate class used to connect user inputs to
    change_cs operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.mesh.change_cs()
    >>> my_meshes = dpf.MeshedRegion()
    >>> op.inputs.meshes.connect(my_meshes)
    >>> my_coordinate_system = dpf.Field()
    >>> op.inputs.coordinate_system.connect(my_coordinate_system)
    """

    def __init__(self, op: Operator):
        super().__init__(change_cs._spec().inputs, op)
        self._meshes = Input(change_cs._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._meshes)
        self._coordinate_system = Input(change_cs._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._coordinate_system)

    @property
    def meshes(self):
        """Allows to connect meshes input to the operator.

        Parameters
        ----------
        my_meshes : MeshedRegion or MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.change_cs()
        >>> op.inputs.meshes.connect(my_meshes)
        >>> # or
        >>> op.inputs.meshes(my_meshes)
        """
        return self._meshes

    @property
    def coordinate_system(self):
        """Allows to connect coordinate_system input to the operator.

        3-3 rotation matrix + 3 translations (x, y,
        z)

        Parameters
        ----------
        my_coordinate_system : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.change_cs()
        >>> op.inputs.coordinate_system.connect(my_coordinate_system)
        >>> # or
        >>> op.inputs.coordinate_system(my_coordinate_system)
        """
        return self._coordinate_system


class OutputsChangeCs(_Outputs):
    """Intermediate class used to get outputs from
    change_cs operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.mesh.change_cs()
    >>> # Connect inputs : op.inputs. ...
    >>> result_meshed_region = op.outputs.meshed_region()
    """

    def __init__(self, op: Operator):
        super().__init__(change_cs._spec().outputs, op)
        self.meshed_region_as_meshed_region = Output(
            _modify_output_spec_with_one_type(
                change_cs._spec().output_pin(0), "meshed_region"
            ),
            0,
            op,
        )
        self._outputs.append(self.meshed_region_as_meshed_region)
        self.meshed_region_as_meshes_container = Output(
            _modify_output_spec_with_one_type(
                change_cs._spec().output_pin(0), "meshes_container"
            ),
            0,
            op,
        )
        self._outputs.append(self.meshed_region_as_meshes_container)
