"""
time_freq_interpolation
=======================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class time_freq_interpolation(Operator):
    """Interpolates between all the matching fields of a fields container at
    given times or frequencies, using ramped: fieldOut =
    field1*(1.-fact)+field2*(fact), or stepped: fieldOut=field2. If
    the time freq is higher than the max available, the field at the
    max time freq is taken. Computes the output time freq support to
    support the fields container

    Parameters
    ----------
    fields_container : FieldsContainer
    time_freq_values : float or Field
        List of frequencies or times needed. to
        specify load steps, put a field (and
        not a list) in input with a scoping
        located on "timefreq_steps".
    step : int, optional
        If a field is set as input, the step ids
        should be its scoping.
    interpolation_type : int, optional
        1 is ramped, 2 is stepped, default is 0.
    force_new_time_freq_support : bool, optional
        If set to true, the output fields container
        will always have a new time freq
        support rescoped to the output
        time_freq_values (default is false).
        if set to false, the time freq
        support is only recreated when time
        or frequency values are between
        existing ones.
    time_freq_support : TimeFreqSupport, optional


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.math.time_freq_interpolation()

    >>> # Make input connections
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_time_freq_values = float()
    >>> op.inputs.time_freq_values.connect(my_time_freq_values)
    >>> my_step = int()
    >>> op.inputs.step.connect(my_step)
    >>> my_interpolation_type = int()
    >>> op.inputs.interpolation_type.connect(my_interpolation_type)
    >>> my_force_new_time_freq_support = bool()
    >>> op.inputs.force_new_time_freq_support.connect(my_force_new_time_freq_support)
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.math.time_freq_interpolation(
    ...     fields_container=my_fields_container,
    ...     time_freq_values=my_time_freq_values,
    ...     step=my_step,
    ...     interpolation_type=my_interpolation_type,
    ...     force_new_time_freq_support=my_force_new_time_freq_support,
    ...     time_freq_support=my_time_freq_support,
    ... )

    >>> # Get output data
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(
        self,
        fields_container=None,
        time_freq_values=None,
        step=None,
        interpolation_type=None,
        force_new_time_freq_support=None,
        time_freq_support=None,
        config=None,
        server=None,
    ):
        super().__init__(name="time_freq_interpolation", config=config, server=server)
        self._inputs = InputsTimeFreqInterpolation(self)
        self._outputs = OutputsTimeFreqInterpolation(self)
        if fields_container is not None:
            self.inputs.fields_container.connect(fields_container)
        if time_freq_values is not None:
            self.inputs.time_freq_values.connect(time_freq_values)
        if step is not None:
            self.inputs.step.connect(step)
        if interpolation_type is not None:
            self.inputs.interpolation_type.connect(interpolation_type)
        if force_new_time_freq_support is not None:
            self.inputs.force_new_time_freq_support.connect(force_new_time_freq_support)
        if time_freq_support is not None:
            self.inputs.time_freq_support.connect(time_freq_support)

    @staticmethod
    def _spec():
        description = """Interpolates between all the matching fields of a fields container at
            given times or frequencies, using ramped: fieldOut =
            field1*(1.-fact)+field2*(fact), or stepped:
            fieldOut=field2. If the time freq is higher than the max
            available, the field at the max time freq is taken.
            Computes the output time freq support to support the
            fields container"""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="time_freq_values",
                    type_names=["double", "vector<double>", "field"],
                    optional=False,
                    document="""List of frequencies or times needed. to
        specify load steps, put a field (and
        not a list) in input with a scoping
        located on "timefreq_steps".""",
                ),
                2: PinSpecification(
                    name="step",
                    type_names=["int32"],
                    optional=True,
                    document="""If a field is set as input, the step ids
        should be its scoping.""",
                ),
                3: PinSpecification(
                    name="interpolation_type",
                    type_names=["int32"],
                    optional=True,
                    document="""1 is ramped, 2 is stepped, default is 0.""",
                ),
                4: PinSpecification(
                    name="force_new_time_freq_support",
                    type_names=["bool"],
                    optional=True,
                    document="""If set to true, the output fields container
        will always have a new time freq
        support rescoped to the output
        time_freq_values (default is false).
        if set to false, the time freq
        support is only recreated when time
        or frequency values are between
        existing ones.""",
                ),
                8: PinSpecification(
                    name="time_freq_support",
                    type_names=["time_freq_support"],
                    optional=True,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="time_freq_interpolation", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsTimeFreqInterpolation
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsTimeFreqInterpolation
        """
        return super().outputs


class InputsTimeFreqInterpolation(_Inputs):
    """Intermediate class used to connect user inputs to
    time_freq_interpolation operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.math.time_freq_interpolation()
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_time_freq_values = float()
    >>> op.inputs.time_freq_values.connect(my_time_freq_values)
    >>> my_step = int()
    >>> op.inputs.step.connect(my_step)
    >>> my_interpolation_type = int()
    >>> op.inputs.interpolation_type.connect(my_interpolation_type)
    >>> my_force_new_time_freq_support = bool()
    >>> op.inputs.force_new_time_freq_support.connect(my_force_new_time_freq_support)
    >>> my_time_freq_support = dpf.TimeFreqSupport()
    >>> op.inputs.time_freq_support.connect(my_time_freq_support)
    """

    def __init__(self, op: Operator):
        super().__init__(time_freq_interpolation._spec().inputs, op)
        self._fields_container = Input(
            time_freq_interpolation._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._fields_container)
        self._time_freq_values = Input(
            time_freq_interpolation._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._time_freq_values)
        self._step = Input(time_freq_interpolation._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._step)
        self._interpolation_type = Input(
            time_freq_interpolation._spec().input_pin(3), 3, op, -1
        )
        self._inputs.append(self._interpolation_type)
        self._force_new_time_freq_support = Input(
            time_freq_interpolation._spec().input_pin(4), 4, op, -1
        )
        self._inputs.append(self._force_new_time_freq_support)
        self._time_freq_support = Input(
            time_freq_interpolation._spec().input_pin(8), 8, op, -1
        )
        self._inputs.append(self._time_freq_support)

    @property
    def fields_container(self):
        """Allows to connect fields_container input to the operator.

        Parameters
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> op.inputs.fields_container.connect(my_fields_container)
        >>> # or
        >>> op.inputs.fields_container(my_fields_container)
        """
        return self._fields_container

    @property
    def time_freq_values(self):
        """Allows to connect time_freq_values input to the operator.

        List of frequencies or times needed. to
        specify load steps, put a field (and
        not a list) in input with a scoping
        located on "timefreq_steps".

        Parameters
        ----------
        my_time_freq_values : float or Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> op.inputs.time_freq_values.connect(my_time_freq_values)
        >>> # or
        >>> op.inputs.time_freq_values(my_time_freq_values)
        """
        return self._time_freq_values

    @property
    def step(self):
        """Allows to connect step input to the operator.

        If a field is set as input, the step ids
        should be its scoping.

        Parameters
        ----------
        my_step : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> op.inputs.step.connect(my_step)
        >>> # or
        >>> op.inputs.step(my_step)
        """
        return self._step

    @property
    def interpolation_type(self):
        """Allows to connect interpolation_type input to the operator.

        1 is ramped, 2 is stepped, default is 0.

        Parameters
        ----------
        my_interpolation_type : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> op.inputs.interpolation_type.connect(my_interpolation_type)
        >>> # or
        >>> op.inputs.interpolation_type(my_interpolation_type)
        """
        return self._interpolation_type

    @property
    def force_new_time_freq_support(self):
        """Allows to connect force_new_time_freq_support input to the operator.

        If set to true, the output fields container
        will always have a new time freq
        support rescoped to the output
        time_freq_values (default is false).
        if set to false, the time freq
        support is only recreated when time
        or frequency values are between
        existing ones.

        Parameters
        ----------
        my_force_new_time_freq_support : bool

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> op.inputs.force_new_time_freq_support.connect(my_force_new_time_freq_support)
        >>> # or
        >>> op.inputs.force_new_time_freq_support(my_force_new_time_freq_support)
        """
        return self._force_new_time_freq_support

    @property
    def time_freq_support(self):
        """Allows to connect time_freq_support input to the operator.

        Parameters
        ----------
        my_time_freq_support : TimeFreqSupport

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> op.inputs.time_freq_support.connect(my_time_freq_support)
        >>> # or
        >>> op.inputs.time_freq_support(my_time_freq_support)
        """
        return self._time_freq_support


class OutputsTimeFreqInterpolation(_Outputs):
    """Intermediate class used to get outputs from
    time_freq_interpolation operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.math.time_freq_interpolation()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(self, op: Operator):
        super().__init__(time_freq_interpolation._spec().outputs, op)
        self._fields_container = Output(
            time_freq_interpolation._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._fields_container)

    @property
    def fields_container(self):
        """Allows to get fields_container output of the operator

        Returns
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.time_freq_interpolation()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields_container = op.outputs.fields_container()
        """  # noqa: E501
        return self._fields_container
