"""
accumulate_fc
=============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class accumulate_fc(Operator):
    """Sums all the elementary data of a field to produce one elementary data
    point.

    Parameters
    ----------
    fields_container : FieldsContainer
        Field or fields container with only one field
        is expected
    ponderation : Field
        Field
    time_scoping : Scoping
        Time_scoping


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.math.accumulate_fc()

    >>> # Make input connections
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_ponderation = dpf.Field()
    >>> op.inputs.ponderation.connect(my_ponderation)
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.math.accumulate_fc(
    ...     fields_container=my_fields_container,
    ...     ponderation=my_ponderation,
    ...     time_scoping=my_time_scoping,
    ... )

    >>> # Get output data
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(
        self,
        fields_container=None,
        ponderation=None,
        time_scoping=None,
        config=None,
        server=None,
    ):
        super().__init__(name="accumulate_fc", config=config, server=server)
        self._inputs = InputsAccumulateFc(self)
        self._outputs = OutputsAccumulateFc(self)
        if fields_container is not None:
            self.inputs.fields_container.connect(fields_container)
        if ponderation is not None:
            self.inputs.ponderation.connect(ponderation)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)

    @staticmethod
    def _spec():
        description = """Sums all the elementary data of a field to produce one elementary data
            point."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""Field or fields container with only one field
        is expected""",
                ),
                1: PinSpecification(
                    name="ponderation",
                    type_names=["field"],
                    optional=False,
                    document="""Field""",
                ),
                2: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping"],
                    optional=False,
                    document="""Time_scoping""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="accumulate_fc", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsAccumulateFc
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsAccumulateFc
        """
        return super().outputs


class InputsAccumulateFc(_Inputs):
    """Intermediate class used to connect user inputs to
    accumulate_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.math.accumulate_fc()
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_ponderation = dpf.Field()
    >>> op.inputs.ponderation.connect(my_ponderation)
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    """

    def __init__(self, op: Operator):
        super().__init__(accumulate_fc._spec().inputs, op)
        self._fields_container = Input(accumulate_fc._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._fields_container)
        self._ponderation = Input(accumulate_fc._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._ponderation)
        self._time_scoping = Input(accumulate_fc._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._time_scoping)

    @property
    def fields_container(self):
        """Allows to connect fields_container input to the operator.

        Field or fields container with only one field
        is expected

        Parameters
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.accumulate_fc()
        >>> op.inputs.fields_container.connect(my_fields_container)
        >>> # or
        >>> op.inputs.fields_container(my_fields_container)
        """
        return self._fields_container

    @property
    def ponderation(self):
        """Allows to connect ponderation input to the operator.

        Field

        Parameters
        ----------
        my_ponderation : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.accumulate_fc()
        >>> op.inputs.ponderation.connect(my_ponderation)
        >>> # or
        >>> op.inputs.ponderation(my_ponderation)
        """
        return self._ponderation

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Time_scoping

        Parameters
        ----------
        my_time_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.accumulate_fc()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping


class OutputsAccumulateFc(_Outputs):
    """Intermediate class used to get outputs from
    accumulate_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.math.accumulate_fc()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(self, op: Operator):
        super().__init__(accumulate_fc._spec().outputs, op)
        self._fields_container = Output(accumulate_fc._spec().output_pin(0), 0, op)
        self._outputs.append(self._fields_container)

    @property
    def fields_container(self):
        """Allows to get fields_container output of the operator

        Returns
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.math.accumulate_fc()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields_container = op.outputs.fields_container()
        """  # noqa: E501
        return self._fields_container
