"""
von_mises_eqv_fc
================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class von_mises_eqv_fc(Operator):
    """Computes the element-wise Von-Mises criteria on all the tensor fields
    of a fields container.

    Parameters
    ----------
    fields_container : FieldsContainer
    poisson_ratio : float or int
        Poisson ratio to be used in equivalent strain
        calculation.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.invariant.von_mises_eqv_fc()

    >>> # Make input connections
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_poisson_ratio = float()
    >>> op.inputs.poisson_ratio.connect(my_poisson_ratio)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.invariant.von_mises_eqv_fc(
    ...     fields_container=my_fields_container,
    ...     poisson_ratio=my_poisson_ratio,
    ... )

    >>> # Get output data
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(
        self, fields_container=None, poisson_ratio=None, config=None, server=None
    ):
        super().__init__(name="eqv_fc", config=config, server=server)
        self._inputs = InputsVonMisesEqvFc(self)
        self._outputs = OutputsVonMisesEqvFc(self)
        if fields_container is not None:
            self.inputs.fields_container.connect(fields_container)
        if poisson_ratio is not None:
            self.inputs.poisson_ratio.connect(poisson_ratio)

    @staticmethod
    def _spec():
        description = """Computes the element-wise Von-Mises criteria on all the tensor fields
            of a fields container."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
                13: PinSpecification(
                    name="poisson_ratio",
                    type_names=["double", "int32"],
                    optional=False,
                    document="""Poisson ratio to be used in equivalent strain
        calculation.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="fields_container",
                    type_names=["fields_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="eqv_fc", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsVonMisesEqvFc
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsVonMisesEqvFc
        """
        return super().outputs


class InputsVonMisesEqvFc(_Inputs):
    """Intermediate class used to connect user inputs to
    von_mises_eqv_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.invariant.von_mises_eqv_fc()
    >>> my_fields_container = dpf.FieldsContainer()
    >>> op.inputs.fields_container.connect(my_fields_container)
    >>> my_poisson_ratio = float()
    >>> op.inputs.poisson_ratio.connect(my_poisson_ratio)
    """

    def __init__(self, op: Operator):
        super().__init__(von_mises_eqv_fc._spec().inputs, op)
        self._fields_container = Input(von_mises_eqv_fc._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._fields_container)
        self._poisson_ratio = Input(von_mises_eqv_fc._spec().input_pin(13), 13, op, -1)
        self._inputs.append(self._poisson_ratio)

    @property
    def fields_container(self):
        """Allows to connect fields_container input to the operator.

        Parameters
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.invariant.von_mises_eqv_fc()
        >>> op.inputs.fields_container.connect(my_fields_container)
        >>> # or
        >>> op.inputs.fields_container(my_fields_container)
        """
        return self._fields_container

    @property
    def poisson_ratio(self):
        """Allows to connect poisson_ratio input to the operator.

        Poisson ratio to be used in equivalent strain
        calculation.

        Parameters
        ----------
        my_poisson_ratio : float or int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.invariant.von_mises_eqv_fc()
        >>> op.inputs.poisson_ratio.connect(my_poisson_ratio)
        >>> # or
        >>> op.inputs.poisson_ratio(my_poisson_ratio)
        """
        return self._poisson_ratio


class OutputsVonMisesEqvFc(_Outputs):
    """Intermediate class used to get outputs from
    von_mises_eqv_fc operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.invariant.von_mises_eqv_fc()
    >>> # Connect inputs : op.inputs. ...
    >>> result_fields_container = op.outputs.fields_container()
    """

    def __init__(self, op: Operator):
        super().__init__(von_mises_eqv_fc._spec().outputs, op)
        self._fields_container = Output(von_mises_eqv_fc._spec().output_pin(0), 0, op)
        self._outputs.append(self._fields_container)

    @property
    def fields_container(self):
        """Allows to get fields_container output of the operator

        Returns
        ----------
        my_fields_container : FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.invariant.von_mises_eqv_fc()
        >>> # Connect inputs : op.inputs. ...
        >>> result_fields_container = op.outputs.fields_container()
        """  # noqa: E501
        return self._fields_container
