"""
nodal_extend_to_mid_nodes
=========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class nodal_extend_to_mid_nodes(Operator):
    """Extends a Nodal field defined on corner nodes to a field defined also
    on mid nodes.

    Parameters
    ----------
    field : Field or FieldsContainer
        Field or fields container with only one field
        is expected
    node_scoping : Scoping, optional
        Nodes expected in output.
    element_scoping : Scoping, optional
        Precomputed list of elements of interest
        (improves performances).
    mesh : MeshedRegion, optional


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()

    >>> # Make input connections
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_node_scoping = dpf.Scoping()
    >>> op.inputs.node_scoping.connect(my_node_scoping)
    >>> my_element_scoping = dpf.Scoping()
    >>> op.inputs.element_scoping.connect(my_element_scoping)
    >>> my_mesh = dpf.MeshedRegion()
    >>> op.inputs.mesh.connect(my_mesh)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes(
    ...     field=my_field,
    ...     node_scoping=my_node_scoping,
    ...     element_scoping=my_element_scoping,
    ...     mesh=my_mesh,
    ... )

    >>> # Get output data
    >>> result_field = op.outputs.field()
    """

    def __init__(
        self,
        field=None,
        node_scoping=None,
        element_scoping=None,
        mesh=None,
        config=None,
        server=None,
    ):
        super().__init__(name="nodal_extend_to_mid_nodes", config=config, server=server)
        self._inputs = InputsNodalExtendToMidNodes(self)
        self._outputs = OutputsNodalExtendToMidNodes(self)
        if field is not None:
            self.inputs.field.connect(field)
        if node_scoping is not None:
            self.inputs.node_scoping.connect(node_scoping)
        if element_scoping is not None:
            self.inputs.element_scoping.connect(element_scoping)
        if mesh is not None:
            self.inputs.mesh.connect(mesh)

    @staticmethod
    def _spec():
        description = """Extends a Nodal field defined on corner nodes to a field defined also
            on mid nodes."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field", "fields_container"],
                    optional=False,
                    document="""Field or fields container with only one field
        is expected""",
                ),
                1: PinSpecification(
                    name="node_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""Nodes expected in output.""",
                ),
                5: PinSpecification(
                    name="element_scoping",
                    type_names=["scoping"],
                    optional=True,
                    document="""Precomputed list of elements of interest
        (improves performances).""",
                ),
                7: PinSpecification(
                    name="mesh",
                    type_names=["abstract_meshed_region"],
                    optional=True,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="nodal_extend_to_mid_nodes", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsNodalExtendToMidNodes
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsNodalExtendToMidNodes
        """
        return super().outputs


class InputsNodalExtendToMidNodes(_Inputs):
    """Intermediate class used to connect user inputs to
    nodal_extend_to_mid_nodes operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_node_scoping = dpf.Scoping()
    >>> op.inputs.node_scoping.connect(my_node_scoping)
    >>> my_element_scoping = dpf.Scoping()
    >>> op.inputs.element_scoping.connect(my_element_scoping)
    >>> my_mesh = dpf.MeshedRegion()
    >>> op.inputs.mesh.connect(my_mesh)
    """

    def __init__(self, op: Operator):
        super().__init__(nodal_extend_to_mid_nodes._spec().inputs, op)
        self._field = Input(nodal_extend_to_mid_nodes._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._field)
        self._node_scoping = Input(
            nodal_extend_to_mid_nodes._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._node_scoping)
        self._element_scoping = Input(
            nodal_extend_to_mid_nodes._spec().input_pin(5), 5, op, -1
        )
        self._inputs.append(self._element_scoping)
        self._mesh = Input(nodal_extend_to_mid_nodes._spec().input_pin(7), 7, op, -1)
        self._inputs.append(self._mesh)

    @property
    def field(self):
        """Allows to connect field input to the operator.

        Field or fields container with only one field
        is expected

        Parameters
        ----------
        my_field : Field or FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
        >>> op.inputs.field.connect(my_field)
        >>> # or
        >>> op.inputs.field(my_field)
        """
        return self._field

    @property
    def node_scoping(self):
        """Allows to connect node_scoping input to the operator.

        Nodes expected in output.

        Parameters
        ----------
        my_node_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
        >>> op.inputs.node_scoping.connect(my_node_scoping)
        >>> # or
        >>> op.inputs.node_scoping(my_node_scoping)
        """
        return self._node_scoping

    @property
    def element_scoping(self):
        """Allows to connect element_scoping input to the operator.

        Precomputed list of elements of interest
        (improves performances).

        Parameters
        ----------
        my_element_scoping : Scoping

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
        >>> op.inputs.element_scoping.connect(my_element_scoping)
        >>> # or
        >>> op.inputs.element_scoping(my_element_scoping)
        """
        return self._element_scoping

    @property
    def mesh(self):
        """Allows to connect mesh input to the operator.

        Parameters
        ----------
        my_mesh : MeshedRegion

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
        >>> op.inputs.mesh.connect(my_mesh)
        >>> # or
        >>> op.inputs.mesh(my_mesh)
        """
        return self._mesh


class OutputsNodalExtendToMidNodes(_Outputs):
    """Intermediate class used to get outputs from
    nodal_extend_to_mid_nodes operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
    >>> # Connect inputs : op.inputs. ...
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(nodal_extend_to_mid_nodes._spec().outputs, op)
        self._field = Output(nodal_extend_to_mid_nodes._spec().output_pin(0), 0, op)
        self._outputs.append(self._field)

    @property
    def field(self):
        """Allows to get field output of the operator

        Returns
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.averaging.nodal_extend_to_mid_nodes()
        >>> # Connect inputs : op.inputs. ...
        >>> result_field = op.outputs.field()
        """  # noqa: E501
        return self._field
