"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-apigateway-dynamodb');
stack.templateOptions.description = 'Integration Test for aws-apigateway-dynamodb';
// Definitions
const props = {
    allowReadOperation: true,
    allowCreateOperation: true,
    allowDeleteOperation: true,
    allowUpdateOperation: true,
    createRequestTemplate: "{\r\n  \"TableName\": \"${Table}\",\r\n  \"Item\": {\r\n    \"id\": {\r\n      \"S\": \"$input.path('$.id')\"\r\n    },\r\n    \"EventCount\": {\r\n      \"N\": \"$input.path('$.EventCount')\"\r\n    },\r\n    \"Message\": {\r\n      \"S\": \"$input.path('$.Message')\"\r\n    }\r\n  }\r\n}",
    updateRequestTemplate: "{\r\n  \"TableName\": \"${Table}\",\r\n  \"Key\": {\r\n    \"id\": {\r\n      \"S\": \"$input.path('$.id')\"\r\n    }\r\n  },\r\n  \"ExpressionAttributeValues\": {\r\n    \":event_count\": {\r\n      \"N\": \"$input.path('$.EventCount')\"\r\n    },\r\n    \":message\": {\r\n      \"S\": \"$input.path('$.Message')\"\r\n    }\r\n  },\r\n  \"UpdateExpression\": \"ADD EventCount :event_count SET Message = :message\",\r\n  \"ReturnValues\": \"ALL_NEW\"\r\n}"
};
new lib_1.ApiGatewayToDynamoDB(stack, 'test-api-gateway-dynamodb', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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