# coding: utf-8

"""
    STACKIT MongoDB Service API

    This is the documentation for the STACKIT MongoDB Flex Service API

    The version of the OpenAPI document: 2.0.0
    Contact: support@stackit.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from stackit.mongodbflex.models.shape import Shape
from stackit.mongodbflex.models.suggested_index import SuggestedIndex


class HandlersInstancesSuggestedIndexesResponse(BaseModel):
    """
    HandlersInstancesSuggestedIndexesResponse
    """  # noqa: E501

    shapes: Optional[List[Shape]] = Field(
        default=None,
        description="Documents with information about the query shapes that are served by the suggested indexes.",
    )
    suggested_indexes: Optional[List[SuggestedIndex]] = Field(
        default=None,
        description="Documents with information about the indexes suggested by the Performance Advisor.",
        alias="suggestedIndexes",
    )
    __properties: ClassVar[List[str]] = ["shapes", "suggestedIndexes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HandlersInstancesSuggestedIndexesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shapes (list)
        _items = []
        if self.shapes:
            for _item in self.shapes:
                if _item:
                    _items.append(_item.to_dict())
            _dict["shapes"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in suggested_indexes (list)
        _items = []
        if self.suggested_indexes:
            for _item in self.suggested_indexes:
                if _item:
                    _items.append(_item.to_dict())
            _dict["suggestedIndexes"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HandlersInstancesSuggestedIndexesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "shapes": (
                    [Shape.from_dict(_item) for _item in obj["shapes"]] if obj.get("shapes") is not None else None
                ),
                "suggestedIndexes": (
                    [SuggestedIndex.from_dict(_item) for _item in obj["suggestedIndexes"]]
                    if obj.get("suggestedIndexes") is not None
                    else None
                ),
            }
        )
        return _obj
