# FlowHive Agent

> 用户服务器代理 - FlowHive 分布式 GPU 任务调度平台的计算节点组件

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Python 3.10+](https://img.shields.io/badge/python-3.10+-blue.svg)](https://www.python.org/downloads/)
[![PyPI version](https://badge.fury.io/py/flowhive-agent.svg)](https://badge.fury.io/py/flowhive-agent)

## 概述

FlowHive Agent 是运行在 GPU 服务器上的计算节点组件。它通过 WebSocket 连接到控制服务器并处理以下任务：

- **节点注册与心跳**：自动向控制服务器注册并维持连接健康状态
- **任务执行**：接收并执行任务（Python 脚本、Shell 命令、分布式训练作业）
- **GPU 监控**：通过 NVML 实时采集 GPU 指标（利用率、显存、进程）
- **日志流式传输**：实时将 stdout/stderr 日志流式传输回控制服务器
- **资源管理**：基于 GPU 显存可用性和优先级的智能任务调度

## 目录结构

```
agent/
├── flowhive_agent/
│   ├── core/              # Agent 核心逻辑
│   │   ├── task.py        # 任务模型和状态机
│   │   ├── executor.py    # 任务执行引擎（subprocess、torchrun）
│   │   ├── task_manager.py # 任务调度器和管理器
│   │   └── gpu_monitor.py # 基于 NVML 的 GPU 监控
│   ├── cli/               # 命令行界面
│   │   └── flowhive.py    # 主 CLI 入口点
│   └── __init__.py
├── scripts/               # 演示和测试脚本
│   ├── demo_task_manager.py
│   └── demo_shell_test.py
├── tests/                 # Pytest 测试用例
├── pyproject.toml         # 包配置文件
├── requirements.txt       # Python 依赖
└── README.md
```

## 安装

### 方式一：从 PyPI 安装（推荐）

```bash
pip install flowhive-agent
```

### 方式二：从源码安装

```bash
# 克隆仓库
git clone https://github.com/Dramwig/FlowHive.git
cd FlowHive/agent

# 创建虚拟环境
python -m venv venv

# 激活虚拟环境
# Windows 系统：
venv\Scripts\activate
# Linux/macOS 系统：
source venv/bin/activate

# 安装依赖
pip install -r requirements.txt

# 以开发模式安装
pip install -e .
```

### 系统要求

- Python 3.10 或更高版本
- 带 CUDA 驱动的 NVIDIA GPU（用于 GPU 监控）
- 操作系统：Linux、Windows 或 macOS

## 快速开始

### 1. 配置 Agent

安装完成后，配置 Agent 以连接到控制服务器：

```bash
# 设置用户凭据
flowhive config user.username "your-username"
flowhive config user.email "your-email@example.com"
flowhive config user.password "your-password"

# 设置控制服务器 URL
flowhive config control_base_url "http://127.0.0.1:8001"

# 设置 Agent 标签（可选，用于标识）
flowhive config label "gpu-server-01"

# 验证配置
flowhive config
```

### 2. 启动 Agent

```bash
flowhive run
```

Agent 将会：
- 自动向控制服务器注册
- 启动 GPU 监控（如果有 NVIDIA GPU）
- 开始监听任务分配
- 发送周期性心跳

### 3. 本地测试（无需控制服务器）

如需在没有控制服务器的情况下快速测试任务执行：

```bash
cd agent
python scripts/demo_task_manager.py
```

运行自定义命令：

```bash
python scripts/demo_task_manager.py "python -c \"print('Hello FlowHive!')\"" --timeout 10
```

日志将保存到 `agent_logs/` 目录。

## 配置说明

### WebSocket 连接

Agent 通过 WebSocket 与控制服务器通信。协议会根据 `control_base_url` 自动确定：

- `http://` → `ws://`（明文 WebSocket）
- `https://` → `wss://`（安全 WebSocket，生产环境推荐）

### 生产环境配置示例

```bash
# 使用 HTTPS/WSS 进行安全通信（推荐）
flowhive config control_base_url "https://your-control-server.com"
flowhive config user.username "prod-user"
flowhive config user.password "secure-password"
flowhive config label "prod-gpu-node-01"
```

### 配置文件位置

配置文件存储在：
- **Linux/macOS**：`~/.config/flowhive/config.toml`
- **Windows**：`%USERPROFILE%\.config\flowhive\config.toml`

### 环境变量

您也可以使用环境变量（它们会覆盖配置文件）：

```bash
export FLOWHIVE_CONTROL_URL="http://127.0.0.1:8001"
export FLOWHIVE_USERNAME="your-username"
export FLOWHIVE_PASSWORD="your-password"
flowhive run
```

## 核心特性

### GPU 监控
- **实时指标**：GPU 利用率、显存使用、温度、功耗
- **进程跟踪**：每个进程的 GPU 显存分配
- **NVML 集成**：直接访问 NVIDIA 管理库
- **多 GPU 支持**：自动检测和监控所有可用 GPU

### 任务调度
- **显存感知调度**：基于可用 GPU 显存调度任务
- **优先级队列**：支持任务优先级和公平调度
- **并发执行**：资源允许时可同时运行多个任务
- **重试机制**：失败任务自动重试，支持可配置策略

### 任务执行
- **多种执行器**：支持 `subprocess`、`torchrun` 和 shell 命令
- **环境变量**：为每个任务注入自定义环境变量
- **容器支持**：在容器化环境中执行任务
- **分布式训练**：通过 `torchrun` 原生支持 PyTorch 分布式训练

### 可靠性
- **OOM 恢复**：自动检测和处理内存溢出错误
- **心跳服务**：与控制服务器定期健康检查（1-5秒间隔）
- **优雅关闭**：Agent 关闭时正确清理运行中的任务
- **日志流式传输**：实时将 stdout/stderr 流式传输到控制服务器

## 架构设计

```
┌─────────────────────────────────────────────────────────────┐
│                      FlowHive Agent                         │
├─────────────────────────────────────────────────────────────┤
│  ┌──────────────┐  ┌──────────────┐  ┌─────────────────┐  │
│  │   CLI 工具   │  │  任务管理器  │  │   GPU 监控器    │  │
│  │  (flowhive)  │  │              │  │    (NVML)       │  │
│  └──────┬───────┘  └──────┬───────┘  └────────┬────────┘  │
│         │                 │                    │            │
│         └─────────────────┼────────────────────┘            │
│                           │                                 │
│                  ┌────────▼────────┐                        │
│                  │  WebSocket      │                        │
│                  │  客户端         │                        │
│                  └────────┬────────┘                        │
└───────────────────────────┼─────────────────────────────────┘
                            │
                            │ ws:// 或 wss://
                            │
                  ┌─────────▼──────────┐
                  │   控制服务器       │
                  │  (FastAPI + WS)    │
                  └────────────────────┘
```

## CLI 命令

```bash
# 配置管理
flowhive config                          # 显示所有配置
flowhive config <key> <value>            # 设置配置值
flowhive config <key>                    # 获取配置值

# 运行 Agent
flowhive run                             # 启动 Agent 并连接到控制服务器

# 示例
flowhive config user.username "alice"
flowhive config control_base_url "https://control.example.com"
flowhive run
```

## 开发指南

### 运行测试

```bash
# 安装测试依赖
pip install pytest pytest-asyncio

# 运行所有测试
pytest tests/

# 运行特定测试
pytest tests/test_task_manager.py

# 运行测试并生成覆盖率报告
pytest --cov=flowhive_agent tests/
```

### 构建包

```bash
# 安装构建工具
pip install build twine

# 构建分发包
python -m build

# 上传到 PyPI（仅维护者）
twine upload dist/*
```

## 故障排查

### Agent 无法连接到控制服务器

1. 验证控制服务器正在运行且可访问
2. 检查 `control_base_url` 配置
3. 确保防火墙允许 WebSocket 连接
4. 检查日志中的连接错误

### GPU 监控不工作

1. 确保已安装 NVIDIA 驱动：`nvidia-smi`
2. 验证已安装 `nvidia-ml-py`：`pip list | grep nvidia-ml-py`
3. 检查 GPU 权限（可能需要以 root/管理员身份运行）

### 任务卡在队列中

1. 检查 GPU 显存可用性
2. 验证任务资源需求
3. 检查 Agent 日志中的错误
4. 确保 Agent 已连接到控制服务器

## 贡献指南

欢迎贡献！请随时提交 Pull Request。

1. Fork 本仓库
2. 创建您的特性分支（`git checkout -b feature/amazing-feature`）
3. 提交您的更改（`git commit -m 'Add some amazing feature'`）
4. 推送到分支（`git push origin feature/amazing-feature`）
5. 开启一个 Pull Request

## 相关项目

- [Control Server](../control-server/) - 中心调度和控制组件
- [Web Client](../web-client/) - 基于浏览器的可视化和管理界面
- [FlowHive 文档](../docs/) - 完整的平台文档

## 许可证

本 Agent 组件采用 **MIT 许可证**。详见 [LICENSE](./LICENSE)。

**注意**：这仅适用于 Agent 组件。Control Server 和 Web Client 是专有软件，不在此许可证范围内。

## 支持

- 📖 [文档](../docs/)
- 🐛 [问题追踪](https://github.com/Dramwig/FlowHive/issues)
- 💬 [讨论区](https://github.com/Dramwig/FlowHive/discussions)

---

由 FlowHive 团队用 ❤️ 制作
