# decompyle3 version 3.9.0
# Python bytecode version base 3.7.0 (3394)
# Decompiled from: Python 3.7.16 (default, Jan 17 2023, 09:28:58)
# [Clang 14.0.6 ]
# Embedded file name: output/Live/mac_universal_64_static/Release/python-bundle/MIDI Remote Scripts/Launchkey_MK3/elements.py
# Compiled at: 2023-11-21 10:21:18
# Size of source mod 2**32: 6357 bytes
from ableton.v2.base import depends
from ableton.v2.control_surface import MIDI_CC_TYPE, MIDI_NOTE_TYPE
from ableton.v2.control_surface.elements import ButtonMatrixElement
from novation import sysex
from novation.launchkey_elements import SESSION_WIDTH, LaunchkeyElements, create_button, create_encoder

from . import midi
from .rgb_button import RgbButtonElement
from .simple_display import SimpleDisplayElement


@depends(skin=None)
def create_rgb_button(identifier, name, msg_type=MIDI_CC_TYPE, **k):
    return RgbButtonElement(True, msg_type, 15, identifier, name=name, **k)


def create_display_element(command_bytes, name):
    return SimpleDisplayElement(command_bytes, (sysex.SYSEX_END_BYTE,), name=name)


def create_parameter_display_matrix(command_byte, start_index, name):
    return ButtonMatrixElement(
        rows=[
            [
                create_display_element((command_byte, start_index + index), f"{name}_Display_{index}")
                for index in range(8)
            ],
        ],
        name=(f"{name}_Displays"),
    )


class Elements(LaunchkeyElements):
    def __init__(self, *a, **k):
        (super().__init__)(*a, **k)
        self.fader_button_modes_button = create_button(45, "Fader_Button_Modes_Button")
        self.device_select_button = create_button(51, "Device_Select_Button")
        self.device_lock_button = create_button(52, "Device_Lock_Button")
        self.capture_midi_button = create_button(74, "Capture_MIDI_Button")
        self.quantize_button = create_button(75, "Quantize_Button")
        self.click_button = create_button(76, "Click_Button")
        self.undo_button = create_button(77, "Undo_Button")
        self.up_button = create_rgb_button(106, "Up_Button")
        self.down_button = create_rgb_button(107, "Down_Button")
        self.stop_button = create_button(116, "Stop_Button")
        self.loop_button = create_button(118, "Loop_Button")
        self.undo_button_with_shift = self.with_shift(self.undo_button)
        self.secondary_up_button = create_button(104, "")
        self.secondary_down_button = create_button(105, "")
        self.device_select_matrix = ButtonMatrixElement(
            rows=[
                [
                    create_button(
                        (offset + col_index),
                        (f"{col_index}_Device_Select_Button_{row_index}"),
                        msg_type=MIDI_NOTE_TYPE,
                        channel=0,
                    )
                    for col_index in range(SESSION_WIDTH)
                ]
                for row_index, offset in enumerate(range(64, 87, 16))
            ],
            name="Device_Select_Matrix",
        )
        self.fader_layout_switch = create_button(10, "Fader_Layout_Switch")
        self.fader_buttons = ButtonMatrixElement(
            rows=[[create_rgb_button(index + 37, f"Fader_Button_{index}") for index in range(SESSION_WIDTH)]],
            name="Fader_Button",
        )
        self.faders = ButtonMatrixElement(
            rows=[[create_encoder(index + 53, f"Fader_{index}") for index in range(SESSION_WIDTH)]],
            name="Faders",
        )
        self.master_fader = create_encoder(61, "Master_Fader")
        self.notification_display = ButtonMatrixElement(
            rows=[
                [
                    create_display_element(
                        midi.NOTIFICATION_DISPLAY_COMMAND_BYTES[index],
                        f"Notification_Display_Line_{index}",
                    )
                    for index in range(2)
                ],
            ],
            name="Notification_Display",
        )
        self.pot_parameter_name_displays = create_parameter_display_matrix(
            midi.PARAMETER_NAME_DISPLAY_COMMAND_BYTE,
            midi.POT_PARAMETER_DISPLAY_START_INDEX,
            "Pot_Parameter_Name",
        )
        self.pot_parameter_value_displays = create_parameter_display_matrix(
            midi.PARAMETER_VALUE_DISPLAY_COMMAND_BYTE,
            midi.POT_PARAMETER_DISPLAY_START_INDEX,
            "Pot_Parameter_Value",
        )
        self.fader_parameter_name_displays = create_parameter_display_matrix(
            midi.PARAMETER_NAME_DISPLAY_COMMAND_BYTE,
            midi.FADER_PARAMETER_DISPLAY_START_INDEX,
            "Fader_Parameter_Name",
        )
        self.fader_parameter_value_displays = create_parameter_display_matrix(
            midi.PARAMETER_VALUE_DISPLAY_COMMAND_BYTE,
            midi.FADER_PARAMETER_DISPLAY_START_INDEX,
            "Fader_Parameter_Value",
        )
        self.master_fader_parameter_name_display = create_display_element(
            (midi.PARAMETER_NAME_DISPLAY_COMMAND_BYTE, midi.MASTER_PARAMETER_DISPLAY_INDEX),
            "Master_Fader_Parameter_Name_Display",
        )
        self.master_fader_parameter_value_display = create_display_element(
            (midi.PARAMETER_VALUE_DISPLAY_COMMAND_BYTE, midi.MASTER_PARAMETER_DISPLAY_INDEX),
            "Master_Fader_Parameter_Value_Display",
        )

    def init_display_elements(self, is_88_key_model):
        display_header = midi.DISPLAY_HEADER_88_KEY if is_88_key_model else midi.DISPLAY_HEADER
        for element in vars(self).values():
            if isinstance(element, SimpleDisplayElement):
                element.initialize(display_header)
            if isinstance(element, ButtonMatrixElement):
                if isinstance(element[0], SimpleDisplayElement):
                    for sub_element in element:
                        sub_element.initialize(display_header)
