# decompyle3 version 3.9.0
# Python bytecode version base 3.7.0 (3394)
# Decompiled from: Python 3.7.16 (default, Jan 17 2023, 09:28:58)
# [Clang 14.0.6 ]
# Embedded file name: output/Live/mac_universal_64_static/Release/python-bundle/MIDI Remote Scripts/Komplete_Kontrol_S_Mk2/mixer_component.py
# Compiled at: 2023-11-21 10:21:18
# Size of source mod 2**32: 2195 bytes
from functools import partial

from _Komplete_Kontrol.mixer_component import MixerComponent as MixerComponentBase
from ableton.v2.control_surface.control.control import InputControl
from future.moves.itertools import zip_longest

from .meter_display_element import METERS_PER_SEGMENT


class MixerComponent(MixerComponentBase):
    selection_control = InputControl()
    mute_control = InputControl()
    solo_control = InputControl()

    def set_selected_track_volume_control(self, control):
        self._selected_strip.set_volume_control(control)

    def set_selected_track_pan_control(self, control):
        self._selected_strip.set_pan_control(control)

    def set_selected_track_type_display(self, control):
        self._selected_strip.track_type_display.set_control_element(control)

    def set_selected_track_muted_via_solo_display(self, control):
        self._selected_strip.track_muted_via_solo_display.set_control_element(control)

    def set_track_meter_display(self, display):
        for index, strip in enumerate(self._channel_strips):
            strip.set_meter_display_callback(
                partial(display.update_meter_display, index * METERS_PER_SEGMENT) if display else None,
            )

    def set_track_arm_displays(self, displays):
        for strip, display in zip_longest(self._channel_strips, displays or []):
            strip.track_arm_display.set_control_element(display)

    @selection_control.value
    def selection_control(self, index, _):
        if index in range(self._provider.num_tracks):
            self._channel_strips[index].select_track()

    @mute_control.value
    def mute_control(self, index, _):
        if index in range(self._provider.num_tracks):
            self._channel_strips[index].mute_track()

    @solo_control.value
    def solo_control(self, index, _):
        if index in range(self._provider.num_tracks):
            self._channel_strips[index].solo_track()
