# decompyle3 version 3.9.0
# Python bytecode version base 3.7.0 (3394)
# Decompiled from: Python 3.7.16 (default, Jan 17 2023, 09:28:58)
# [Clang 14.0.6 ]
# Embedded file name: output/Live/mac_universal_64_static/Release/python-bundle/MIDI Remote Scripts/Axiom_AIR_25_49_61/DeviceNavComponent.py
# Compiled at: 2023-11-21 10:21:18
# Size of source mod 2**32: 2433 bytes
import Live
from _Framework import ControlSurfaceComponent


class DeviceNavComponent(ControlSurfaceComponent):
    def __init__(self):
        ControlSurfaceComponent.__init__(self)
        self._left_button = None
        self._right_button = None

    def disconnect(self):
        if self._left_button is not None:
            self._left_button.remove_value_listener(self._nav_value)
            self._left_button = None
        if self._right_button is not None:
            self._right_button.remove_value_listener(self._nav_value)
            self._right_button = None

    def set_device_nav_buttons(self, left_button, right_button):
        identify_sender = True
        if self._left_button is not None:
            self._left_button.remove_value_listener(self._nav_value)
        self._left_button = left_button
        if self._left_button is not None:
            self._left_button.add_value_listener(self._nav_value, identify_sender)
        if self._right_button is not None:
            self._right_button.remove_value_listener(self._nav_value)
        self._right_button = right_button
        if self._right_button is not None:
            self._right_button.add_value_listener(self._nav_value, identify_sender)
        self.update()

    def on_enabled_changed(self):
        self.update()

    def _nav_value(self, value, sender):
        if self.is_enabled():
            if not sender.is_momentary() or value != 0:
                modifier_pressed = True
                if not (
                    self.application().view.is_view_visible("Detail")
                    and self.application().view.is_view_visible("Detail/DeviceChain")
                ):
                    self.application().view.show_view("Detail")
                    self.application().view.show_view("Detail/DeviceChain")
                else:
                    direction = Live.Application.Application.View.NavDirection.left
                    if sender == self._right_button:
                        direction = Live.Application.Application.View.NavDirection.right
                    self.application().view.scroll_view(direction, "Detail/DeviceChain", not modifier_pressed)
