# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateROInstanceRequest(JDCloudRequest):
    """
    创建MySQL的只读实例<br> - 仅支持MySQL<br> - 创建的只读实例跟主实例在同一个VPC同一个子网中<br> * 只读实例只支持按配置计费
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateROInstanceRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:createROInstance', 'POST', header, version)
        self.parameters = parameters


class CreateROInstanceParameters(object):

    def __init__(self, regionId, instanceId, instanceName, instanceClass, instanceStorageGB, azId, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        :param instanceName: 实例名称，具体规则可参见帮助中心文档:[名称及密码限制](../../../documentation/Database-and-Cache-Service/RDS/Introduction/Restrictions/SQLServer-Restrictions.md)
        :param instanceClass: 只读实例规格FlavorId
        :param instanceStorageGB: 磁盘空间
        :param azId: 可用区ID
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.instanceName = instanceName
        self.instanceClass = instanceClass
        self.instanceStorageType = None
        self.instanceStorageGB = instanceStorageGB
        self.azId = azId
        self.vpcId = None
        self.subnetId = None
        self.parameterGroup = None
        self.storageEncrypted = None
        self.count = None

    def setInstanceStorageType(self, instanceStorageType):
        """
        :param instanceStorageType: (Optional) 存储类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)，缺省值为：LOCAL_SSD
        """
        self.instanceStorageType = instanceStorageType

    def setVpcId(self, vpcId):
        """
        :param vpcId: (Optional) VPC的ID，如果没有填写就保持和常规实例一样的VPC
        """
        self.vpcId = vpcId

    def setSubnetId(self, subnetId):
        """
        :param subnetId: (Optional) 子网ID，如果没有填写就保持和常规实例一样的subnet
        """
        self.subnetId = subnetId

    def setParameterGroup(self, parameterGroup):
        """
        :param parameterGroup: (Optional) 参数组ID，缺省采用和常规实例一样的参数组
        """
        self.parameterGroup = parameterGroup

    def setStorageEncrypted(self, storageEncrypted):
        """
        :param storageEncrypted: (Optional) 实例数据加密(存储类型为云硬盘才支持数据加密)。false：不加密；true：加密。缺省为false。
        """
        self.storageEncrypted = storageEncrypted

    def setCount(self, count):
        """
        :param count: (Optional) 创建只读实例的数目,缺省为1
        """
        self.count = count

