# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Configuration']


class Configuration(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationConfigurationArgs']]]]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['ConfigurationDatastoreArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V1 DB configuration resource within OpenStack.

        ## Example Usage
        ### Configuration

        ```python
        import pulumi
        import pulumi_openstack as openstack

        test = openstack.database.Configuration("test",
            configurations=[openstack.database.ConfigurationConfigurationArgs(
                name="max_connections",
                value="200",
            )],
            datastore=openstack.database.ConfigurationDatastoreArgs(
                type="mysql",
                version="mysql-5.7",
            ),
            description="description")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationConfigurationArgs']]]] configurations: An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConfigurationDatastoreArgs']] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] name: Configuration parameter name. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['configurations'] = configurations
            if datastore is None and not opts.urn:
                raise TypeError("Missing required property 'datastore'")
            __props__['datastore'] = datastore
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__['description'] = description
            __props__['name'] = name
            __props__['region'] = region
        super(Configuration, __self__).__init__(
            'openstack:database/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationConfigurationArgs']]]]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['ConfigurationDatastoreArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationConfigurationArgs']]]] configurations: An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConfigurationDatastoreArgs']] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] name: Configuration parameter name. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["configurations"] = configurations
        __props__["datastore"] = datastore
        __props__["description"] = description
        __props__["name"] = name
        __props__["region"] = region
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationConfiguration']]]:
        """
        An array of configuration parameter name and value. Can be specified multiple times. The configuration object structure is documented below.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.ConfigurationDatastore']:
        """
        An array of database engine type and version. The datastore
        object structure is documented below. Changing this creates resource.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Configuration parameter name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the db instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "region")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

