"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @deprecated - use `StepFunctionsInvokeActivity`
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
//# sourceMappingURL=data:application/json;base64,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