import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) GitHubRepository resource interface.
 *
 * @experimental
 */
export interface IGitHubRepository extends cdk.IResource {
    /**
     * (experimental) the repository owner.
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) the repository name.
     *
     * @experimental
     */
    readonly repo: string;
}
/**
 * (experimental) Construction properties of {@link GitHubRepository}.
 *
 * @experimental
 */
export interface GitHubRepositoryProps {
    /**
     * (experimental) The GitHub user name for the owner of the GitHub repository to be created.
     *
     * If this
     * repository should be owned by a GitHub organization, provide its name
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repository you want to create in GitHub with AWS CloudFormation stack creation.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) The GitHub user's personal access token for the GitHub repository.
     *
     * @experimental
     */
    readonly accessToken: cdk.SecretValue;
    /**
     * (experimental) The name of the Amazon S3 bucket that contains the ZIP file with the content to be committed to the new repository.
     *
     * @experimental
     */
    readonly contentsBucket: s3.IBucket;
    /**
     * (experimental) The S3 object key or file name for the ZIP file.
     *
     * @experimental
     */
    readonly contentsKey: string;
    /**
     * (experimental) The object version of the ZIP file, if versioning is enabled for the Amazon S3 bucket.
     *
     * @default - not specified
     * @experimental
     */
    readonly contentsS3Version?: string;
    /**
     * (experimental) Indicates whether to enable issues for the GitHub repository.
     *
     * You can use GitHub issues to track information
     * and bugs for your repository.
     *
     * @default true
     * @experimental
     */
    readonly enableIssues?: boolean;
    /**
     * (experimental) Indicates whether the GitHub repository is a private repository.
     *
     * If so, you choose who can see and commit to
     * this repository.
     *
     * @default RepositoryVisibility.PUBLIC
     * @experimental
     */
    readonly visibility?: RepositoryVisibility;
    /**
     * (experimental) A comment or description about the new repository.
     *
     * This description is displayed in GitHub after the repository
     * is created.
     *
     * @default - no description
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) The GitHubRepository resource.
 *
 * @experimental
 */
export declare class GitHubRepository extends cdk.Resource implements IGitHubRepository {
    /**
     * (experimental) the repository owner.
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) the repository name.
     *
     * @experimental
     */
    readonly repo: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GitHubRepositoryProps);
}
/**
 * (experimental) Visibility of the GitHubRepository.
 *
 * @experimental
 */
export declare enum RepositoryVisibility {
    /**
     * (experimental) private repository.
     *
     * @experimental
     */
    PRIVATE = 0,
    /**
     * (experimental) public repository.
     *
     * @experimental
     */
    PUBLIC = 1
}
