"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedRotationType = exports.HostedRotation = exports.RotationSchedule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 *
 * @stability stable
 */
class RotationSchedule extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _d, _e;
        super(scope, id);
        if ((!props.rotationLambda && !props.hostedRotation) || (props.rotationLambda && props.hostedRotation)) {
            throw new Error('One of `rotationLambda` or `hostedRotation` must be specified.');
        }
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: (_d = props.rotationLambda) === null || _d === void 0 ? void 0 : _d.functionArn,
            hostedRotationLambda: (_e = props.hostedRotation) === null || _e === void 0 ? void 0 : _e.bind(props.secret, this),
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
        // Prevent secrets deletions when rotation is in place
        props.secret.denyAccountRootDelete();
    }
}
exports.RotationSchedule = RotationSchedule;
_a = JSII_RTTI_SYMBOL_1;
RotationSchedule[_a] = { fqn: "@aws-cdk/aws-secretsmanager.RotationSchedule", version: "1.109.0" };
/**
 * A hosted rotation.
 *
 * @stability stable
 */
class HostedRotation {
    constructor(type, props, masterSecret) {
        this.type = type;
        this.props = props;
        this.masterSecret = masterSecret;
        if (type.isMultiUser && !masterSecret) {
            throw new Error('The `masterSecret` must be specified when using the multi user scheme.');
        }
    }
    /**
     * MySQL Single User.
     *
     * @stability stable
     */
    static mysqlSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.MYSQL_SINGLE_USER, options);
    }
    /**
     * MySQL Multi User.
     *
     * @stability stable
     */
    static mysqlMultiUser(options) {
        return new HostedRotation(HostedRotationType.MYSQL_MULTI_USER, options, options.masterSecret);
    }
    /**
     * PostgreSQL Single User.
     *
     * @stability stable
     */
    static postgreSqlSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.POSTGRESQL_SINGLE_USER, options);
    }
    /**
     * PostgreSQL Multi User.
     *
     * @stability stable
     */
    static postgreSqlMultiUser(options) {
        return new HostedRotation(HostedRotationType.POSTGRESQL_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Oracle Single User.
     *
     * @stability stable
     */
    static oracleSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.ORACLE_SINGLE_USER, options);
    }
    /**
     * Oracle Multi User.
     *
     * @stability stable
     */
    static oracleMultiUser(options) {
        return new HostedRotation(HostedRotationType.ORACLE_MULTI_USER, options, options.masterSecret);
    }
    /**
     * MariaDB Single User.
     *
     * @stability stable
     */
    static mariaDbSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.MARIADB_SINGLE_USER, options);
    }
    /**
     * MariaDB Multi User.
     *
     * @stability stable
     */
    static mariaDbMultiUser(options) {
        return new HostedRotation(HostedRotationType.MARIADB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * SQL Server Single User.
     *
     * @stability stable
     */
    static sqlServerSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.SQLSERVER_SINGLE_USER, options);
    }
    /**
     * SQL Server Multi User.
     *
     * @stability stable
     */
    static sqlServerMultiUser(options) {
        return new HostedRotation(HostedRotationType.SQLSERVER_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Redshift Single User.
     *
     * @stability stable
     */
    static redshiftSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.REDSHIFT_SINGLE_USER, options);
    }
    /**
     * Redshift Multi User.
     *
     * @stability stable
     */
    static redshiftMultiUser(options) {
        return new HostedRotation(HostedRotationType.REDSHIFT_MULTI_USER, options, options.masterSecret);
    }
    /**
     * MongoDB Single User.
     *
     * @stability stable
     */
    static mongoDbSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.MONGODB_SINGLE_USER, options);
    }
    /**
     * MongoDB Multi User.
     *
     * @stability stable
     */
    static mongoDbMultiUser(options) {
        return new HostedRotation(HostedRotationType.MONGODB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Binds this hosted rotation to a secret.
     *
     * @stability stable
     */
    bind(secret, scope) {
        var _d, _e, _f, _g, _h, _j, _k;
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html
        core_1.Stack.of(scope).addTransform('AWS::SecretsManager-2020-07-23');
        if (!this.props.vpc && this.props.securityGroups) {
            throw new Error('`vpc` must be specified when specifying `securityGroups`.');
        }
        if (this.props.vpc) {
            this._connections = new ec2.Connections({
                securityGroups: this.props.securityGroups || [new ec2.SecurityGroup(scope, 'SecurityGroup', {
                        vpc: this.props.vpc,
                    })],
            });
        }
        // Prevent master secret deletion when rotation is in place
        if (this.masterSecret) {
            this.masterSecret.denyAccountRootDelete();
        }
        return {
            rotationType: this.type.name,
            kmsKeyArn: (_d = secret.encryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
            masterSecretArn: (_e = this.masterSecret) === null || _e === void 0 ? void 0 : _e.secretArn,
            masterSecretKmsKeyArn: (_g = (_f = this.masterSecret) === null || _f === void 0 ? void 0 : _f.encryptionKey) === null || _g === void 0 ? void 0 : _g.keyArn,
            rotationLambdaName: this.props.functionName,
            vpcSecurityGroupIds: (_j = (_h = this._connections) === null || _h === void 0 ? void 0 : _h.securityGroups) === null || _j === void 0 ? void 0 : _j.map(s => s.securityGroupId).join(','),
            vpcSubnetIds: (_k = this.props.vpc) === null || _k === void 0 ? void 0 : _k.selectSubnets(this.props.vpcSubnets).subnetIds.join(','),
        };
    }
    /**
     * Security group connections for this hosted rotation.
     *
     * @stability stable
     */
    get connections() {
        if (!this.props.vpc) {
            throw new Error('Cannot use connections for a hosted rotation that is not deployed in a VPC');
        }
        // If we are in a vpc and bind() has been called _connections should be defined
        if (!this._connections) {
            throw new Error('Cannot use connections for a hosted rotation that has not been bound to a secret');
        }
        return this._connections;
    }
}
exports.HostedRotation = HostedRotation;
_b = JSII_RTTI_SYMBOL_1;
HostedRotation[_b] = { fqn: "@aws-cdk/aws-secretsmanager.HostedRotation", version: "1.109.0" };
/**
 * Hosted rotation type.
 *
 * @stability stable
 */
class HostedRotationType {
    /**
     * @param name The type of rotation
     * @param isMultiUser Whether the rotation uses the mutli user scheme
     */
    constructor(name, isMultiUser) {
        this.name = name;
        this.isMultiUser = isMultiUser;
    }
}
exports.HostedRotationType = HostedRotationType;
_c = JSII_RTTI_SYMBOL_1;
HostedRotationType[_c] = { fqn: "@aws-cdk/aws-secretsmanager.HostedRotationType", version: "1.109.0" };
/**
 * MySQL Single User.
 *
 * @stability stable
 */
HostedRotationType.MYSQL_SINGLE_USER = new HostedRotationType('MySQLSingleUser');
/**
 * MySQL Multi User.
 *
 * @stability stable
 */
HostedRotationType.MYSQL_MULTI_USER = new HostedRotationType('MySQLMultiUser', true);
/**
 * PostgreSQL Single User.
 *
 * @stability stable
 */
HostedRotationType.POSTGRESQL_SINGLE_USER = new HostedRotationType('PostgreSQLSingleUser');
/**
 * PostgreSQL Multi User.
 *
 * @stability stable
 */
HostedRotationType.POSTGRESQL_MULTI_USER = new HostedRotationType('PostgreSQLMultiUser', true);
/**
 * Oracle Single User.
 *
 * @stability stable
 */
HostedRotationType.ORACLE_SINGLE_USER = new HostedRotationType('OracleSingleUser');
/**
 * Oracle Multi User.
 *
 * @stability stable
 */
HostedRotationType.ORACLE_MULTI_USER = new HostedRotationType('OracleMultiUser', true);
/**
 * MariaDB Single User.
 *
 * @stability stable
 */
HostedRotationType.MARIADB_SINGLE_USER = new HostedRotationType('MariaDBSingleUser');
/**
 * MariaDB Multi User.
 *
 * @stability stable
 */
HostedRotationType.MARIADB_MULTI_USER = new HostedRotationType('MariaDBMultiUser', true);
/**
 * SQL Server Single User.
 *
 * @stability stable
 */
HostedRotationType.SQLSERVER_SINGLE_USER = new HostedRotationType('SQLServerSingleUser');
/**
 * SQL Server Multi User.
 *
 * @stability stable
 */
HostedRotationType.SQLSERVER_MULTI_USER = new HostedRotationType('SQLServerMultiUser', true);
/**
 * Redshift Single User.
 *
 * @stability stable
 */
HostedRotationType.REDSHIFT_SINGLE_USER = new HostedRotationType('RedshiftSingleUser');
/**
 * Redshift Multi User.
 *
 * @stability stable
 */
HostedRotationType.REDSHIFT_MULTI_USER = new HostedRotationType('RedshiftMultiUser', true);
/**
 * MongoDB Single User.
 *
 * @stability stable
 */
HostedRotationType.MONGODB_SINGLE_USER = new HostedRotationType('MongoDBSingleUser');
/**
 * MongoDB Multi User.
 *
 * @stability stable
 */
HostedRotationType.MONGODB_MULTI_USER = new HostedRotationType('MongoDBMultiUser', true);
//# sourceMappingURL=data:application/json;base64,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