from tortoise import BaseDBAsyncClient


async def upgrade(db: BaseDBAsyncClient) -> str:
    return """
        CREATE TABLE IF NOT EXISTS `system_configs` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY,
    `creator_id` CHAR(36),
    `created_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `deleted_at` DATETIME(6),
    `name` VARCHAR(100) NOT NULL UNIQUE COMMENT '配置名称',
    `description` LONGTEXT   COMMENT '配置描述',
    `value` JSON NOT NULL  COMMENT '配置值',
    `type` VARCHAR(50) NOT NULL  COMMENT '配置类型'
) CHARACTER SET utf8mb4 COMMENT='系统配置表';
CREATE TABLE IF NOT EXISTS `system_files` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '文件唯一标识符',
    `creator_id` CHAR(36),
    `created_at` DATETIME(6) NOT NULL  COMMENT '上传时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `deleted_at` DATETIME(6),
    `name` VARCHAR(255) NOT NULL  COMMENT '文件名',
    `path` VARCHAR(255) NOT NULL  COMMENT 'MinIO 对象存储路径',
    `size` BIGINT NOT NULL  COMMENT '文件大小（字节）',
    `type` VARCHAR(50) NOT NULL  COMMENT '文件类型（MIME）',
    `status` INT NOT NULL  COMMENT '文件状态：1-正常，0-删除' DEFAULT 1,
    `description` LONGTEXT   COMMENT '文件描述'
) CHARACTER SET utf8mb4 COMMENT='文件模型';
CREATE TABLE IF NOT EXISTS `system_menus` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY,
    `creator_id` CHAR(36),
    `created_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `deleted_at` DATETIME(6),
    `name` VARCHAR(50) NOT NULL UNIQUE COMMENT '菜单名称',
    `path` VARCHAR(50) NOT NULL UNIQUE COMMENT '菜单路径',
    `component` VARCHAR(50) NOT NULL  COMMENT '组件路径',
    `locale` VARCHAR(50)   COMMENT '国际化',
    `redirect` VARCHAR(50)   COMMENT '重定向路径',
    `icon` VARCHAR(50)   COMMENT '图标',
    `requires_auth` BOOL NOT NULL  COMMENT '是否需要权限' DEFAULT 0,
    `order` INT NOT NULL  COMMENT '排序' DEFAULT 0,
    `hide_in_menu` BOOL NOT NULL  COMMENT '是否隐藏在菜单中' DEFAULT 0,
    `hide_children_in_menu` BOOL NOT NULL  COMMENT '是否隐藏子菜单' DEFAULT 0,
    `no_affix` BOOL NOT NULL  COMMENT '是否不固定在标签栏' DEFAULT 0,
    `ignore_cache` BOOL NOT NULL  COMMENT '是否不缓存' DEFAULT 0,
    `parent_id` CHAR(36)   COMMENT '父菜单ID'
) CHARACTER SET utf8mb4 COMMENT='菜单表';
CREATE TABLE IF NOT EXISTS `system_permissions` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY,
    `creator_id` CHAR(36),
    `created_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `deleted_at` DATETIME(6),
    `name` VARCHAR(100) NOT NULL UNIQUE COMMENT '权限名称',
    `identifier` VARCHAR(100) NOT NULL UNIQUE COMMENT '权限标识符',
    `module` VARCHAR(50) NOT NULL  COMMENT '所属模块',
    `description` LONGTEXT   COMMENT '权限描述'
) CHARACTER SET utf8mb4 COMMENT='权限表';
CREATE TABLE IF NOT EXISTS `system_roles` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY,
    `creator_id` CHAR(36),
    `created_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `deleted_at` DATETIME(6),
    `name` VARCHAR(50) NOT NULL UNIQUE COMMENT '角色名称',
    `identifier` VARCHAR(50) NOT NULL UNIQUE COMMENT '角色标识符',
    `description` LONGTEXT   COMMENT '角色描述',
    `is_active` BOOL NOT NULL  COMMENT '是否启用' DEFAULT 1,
    `is_default` BOOL NOT NULL  COMMENT '是否为默认角色' DEFAULT 0
) CHARACTER SET utf8mb4 COMMENT='角色表';
CREATE TABLE IF NOT EXISTS `system_users` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY,
    `creator_id` CHAR(36),
    `created_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `deleted_at` DATETIME(6),
    `username` VARCHAR(50) NOT NULL UNIQUE COMMENT '用户名',
    `email` VARCHAR(50) NOT NULL UNIQUE COMMENT '邮箱',
    `hashed_password` VARCHAR(255) NOT NULL  COMMENT '密码哈希',
    `avatar` VARCHAR(255)   COMMENT '头像',
    `is_active` BOOL NOT NULL  COMMENT '是否激活' DEFAULT 1,
    `is_superuser` BOOL NOT NULL  COMMENT '是否超级管理员' DEFAULT 0
) CHARACTER SET utf8mb4 COMMENT='用户表';
CREATE TABLE IF NOT EXISTS `algo_compute_nodes` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '计算节点唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '节点名称',
    `description` LONGTEXT   COMMENT '节点描述',
    `status` SMALLINT NOT NULL  COMMENT '节点状态' DEFAULT 2,
    `type` SMALLINT NOT NULL  COMMENT '节点类型',
    `ip_address` VARCHAR(50) NOT NULL  COMMENT '节点IP地址',
    `port` INT NOT NULL  COMMENT '节点端口',
    `resources` JSON NOT NULL  COMMENT '节点资源信息',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)
) CHARACTER SET utf8mb4 COMMENT='计算节点模型';
CREATE TABLE IF NOT EXISTS `algo_datasets` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '数据集唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '数据集名称',
    `description` LONGTEXT   COMMENT '数据集描述',
    `status` SMALLINT NOT NULL  COMMENT '数据集状态' DEFAULT 1,
    `storage_path` VARCHAR(255) NOT NULL  COMMENT '数据集文件存储路径',
    `metadata` JSON NOT NULL  COMMENT '数据集元数据信息',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)
) CHARACTER SET utf8mb4 COMMENT='数据集模型';
CREATE TABLE IF NOT EXISTS `algo_pipelines` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '管道唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '管道名称',
    `description` LONGTEXT   COMMENT '管道描述',
    `status` SMALLINT NOT NULL  COMMENT '管道状态' DEFAULT 1,
    `steps` JSON NOT NULL  COMMENT '管道步骤配置',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)
) CHARACTER SET utf8mb4 COMMENT='管道模型';
CREATE TABLE IF NOT EXISTS `algo_pipeline_steps` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '步骤唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '步骤名称',
    `type` SMALLINT NOT NULL  COMMENT '步骤类型',
    `config` JSON NOT NULL  COMMENT '步骤配置',
    `status` SMALLINT NOT NULL  COMMENT '步骤状态' DEFAULT 1,
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)
) CHARACTER SET utf8mb4 COMMENT='管道步骤模型';
CREATE TABLE IF NOT EXISTS `algo_projects` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '项目唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '项目名称',
    `description` LONGTEXT   COMMENT '项目描述',
    `status` SMALLINT NOT NULL  COMMENT '项目状态' DEFAULT 1,
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6)
) CHARACTER SET utf8mb4 COMMENT='项目模型';
CREATE TABLE IF NOT EXISTS `algo_models` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '模型唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '模型名称',
    `description` LONGTEXT   COMMENT '模型描述',
    `version` VARCHAR(50) NOT NULL  COMMENT '模型版本号',
    `type` SMALLINT NOT NULL  COMMENT '模型类型',
    `format` SMALLINT NOT NULL  COMMENT '模型格式',
    `status` SMALLINT NOT NULL  COMMENT '模型状态' DEFAULT 1,
    `storage_path` VARCHAR(255)   COMMENT '模型文件存储路径',
    `config` JSON NOT NULL  COMMENT '模型配置信息',
    `metrics` JSON   COMMENT '模型评估指标',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `project_id` CHAR(36) NOT NULL COMMENT '所属项目',
    CONSTRAINT `fk_algo_mod_algo_pro_91383ce5` FOREIGN KEY (`project_id`) REFERENCES `algo_projects` (`id`) ON DELETE CASCADE
) CHARACTER SET utf8mb4 COMMENT='模型信息模型';
CREATE TABLE IF NOT EXISTS `algo_inference_jobs` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '推理任务唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '任务名称',
    `description` LONGTEXT   COMMENT '任务描述',
    `status` SMALLINT NOT NULL  COMMENT '任务状态' DEFAULT 1,
    `type` SMALLINT NOT NULL  COMMENT '任务类型' DEFAULT 3,
    `input_path` VARCHAR(255) NOT NULL  COMMENT '输入数据路径',
    `output_path` VARCHAR(255)   COMMENT '输出结果路径',
    `config` JSON NOT NULL  COMMENT '推理配置信息',
    `results` JSON   COMMENT '推理结果',
    `logs` LONGTEXT   COMMENT '推理日志',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `model_id` CHAR(36) NOT NULL COMMENT '关联的模型',
    CONSTRAINT `fk_algo_inf_algo_mod_a763e97a` FOREIGN KEY (`model_id`) REFERENCES `algo_models` (`id`) ON DELETE CASCADE
) CHARACTER SET utf8mb4 COMMENT='推理任务模型';
CREATE TABLE IF NOT EXISTS `algo_model_exports` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '导出任务唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '任务名称',
    `description` LONGTEXT   COMMENT '任务描述',
    `status` SMALLINT NOT NULL  COMMENT '任务状态' DEFAULT 1,
    `format` SMALLINT NOT NULL  COMMENT '目标格式',
    `storage_path` VARCHAR(255)   COMMENT '导出文件存储路径',
    `config` JSON NOT NULL  COMMENT '导出配置信息',
    `logs` LONGTEXT   COMMENT '导出日志',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `model_id` CHAR(36) NOT NULL COMMENT '关联的模型',
    CONSTRAINT `fk_algo_mod_algo_mod_4ed3655f` FOREIGN KEY (`model_id`) REFERENCES `algo_models` (`id`) ON DELETE CASCADE
) CHARACTER SET utf8mb4 COMMENT='模型导出模型';
CREATE TABLE IF NOT EXISTS `algo_training_jobs` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '训练任务唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '任务名称',
    `description` LONGTEXT   COMMENT '任务描述',
    `status` SMALLINT NOT NULL  COMMENT '任务状态' DEFAULT 1,
    `hyperparameters` JSON NOT NULL  COMMENT '超参数配置',
    `metrics` JSON   COMMENT '训练指标',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `dataset_id` CHAR(36) NOT NULL COMMENT '训练数据集',
    `model_id` CHAR(36) NOT NULL COMMENT '关联的模型',
    CONSTRAINT `fk_algo_tra_algo_dat_a0f4546a` FOREIGN KEY (`dataset_id`) REFERENCES `algo_datasets` (`id`) ON DELETE CASCADE,
    CONSTRAINT `fk_algo_tra_algo_mod_4581b14f` FOREIGN KEY (`model_id`) REFERENCES `algo_models` (`id`) ON DELETE CASCADE
) CHARACTER SET utf8mb4 COMMENT='训练任务模型';
CREATE TABLE IF NOT EXISTS `algo_validation_jobs` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '验证任务唯一标识符',
    `name` VARCHAR(100) NOT NULL  COMMENT '任务名称',
    `description` LONGTEXT   COMMENT '任务描述',
    `status` SMALLINT NOT NULL  COMMENT '任务状态' DEFAULT 1,
    `type` SMALLINT NOT NULL  COMMENT '任务类型' DEFAULT 2,
    `config` JSON NOT NULL  COMMENT '验证配置信息',
    `metrics` JSON   COMMENT '验证指标',
    `logs` LONGTEXT   COMMENT '验证日志',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `dataset_id` CHAR(36) NOT NULL COMMENT '验证数据集',
    `model_id` CHAR(36) NOT NULL COMMENT '关联的模型',
    CONSTRAINT `fk_algo_val_algo_dat_f5824ce4` FOREIGN KEY (`dataset_id`) REFERENCES `algo_datasets` (`id`) ON DELETE CASCADE,
    CONSTRAINT `fk_algo_val_algo_mod_2bb0da7b` FOREIGN KEY (`model_id`) REFERENCES `algo_models` (`id`) ON DELETE CASCADE
) CHARACTER SET utf8mb4 COMMENT='验证任务模型';
CREATE TABLE IF NOT EXISTS `media_resources` (
    `id` CHAR(36) NOT NULL  PRIMARY KEY COMMENT '视频唯一标识符',
    `name` VARCHAR(255) NOT NULL  COMMENT '视频名称',
    `type` SMALLINT NOT NULL  COMMENT '视频类型：1-上传，2-外部流',
    `origin_url` VARCHAR(1024)   COMMENT '原始外部流地址',
    `status` INT NOT NULL  COMMENT '视频状态' DEFAULT 1,
    `description` LONGTEXT   COMMENT '视频描述',
    `config` JSON   COMMENT 'ZLMediaKit相关配置',
    `created_at` DATETIME(6) NOT NULL  COMMENT '创建时间' DEFAULT CURRENT_TIMESTAMP(6),
    `updated_at` DATETIME(6) NOT NULL  COMMENT '更新时间' DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
    `file_id` CHAR(36) COMMENT '上传视频文件',
    CONSTRAINT `fk_media_re_system_f_2c44ff4f` FOREIGN KEY (`file_id`) REFERENCES `system_files` (`id`) ON DELETE CASCADE
) CHARACTER SET utf8mb4;
CREATE TABLE IF NOT EXISTS `aerich` (
    `id` INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `version` VARCHAR(255) NOT NULL,
    `app` VARCHAR(100) NOT NULL,
    `content` JSON NOT NULL
) CHARACTER SET utf8mb4;
CREATE TABLE IF NOT EXISTS `system_role_menus` (
    `system_roles_id` CHAR(36) NOT NULL,
    `menu_id` CHAR(36) NOT NULL,
    FOREIGN KEY (`system_roles_id`) REFERENCES `system_roles` (`id`) ON DELETE CASCADE,
    FOREIGN KEY (`menu_id`) REFERENCES `system_menus` (`id`) ON DELETE CASCADE,
    UNIQUE KEY `uidx_system_role_system__0e615e` (`system_roles_id`, `menu_id`)
) CHARACTER SET utf8mb4 COMMENT='角色菜单';
CREATE TABLE IF NOT EXISTS `system_role_permissions` (
    `system_roles_id` CHAR(36) NOT NULL,
    `permission_id` CHAR(36) NOT NULL,
    FOREIGN KEY (`system_roles_id`) REFERENCES `system_roles` (`id`) ON DELETE CASCADE,
    FOREIGN KEY (`permission_id`) REFERENCES `system_permissions` (`id`) ON DELETE CASCADE,
    UNIQUE KEY `uidx_system_role_system__976215` (`system_roles_id`, `permission_id`)
) CHARACTER SET utf8mb4 COMMENT='角色权限';
CREATE TABLE IF NOT EXISTS `system_user_roles` (
    `system_users_id` CHAR(36) NOT NULL,
    `role_id` CHAR(36) NOT NULL,
    FOREIGN KEY (`system_users_id`) REFERENCES `system_users` (`id`) ON DELETE CASCADE,
    FOREIGN KEY (`role_id`) REFERENCES `system_roles` (`id`) ON DELETE CASCADE,
    UNIQUE KEY `uidx_system_user_system__4640af` (`system_users_id`, `role_id`)
) CHARACTER SET utf8mb4 COMMENT='用户角色';"""


async def downgrade(db: BaseDBAsyncClient) -> str:
    return """
        """
