import uvicorn

from algo_flow.app.main import make_app
from algo_flow.cores.config import settings
from algo_flow.cores.log import LOG

if __name__ == "__main__":
    app = make_app()

    try:
        uvicorn.run(
            app,
            host=settings.app.host,
            port=settings.app.port,
            log_config=None,
        )
    except KeyboardInterrupt:
        LOG.info("Shutdown requested")
