from fastapi import FastAPI
from fastapi.testclient import TestClient

from algo_flow.app.algo.urls import router as algo_router


def test_algo_router():
    """测试算法模块路由配置"""
    app = FastAPI()
    app.include_router(algo_router, prefix="/algo")
    client = TestClient(app)

    # 测试各个子路由是否正确配置
    routes = ["/algo/projects", "/algo/models", "/algo/datasets", "/algo/training", "/algo/compute"]

    for route in routes:
        response = client.get(route)
        # 即使返回 401（未认证），也说明路由配置正确
        assert response.status_code in [401, 403, 404]
