import argparse
import asyncio

from rq import Worker

from algo_flow.cores.model import close_db, init_db
from algo_flow.cores.redis import REDIS_RQ

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Start an RQ worker.")
    parser.add_argument(
        "queue", nargs="?", default="default", type=str, help="The name of the queue to work on"
    )
    args = parser.parse_args()

    asyncio.run(init_db())  # 启动时初始化数据库
    try:
        w = Worker([args.queue], connection=REDIS_RQ)
        w.work()
    finally:
        asyncio.run(close_db())  # 退出时关闭数据库
