import threading
import time

import nacos

from algo_flow.cores.config import settings
from algo_flow.cores.log import LOG

NACOS_CLIENT = nacos.NacosClient(
    server_addresses=settings.nacos.server_addr,
    namespace=settings.nacos.namespace,
    username=settings.nacos.username,
    password=settings.nacos.password,
)

servers = NACOS_CLIENT.get_server()


def register_instance():
    service_name = f"{settings.app.service_name}-{settings.app.environment}"
    NACOS_CLIENT.add_naming_instance(service_name, settings.app.ip, settings.app.port)


def deregister_instance():
    service_name = f"{settings.app.service_name}-{settings.app.environment}"
    NACOS_CLIENT.add_naming_instance(service_name, settings.app.ip, settings.app.port)


def heartbeat(service_name=None, interval=10):
    service_name = f"{settings.app.service_name}-{settings.app.environment}"
    service_name = service_name or f"{settings.app.service_name}-{settings.app.environment}"
    ip = settings.app.ip
    port = settings.app.port

    def _loop():
        while True:
            try:
                NACOS_CLIENT.send_heartbeat(service_name, ip, port)
                LOG.debug(f"heartbeat for {ip}:{port}")
            except Exception as e:
                LOG.error(f"心跳失败: {e}")
            time.sleep(interval)

    t = threading.Thread(target=_loop, daemon=True)
    t.start()
